/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.votable.VOTableFitsTableWriter;

public class FitsPlusTableWriter
extends VOTableFitsTableWriter {
    private final WideFits wide_;

    public FitsPlusTableWriter() {
        this("fits-plus", WideFits.DEFAULT);
    }

    public FitsPlusTableWriter(String name, WideFits wide) {
        super(name);
        this.wide_ = wide;
    }

    public boolean looksLikeFile(String location) {
        String exten;
        int dotPos = location.lastIndexOf(46);
        return dotPos > 0 && (exten = location.substring(dotPos + 1).toLowerCase()).startsWith("fit");
    }

    @Override
    protected void customisePrimaryHeader(Header hdr) throws HeaderCardException {
        hdr.addValue("VOTMETA", true, "Table metadata in VOTable format");
    }

    @Override
    protected boolean isMagic(int icard, String key, String value) {
        switch (icard) {
            case 4: {
                return "VOTMETA".equals(key) && "T".equals(value);
            }
        }
        return super.isMagic(icard, key, value);
    }

    protected FitsTableSerializer createSerializer(StarTable table) throws IOException {
        return new StandardFitsTableSerializer(table, false, this.wide_);
    }

    public static StarTableWriter[] getStarTableWriters() {
        FitsPlusTableWriter w1 = new FitsPlusTableWriter();
        FitsPlusTableWriter w2 = new FitsPlusTableWriter();
        w1.setFormatName("fits");
        return new StarTableWriter[]{w1, w2};
    }
}

