/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.NumericDecoder;

class LongDecoder
extends NumericDecoder {
    private long bad;
    private boolean hasBad = false;

    LongDecoder(Class clazz, long[] arraysize) {
        super(clazz, arraysize, 8);
    }

    LongDecoder(long[] arraysize) {
        this(long[].class, arraysize);
    }

    @Override
    void setNullValue(String txt) {
        this.bad = LongDecoder.parseLong(txt);
        this.hasBad = true;
    }

    @Override
    Object getEmptyArray(int size) {
        return new long[size];
    }

    @Override
    void decodeString1(Object array, int index, String txt) {
        ((long[])array)[index] = LongDecoder.parseLong(txt);
    }

    @Override
    void decodeStream1(Object array, int index, DataInput strm) throws IOException {
        ((long[])array)[index] = strm.readLong();
    }

    @Override
    void setBad1(Object array, int index) {
        ((long[])array)[index] = this.bad;
    }

    @Override
    public boolean isNull(Object array, int index) {
        return this.hasBad && ((long[])array)[index] == this.bad;
    }
}

