/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.QueueTableSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.SkeletonDOMBuilder;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VOStarTable;

class MultiTableStreamer
extends SkeletonDOMBuilder
implements TableHandler {
    private final StoragePolicy storage_;
    private final QueueTableSequence tqueue_;
    private final Namespacing namespacing_;
    private volatile boolean isVotable_;
    private RowStore rowStore_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    public MultiTableStreamer(StoragePolicy storage, QueueTableSequence tqueue, boolean strict) {
        super(strict);
        this.storage_ = storage;
        this.tqueue_ = tqueue;
        this.namespacing_ = Namespacing.getInstance();
        this.setTableHandler(this);
    }

    @Override
    public void startTable(StarTable meta) throws SAXException {
        try {
            this.rowStore_ = this.storage_.makeRowStore();
            this.rowStore_.acceptMetadata(meta);
        }
        catch (IOException e) {
            this.tqueue_.addError(e);
            this.rowStore_ = null;
        }
    }

    @Override
    public void rowData(Object[] row) throws SAXException {
        if (this.rowStore_ != null) {
            try {
                this.rowStore_.acceptRow(row);
            }
            catch (IOException e) {
                this.tqueue_.addError(e);
                this.rowStore_ = null;
            }
        }
    }

    @Override
    public void endTable() throws SAXException {
        if (this.rowStore_ != null) {
            Object table = null;
            try {
                this.rowStore_.endRows();
                this.tqueue_.addTable(this.rowStore_.getStarTable());
            }
            catch (IOException e) {
                this.tqueue_.addError(e);
            }
            this.rowStore_ = null;
        }
    }

    @Override
    protected void processBinaryHref(URL url, Attributes atts, boolean isBinary2) throws SAXException {
        TableElement tableEl = this.getTableElement();
        if (tableEl != null) {
            try {
                String encoding = this.getAttribute(atts, "encoding");
                Decoder[] decoders = MultiTableStreamer.getDecoders(tableEl.getFields());
                TableBodies.HrefBinaryTabularData tdata = new TableBodies.HrefBinaryTabularData(decoders, url, encoding, isBinary2);
                tableEl.setData(tdata);
                this.tqueue_.addTable(new VOStarTable(tableEl));
            }
            catch (IOException e) {
                this.tqueue_.addError(e);
            }
        }
    }

    @Override
    protected void processFitsHref(URL url, String extnum, Attributes atts) throws SAXException {
        TableElement tableEl = this.getTableElement();
        if (tableEl != null) {
            try {
                DataSource datsrc = DataSource.makeDataSource(url);
                datsrc.setPosition(extnum);
                StarTable ft = new FitsTableBuilder().makeStarTable(datsrc, false, this.storage_);
                TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(ft);
                tableEl.setData(tdata);
                this.tqueue_.addTable(new VOStarTable(tableEl));
            }
            catch (IOException e) {
                this.tqueue_.addError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.isVotable_ && "VOTABLE".equals(this.getVOTagName(namespaceURI, localName, qName))) {
            this.isVotable_ = true;
            MultiTableStreamer multiTableStreamer = this;
            synchronized (multiTableStreamer) {
                this.notifyAll();
            }
        }
        super.startElement(namespaceURI, localName, qName, atts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableSequence streamStarTables(final InputSource saxsrc, StoragePolicy storage, boolean strict) throws SAXException, IOException {
        XMLReader parser;
        final QueueTableSequence tqueue = new QueueTableSequence();
        final MultiTableStreamer streamer = new MultiTableStreamer(storage, tqueue, strict);
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            streamer.namespacing_.configureSAXParserFactory(spfact);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage(), e).initCause(e);
        }
        parser.setContentHandler(streamer);
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        final boolean[] doneHolder = new boolean[1];
        Thread worker = new Thread("VOTable streamer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    parser.parse(saxsrc);
                }
                catch (Throwable e) {
                    tqueue.addError(e);
                }
                finally {
                    tqueue.endSequence();
                    MultiTableStreamer multiTableStreamer = streamer;
                    synchronized (multiTableStreamer) {
                        doneHolder[0] = true;
                        streamer.notifyAll();
                    }
                }
            }
        };
        worker.setDaemon(true);
        worker.start();
        MultiTableStreamer multiTableStreamer = streamer;
        synchronized (multiTableStreamer) {
            while (!streamer.isVotable_ && !doneHolder[0]) {
                try {
                    streamer.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
        if (!streamer.isVotable_) {
            throw new TableFormatException("No VOTABLE element");
        }
        return tqueue;
    }
}

