/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.starlink.votable.Decoder;

abstract class NumericDecoder
extends Decoder {
    private final int size1_;

    NumericDecoder(Class clazz, long[] arraysize, int size1) {
        super(clazz, arraysize);
        this.size1_ = size1;
    }

    abstract Object getEmptyArray(int var1);

    abstract void setBad1(Object var1, int var2);

    abstract void decodeString1(Object var1, int var2, String var3);

    abstract void decodeStream1(Object var1, int var2, DataInput var3) throws IOException;

    Object packageArray(Object array) {
        return array;
    }

    @Override
    public Object decodeString(String txt) {
        StringTokenizer st = new StringTokenizer(txt);
        int ntok = st.countTokens();
        int ncell = this.numCells(ntok);
        Object result = this.getEmptyArray(ncell);
        for (int i = 0; i < ncell; ++i) {
            if (i < ntok) {
                String tok = st.nextToken().trim();
                if (!tok.equals(this.blankString)) {
                    try {
                        this.decodeString1(result, i, tok);
                    }
                    catch (IllegalArgumentException e) {
                        this.setBad1(result, i);
                    }
                    continue;
                }
                this.setBad1(result, i);
                continue;
            }
            this.setBad1(result, i);
        }
        return this.packageArray(result);
    }

    @Override
    public Object decodeStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        Object result = this.getEmptyArray(num);
        for (int i = 0; i < num; ++i) {
            this.decodeStream1(result, i, strm);
        }
        return this.packageArray(result);
    }

    @Override
    public void skipStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        NumericDecoder.skipBytes(strm, num * this.size1_);
    }

    Object scalarDecodeString(String txt) {
        if (txt == null || txt.length() == 0) {
            return null;
        }
        Object array = this.getEmptyArray(1);
        try {
            this.decodeString1(array, 0, txt.trim());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.packageArray(array);
    }

    static short parseShort(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Short.parseShort(txt.substring(pos + 2), 16);
        }
        return Short.parseShort(txt);
    }

    static int parseInt(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Integer.parseInt(txt.substring(pos + 2), 16);
        }
        return Integer.parseInt(txt);
    }

    static long parseLong(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Long.parseLong(txt.substring(pos + 2), 16);
        }
        return Long.parseLong(txt);
    }

    static float parseFloat(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos == 0) {
            return Float.NaN;
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'I' && txt.indexOf("Inf") == 1) {
            return txt.charAt(pos) == '-' ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return Float.parseFloat(txt);
    }

    static double parseDouble(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos == 0) {
            return Double.NaN;
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'I' && txt.indexOf("Inf") == 1) {
            return txt.charAt(pos) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(txt);
    }
}

