/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.NumericDecoder;

class ShortDecoder
extends NumericDecoder {
    private short bad;
    private boolean hasBad = false;

    ShortDecoder(long[] arraysize) {
        this(short[].class, arraysize, 2);
    }

    ShortDecoder(Class clazz, long[] arraysize, int size1) {
        super(clazz, arraysize, size1);
    }

    @Override
    void setNullValue(String txt) {
        this.bad = ShortDecoder.parseShort(txt);
        this.hasBad = true;
    }

    @Override
    Object getEmptyArray(int size) {
        return new short[size];
    }

    @Override
    void decodeString1(Object array, int index, String txt) {
        ((short[])array)[index] = ShortDecoder.parseShort(txt);
    }

    @Override
    void decodeStream1(Object array, int index, DataInput strm) throws IOException {
        ((short[])array)[index] = strm.readShort();
    }

    @Override
    void setBad1(Object array, int index) {
        ((short[])array)[index] = this.bad;
    }

    @Override
    public boolean isNull(Object array, int index) {
        return this.hasBad && ((short[])array)[index] == this.bad;
    }
}

