/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.util.Base64InputStream;
import uk.ac.starlink.util.PipeReaderThread;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.BinaryRowSequence;
import uk.ac.starlink.votable.CustomDOMBuilder;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.TableHandlerSink;

abstract class SkeletonDOMBuilder
extends CustomDOMBuilder {
    private final ContentHandler basicHandler_ = new BasicContentHandler();
    private final ContentHandler defaultHandler_ = new CustomDOMBuilder.DefaultContentHandler();
    private TableHandler tableHandler_;
    private String systemId_;
    private TableElement tableEl_;

    public SkeletonDOMBuilder(boolean strict) {
        super(strict);
        this.setCustomHandler(this.basicHandler_);
    }

    public void setTableHandler(TableHandler tableHandler) {
        this.tableHandler_ = tableHandler;
    }

    public TableHandler getTableHandler() {
        return this.tableHandler_;
    }

    protected abstract void processFitsHref(URL var1, String var2, Attributes var3) throws SAXException;

    protected abstract void processBinaryHref(URL var1, Attributes var2, boolean var3) throws SAXException;

    protected TableElement getTableElement() {
        return this.tableEl_;
    }

    static Decoder[] getDecoders(FieldElement[] fields) {
        int ncol = fields.length;
        Decoder[] decoders = new Decoder[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            decoders[icol] = fields[icol].getDecoder();
        }
        return decoders;
    }

    private class InlineFITSStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        final PipeReaderThread reader_;
        final Writer out_;

        public InlineFITSStreamHandler(String extnum) throws IOException, SAXException {
            assert (SkeletonDOMBuilder.this.tableHandler_ != null);
            assert (SkeletonDOMBuilder.this.tableEl_ != null);
            if (extnum != null && !extnum.matches("[0-9]+")) {
                extnum = null;
            }
            final TableHandlerSink sink = new TableHandlerSink(SkeletonDOMBuilder.this.tableHandler_, SkeletonDOMBuilder.this.tableEl_.getMetadataTable());
            final String ihdu = extnum;
            this.reader_ = new PipeReaderThread(){

                @Override
                protected void doReading(InputStream datain) throws IOException {
                    Base64InputStream in = new Base64InputStream(new BufferedInputStream(datain));
                    new FitsTableBuilder().streamStarTable((InputStream)in, sink, ihdu);
                }
            };
            OutputStream b64out = this.reader_.getOutputStream();
            this.out_ = new OutputStreamWriter(new BufferedOutputStream(b64out));
            this.reader_.start();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            throw new SAXParseException("Unwelcome child <" + tagName + "> of STREAM", SkeletonDOMBuilder.this.getLocator());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out_.write(ch, start, length);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), SkeletonDOMBuilder.this.getLocator(), e).initCause(e);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                SkeletonDOMBuilder.this.defaultHandler_.endElement(namespaceURI, localName, qName);
                SkeletonDOMBuilder.this.setCustomHandler(SkeletonDOMBuilder.this.basicHandler_);
                try {
                    this.out_.close();
                    this.reader_.finishReading();
                }
                catch (IOException e) {
                    if (e.getCause() instanceof SAXException) {
                        throw (SAXException)e.getCause();
                    }
                    throw (SAXException)new SAXParseException(e.getMessage(), SkeletonDOMBuilder.this.getLocator(), e).initCause(e);
                }
            }
        }
    }

    private class InlineBinaryStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        final PipeReaderThread reader_;
        final Writer out_;

        public InlineBinaryStreamHandler(final boolean isBinary2) throws IOException, SAXException {
            assert (SkeletonDOMBuilder.this.tableHandler_ != null);
            assert (SkeletonDOMBuilder.this.tableEl_ != null);
            FieldElement[] fields = SkeletonDOMBuilder.this.tableEl_.getFields();
            final Decoder[] decoders = SkeletonDOMBuilder.getDecoders(fields);
            SkeletonDOMBuilder.this.tableHandler_.startTable(SkeletonDOMBuilder.this.tableEl_.getMetadataTable());
            this.reader_ = new PipeReaderThread(){

                @Override
                protected void doReading(InputStream datain) throws IOException {
                    BufferedInputStream in = new BufferedInputStream(datain);
                    BinaryRowSequence rseq = new BinaryRowSequence(decoders, in, "base64", isBinary2);
                    try {
                        while (rseq.next()) {
                            SkeletonDOMBuilder.this.tableHandler_.rowData(rseq.getRow());
                        }
                    }
                    catch (SAXException e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    catch (OutOfMemoryError e) {
                        SkeletonDOMBuilder.this.tableHandler_ = null;
                        throw e;
                    }
                    finally {
                        rseq.close();
                    }
                }
            };
            OutputStream b64out = this.reader_.getOutputStream();
            this.out_ = new OutputStreamWriter(new BufferedOutputStream(b64out));
            this.reader_.start();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            throw new SAXParseException("Unwelcome child <" + tagName + "> of STREAM", SkeletonDOMBuilder.this.getLocator());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out_.write(ch, start, length);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), SkeletonDOMBuilder.this.getLocator(), e).initCause(e);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                SkeletonDOMBuilder.this.defaultHandler_.endElement(namespaceURI, localName, qName);
                SkeletonDOMBuilder.this.setCustomHandler(SkeletonDOMBuilder.this.basicHandler_);
                try {
                    this.out_.close();
                    this.reader_.finishReading();
                    SkeletonDOMBuilder.this.tableHandler_.endTable();
                }
                catch (IOException e) {
                    if (e.getCause() instanceof SAXException) {
                        throw (SAXException)e.getCause();
                    }
                    throw (SAXException)new SAXParseException(e.getMessage(), SkeletonDOMBuilder.this.getLocator(), e).initCause(e);
                }
            }
        }
    }

    private class TabledataHandler
    extends CustomDOMBuilder.NullContentHandler {
        final Decoder[] decoders_;
        final int ncol_;
        StringBuffer cell_;
        Object[] row_;
        int icol_;
        boolean inCell_;

        TabledataHandler() throws SAXException {
            FieldElement[] fields = SkeletonDOMBuilder.this.tableEl_.getFields();
            this.ncol_ = fields.length;
            this.decoders_ = SkeletonDOMBuilder.getDecoders(fields);
            this.cell_ = new StringBuffer();
            Element tabledataEl = (Element)SkeletonDOMBuilder.this.getNewestNode();
            String comment = "Invisible data nodes were parsed directly";
            tabledataEl.appendChild(tabledataEl.getOwnerDocument().createComment(comment));
            if (SkeletonDOMBuilder.this.tableHandler_ != null) {
                SkeletonDOMBuilder.this.tableHandler_.startTable(SkeletonDOMBuilder.this.tableEl_.getMetadataTable());
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if ("TD".equals(tagName)) {
                this.cell_.setLength(0);
                this.inCell_ = true;
            } else if ("TR".equals(tagName)) {
                this.row_ = new Object[this.ncol_];
                this.icol_ = 0;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.inCell_) {
                this.cell_.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.inCell_) {
                this.cell_.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if (this.inCell_ && "TD".equals(tagName) && this.icol_ < this.ncol_ && this.row_ != null) {
                this.row_[this.icol_] = this.cell_.length() > 0 ? this.decoders_[this.icol_].decodeString(this.cell_.toString()) : null;
                ++this.icol_;
                this.inCell_ = false;
            } else if ("TR".equals(tagName)) {
                if (SkeletonDOMBuilder.this.tableHandler_ != null) {
                    SkeletonDOMBuilder.this.tableHandler_.rowData(this.row_);
                }
            } else if ("TABLEDATA".equals(tagName)) {
                SkeletonDOMBuilder.this.defaultHandler_.endElement(namespaceURI, localName, qName);
                SkeletonDOMBuilder.this.setCustomHandler(SkeletonDOMBuilder.this.basicHandler_);
                if (SkeletonDOMBuilder.this.tableHandler_ != null) {
                    SkeletonDOMBuilder.this.tableHandler_.endTable();
                }
            }
        }
    }

    private class IgnoreContentHandler
    extends CustomDOMBuilder.NullContentHandler {
        int level;
        String tagName;

        IgnoreContentHandler(String tagName) {
            this.tagName = tagName;
            this.level = 1;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            ++this.level;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (--this.level == 0) {
                assert (this.tagName.equals(SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName)));
                SkeletonDOMBuilder.this.basicHandler_.endElement(namespaceURI, localName, qName);
                SkeletonDOMBuilder.this.setCustomHandler(SkeletonDOMBuilder.this.basicHandler_);
            }
        }
    }

    private class BasicContentHandler
    extends CustomDOMBuilder.DefaultContentHandler {
        private BasicContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            if (SkeletonDOMBuilder.this.getLocator() != null) {
                SkeletonDOMBuilder.this.systemId_ = SkeletonDOMBuilder.this.getLocator().getSystemId();
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if ("TABLE".equals(tagName)) {
                SkeletonDOMBuilder.this.tableEl_ = (TableElement)SkeletonDOMBuilder.this.getNewestNode();
            } else if ("DATA".equals(tagName)) {
                if (SkeletonDOMBuilder.this.tableHandler_ == null || SkeletonDOMBuilder.this.tableEl_ == null) {
                    Node dataNode = SkeletonDOMBuilder.this.getNewestNode();
                    dataNode.getParentNode().removeChild(dataNode);
                    SkeletonDOMBuilder.this.setCustomHandler(new IgnoreContentHandler(tagName));
                }
            } else if ("TABLEDATA".equals(tagName)) {
                if (SkeletonDOMBuilder.this.tableEl_ != null) {
                    SkeletonDOMBuilder.this.setCustomHandler(new TabledataHandler());
                }
            } else if ("STREAM".equals(tagName)) {
                Element parent = (Element)SkeletonDOMBuilder.this.getNewestNode().getParentNode();
                String parentName = SkeletonDOMBuilder.this.getVOTagName(parent);
                DataFormat fmt = null;
                String extnum = null;
                if (parentName.equals("BINARY")) {
                    fmt = DataFormat.BINARY;
                } else if (parentName.equals("BINARY2")) {
                    fmt = DataFormat.BINARY2;
                } else if (parentName.equals("FITS")) {
                    fmt = DataFormat.FITS;
                    if (parent.hasAttribute("extnum")) {
                        extnum = parent.getAttribute("extnum");
                    }
                }
                String href = SkeletonDOMBuilder.this.getAttribute(atts, "href");
                if (href != null && href.trim().length() > 0) {
                    URL url = URLUtils.makeURL(SkeletonDOMBuilder.this.systemId_, href.trim());
                    if (fmt == DataFormat.BINARY) {
                        SkeletonDOMBuilder.this.processBinaryHref(url, atts, false);
                    } else if (fmt == DataFormat.BINARY2) {
                        SkeletonDOMBuilder.this.processBinaryHref(url, atts, true);
                    } else if (fmt == DataFormat.FITS) {
                        SkeletonDOMBuilder.this.processFitsHref(url, extnum, atts);
                    }
                    SkeletonDOMBuilder.this.setCustomHandler(new IgnoreContentHandler("STREAM"));
                } else {
                    try {
                        if (fmt == DataFormat.BINARY) {
                            SkeletonDOMBuilder.this.setCustomHandler(new InlineBinaryStreamHandler(false));
                        } else if (fmt == DataFormat.BINARY2) {
                            SkeletonDOMBuilder.this.setCustomHandler(new InlineBinaryStreamHandler(true));
                        } else if (fmt == DataFormat.FITS) {
                            SkeletonDOMBuilder.this.setCustomHandler(new InlineFITSStreamHandler(extnum));
                        }
                    }
                    catch (Throwable e) {
                        throw (SAXException)new SAXParseException(e.getMessage(), SkeletonDOMBuilder.this.getLocator()).initCause(e);
                    }
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            String tagName = SkeletonDOMBuilder.this.getVOTagName(namespaceURI, localName, qName);
            if ("TABLE".equals(tagName)) {
                SkeletonDOMBuilder.this.tableEl_ = null;
            }
        }
    }
}

