/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.util.Base64OutputStream;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.Encoder;
import uk.ac.starlink.votable.FlagIO;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableVersion;

public abstract class VOSerializer {
    private final StarTable table_;
    private final DataFormat format_;
    private final List paramList_;
    private final String ucd_;
    private final String utype_;
    private final String description_;
    final Map<Coosys, String> coosysMap_;
    static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    private static final AtomicLong idSeq_ = new AtomicLong();

    private VOSerializer(StarTable table, DataFormat format) {
        this.table_ = table;
        this.format_ = format;
        this.paramList_ = new ArrayList();
        String description = null;
        String ucd = null;
        String utype = null;
        for (Object obj : table.getParameters()) {
            if (!(obj instanceof DescribedValue)) continue;
            DescribedValue dval = (DescribedValue)obj;
            ValueInfo pinfo = dval.getInfo();
            String pname = pinfo.getName();
            Class pclazz = pinfo.getContentClass();
            Object value = dval.getValue();
            if (pname == null || pclazz == null) continue;
            if (pname.equalsIgnoreCase("description") && pclazz == String.class) {
                description = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UCD_INFO.getName()) && pclazz == String.class) {
                ucd = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UTYPE_INFO.getName()) && pclazz == String.class) {
                utype = (String)value;
                continue;
            }
            this.paramList_.add(dval);
        }
        this.description_ = description;
        this.ucd_ = ucd;
        this.utype_ = utype;
        String baseId = "t" + Long.toString(idSeq_.incrementAndGet());
        this.coosysMap_ = new LinkedHashMap<Coosys, String>();
        int ncol = table.getColumnCount();
        int ics = 0;
        for (int ic = 0; ic < ncol; ++ic) {
            Coosys coosys = Coosys.getCoosys(table.getColumnInfo(ic));
            if (coosys == null || this.coosysMap_.containsKey(coosys)) continue;
            String id = baseId + "-coosys-" + ++ics;
            this.coosysMap_.put(coosys, id);
        }
    }

    public DataFormat getFormat() {
        return this.format_;
    }

    public StarTable getTable() {
        return this.table_;
    }

    public abstract void writeFields(BufferedWriter var1) throws IOException;

    public abstract void writeInlineDataElement(BufferedWriter var1) throws IOException;

    public abstract void writeHrefDataElement(BufferedWriter var1, String var2, DataOutput var3) throws IOException;

    public void writeInlineTableElement(BufferedWriter writer) throws IOException {
        this.writePreDataXML(writer);
        this.writeInlineDataElement(writer);
        this.writePostDataXML(writer);
    }

    public void writeHrefTableElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
        this.writePreDataXML(xmlwriter);
        this.writeHrefDataElement(xmlwriter, href, streamout);
        this.writePostDataXML(xmlwriter);
    }

    public void writeParams(BufferedWriter writer) throws IOException {
        for (DescribedValue param : this.paramList_) {
            int[] shape;
            DefaultValueInfo pinfo = new DefaultValueInfo(param.getInfo());
            Object pvalue = param.getValue();
            if (pinfo.isArray() && (shape = pinfo.getShape()) != null && shape.length > 0 && shape[shape.length - 1] < 0 && pvalue != null && pvalue.getClass().isArray()) {
                long block = 1L;
                for (int idim = 0; idim < shape.length - 1 && block >= 1L; block *= (long)shape[idim], ++idim) {
                }
                int leng = Array.getLength(pvalue);
                if (block <= Integer.MAX_VALUE && (long)leng % block == 0L) {
                    shape[shape.length - 1] = leng / (int)block;
                    pinfo.setShape(shape);
                }
            }
            if (String.class.equals((Object)pinfo.getContentClass()) && pinfo.getElementSize() < 0 && pvalue instanceof String) {
                pinfo.setElementSize(((String)pvalue).length());
            }
            if (String[].class.equals((Object)pinfo.getContentClass()) && pinfo.getElementSize() < 0 && pvalue instanceof String[]) {
                int leng = 0;
                String[] strs = (String[])pvalue;
                for (int is = 0; is < strs.length; ++is) {
                    if (strs[is] == null) continue;
                    leng = Math.max(leng, strs[is].length());
                }
                pinfo.setElementSize(leng);
            }
            pinfo.setNullable(Tables.isBlank(pvalue));
            Encoder encoder = Encoder.getEncoder(pinfo, false, false);
            if (encoder != null) {
                String valtext = encoder.encodeAsText(pvalue);
                String content = encoder.getFieldContent();
                LinkedHashMap<String, String> attMap = new LinkedHashMap<String, String>();
                attMap.putAll(VOSerializer.getFieldAttributes(encoder, this.coosysMap_));
                attMap.put("value", valtext);
                writer.write("<PARAM");
                writer.write(VOSerializer.formatAttributes(attMap));
                if (content.length() > 0) {
                    writer.write(">");
                    writer.write(content);
                    writer.newLine();
                    writer.write("</PARAM>");
                } else {
                    writer.write("/>");
                }
                writer.newLine();
                continue;
            }
            if (pvalue instanceof URL) {
                writer.write("<LINK" + VOSerializer.formatAttribute("title", pinfo.getName()) + VOSerializer.formatAttribute("href", pvalue.toString()) + "/>");
                writer.newLine();
                continue;
            }
            writer.write("<INFO");
            writer.write(VOSerializer.formatAttribute("name", pinfo.getName()));
            if (pvalue != null) {
                writer.write(VOSerializer.formatAttribute("value", pvalue.toString()));
            }
            writer.write("/>");
            writer.newLine();
        }
    }

    public void writeDescription(BufferedWriter writer) throws IOException {
        if (this.description_ != null && this.description_.trim().length() > 0) {
            writer.write("<DESCRIPTION>");
            writer.newLine();
            writer.write(VOSerializer.formatText(this.description_.trim()));
            writer.newLine();
            writer.write("</DESCRIPTION>");
            writer.newLine();
        }
    }

    public void writePreDataXML(BufferedWriter writer) throws IOException {
        long nrow;
        if (this.coosysMap_.size() > 0) {
            writer.write("<RESOURCE>");
            writer.newLine();
            for (Map.Entry<Coosys, String> entry : this.coosysMap_.entrySet()) {
                Coosys coosys = entry.getKey();
                String id = entry.getValue();
                writer.write("  " + coosys.toXml(id));
                writer.newLine();
            }
            writer.write("</RESOURCE>");
            writer.newLine();
        }
        writer.write("<TABLE");
        String tname = this.getTable().getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = this.getTable().getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        if (this.ucd_ != null) {
            writer.write(VOSerializer.formatAttribute("ucd", this.ucd_));
        }
        if (this.utype_ != null) {
            writer.write(VOSerializer.formatAttribute("utype", this.utype_));
        }
        writer.write(">");
        writer.newLine();
        this.writeDescription(writer);
        this.writeParams(writer);
        this.writeFields(writer);
    }

    public void writePostDataXML(BufferedWriter writer) throws IOException {
        writer.write("</TABLE>");
        writer.newLine();
    }

    public static String formatAttribute(String name, String value) {
        int vleng = value.length();
        StringBuffer buf = new StringBuffer(name.length() + vleng + 4);
        buf.append(' ').append(name).append('=').append('\"');
        block6: for (int i = 0; i < vleng; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(VOSerializer.ensureLegalXml(c));
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String formatText(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block5: for (int i = 0; i < leng; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block5;
                }
                default: {
                    sbuf.append(VOSerializer.ensureLegalXml(c));
                }
            }
        }
        return sbuf.toString();
    }

    public static char ensureLegalXml(char c) {
        return (char)(c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c == 9 || c == 10 || c == 13 ? c : 191);
    }

    private static String formatAttributes(Map<String, String> atts) {
        StringBuffer sbuf = new StringBuffer();
        for (String attname : new TreeSet<String>(atts.keySet())) {
            String attval = atts.get(attname);
            sbuf.append(VOSerializer.formatAttribute(attname, attval));
        }
        return sbuf.toString();
    }

    private static void writeFieldElement(BufferedWriter writer, String content, Map<String, String> attributes) throws IOException {
        writer.write("<FIELD" + VOSerializer.formatAttributes(attributes));
        if (content != null && content.length() > 0) {
            writer.write(62);
            writer.write(content);
            writer.newLine();
            writer.write("</FIELD>");
        } else {
            writer.write("/>");
        }
        writer.newLine();
    }

    private static StarTable prepareForSerializer(StarTable table, boolean magicNulls, boolean allowXtype) {
        ValueInfo badKey = Tables.NULL_VALUE_INFO;
        ValueInfo ubyteKey = Tables.UBYTE_FLAG_INFO;
        int ncol = table.getColumnCount();
        final ColumnInfo[] colInfos = new ColumnInfo[ncol];
        int modified = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            DescribedValue xt;
            DescribedValue nv;
            Number badValue;
            ColumnInfo cinfo = new ColumnInfo(table.getColumnInfo(icol));
            boolean isUbyte = Boolean.TRUE.equals(cinfo.getAuxDatumValue(ubyteKey, Boolean.class));
            Class clazz = cinfo.getContentClass();
            if (magicNulls && cinfo.isNullable() && Number.class.isAssignableFrom(clazz) && cinfo.getAuxDatum(badKey) == null && (badValue = isUbyte ? (Number)new Short(255) : (Number)(clazz == Byte.class || clazz == Short.class ? (Number)new Short(Short.MIN_VALUE) : (Number)(clazz == Integer.class ? (Number)new Integer(Integer.MIN_VALUE) : (Number)(clazz == Long.class ? new Long(Long.MIN_VALUE) : null)))) != null) {
                ++modified;
                cinfo.getAuxData().add(new DescribedValue(badKey, badValue));
            }
            if (!magicNulls && !cinfo.isArray() && (nv = cinfo.getAuxDatum(badKey)) != null) {
                cinfo.getAuxData().remove(nv);
                ++modified;
            }
            if (!allowXtype && (xt = cinfo.getAuxDatum(VOStarTable.XTYPE_INFO)) != null) {
                cinfo.getAuxData().remove(xt);
                ++modified;
            }
            colInfos[icol] = cinfo;
        }
        if (modified > 0) {
            table = new WrapperStarTable(table){

                @Override
                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
        }
        return table;
    }

    public static VOSerializer makeSerializer(DataFormat dataFormat, StarTable table) throws IOException {
        return VOSerializer.makeSerializer(dataFormat, VOTableVersion.getDefaultVersion(), table);
    }

    public static VOSerializer makeSerializer(DataFormat dataFormat, VOTableVersion version, StarTable table) throws IOException {
        boolean magicNulls = dataFormat == DataFormat.BINARY || dataFormat == DataFormat.FITS || dataFormat == DataFormat.TABLEDATA && !version.allowEmptyTd();
        table = VOSerializer.prepareForSerializer(table, magicNulls, version.allowXtype());
        if (dataFormat == DataFormat.TABLEDATA) {
            return new TabledataVOSerializer(table, magicNulls);
        }
        if (dataFormat == DataFormat.FITS) {
            return new FITSVOSerializer(table, (FitsTableSerializer)new StandardFitsTableSerializer(table, false, (WideFits)null));
        }
        if (dataFormat == DataFormat.BINARY) {
            return new BinaryVOSerializer(table, magicNulls);
        }
        if (dataFormat == DataFormat.BINARY2) {
            if (version.allowBinary2()) {
                return new Binary2VOSerializer(table, magicNulls);
            }
            throw new IllegalArgumentException("BINARY2 format not legal for VOTable " + version);
        }
        throw new AssertionError((Object)("No such format " + dataFormat.toString()));
    }

    public static VOSerializer makeFitsSerializer(StarTable table, FitsTableSerializer fitser) throws IOException {
        table = VOSerializer.prepareForSerializer(table, false, true);
        return new FITSVOSerializer(table, fitser);
    }

    private static Encoder[] getEncoders(StarTable table, boolean magicNulls) {
        int ncol = table.getColumnCount();
        Encoder[] encoders = new Encoder[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            boolean isUnicode = "unicodeChar".equals(info.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class));
            encoders[icol] = Encoder.getEncoder(info, magicNulls, isUnicode);
            if (encoders[icol] != null) continue;
            logger.warning("Can't serialize column " + info + " of type " + info.getContentClass().getName());
        }
        return encoders;
    }

    private static void outputFields(Encoder[] encoders, StarTable table, Map<Coosys, String> coosysMap, BufferedWriter writer) throws IOException {
        int ncol = encoders.length;
        for (int icol = 0; icol < ncol; ++icol) {
            Encoder encoder = encoders[icol];
            if (encoder != null) {
                String content = encoder.getFieldContent();
                Map<String, String> atts = VOSerializer.getFieldAttributes(encoder, coosysMap);
                VOSerializer.writeFieldElement(writer, content, atts);
                continue;
            }
            writer.write("<!-- Omitted column " + table.getColumnInfo(icol) + " -->");
            writer.newLine();
        }
    }

    private static Map<String, String> getFieldAttributes(Encoder encoder, Map<Coosys, String> csmap) {
        String csid;
        Coosys coosys;
        Map map = encoder.getFieldAttributes();
        ValueInfo info = encoder.getInfo();
        if (info instanceof ColumnInfo && csmap != null && (coosys = Coosys.getCoosys((ColumnInfo)info)) != null && (csid = csmap.get(coosys)) != null) {
            map.put("ref", csid);
        }
        return map;
    }

    private static class Coosys {
        private final Map<String, String> attMap_;

        private Coosys(Map<String, String> attMap) {
            this.attMap_ = Collections.unmodifiableMap(attMap);
        }

        public String toXml(String id) {
            return new StringBuffer().append("<COOSYS").append(VOSerializer.formatAttribute("ID", id)).append(VOSerializer.formatAttributes(this.attMap_)).append("/>").toString();
        }

        public int hashCode() {
            return ((Object)this.attMap_).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Coosys) {
                Coosys other = (Coosys)o;
                return ((Object)this.attMap_).equals(other.attMap_);
            }
            return false;
        }

        public static Coosys getCoosys(ColumnInfo cinfo) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Coosys.addAtt(map, cinfo, VOStarTable.COOSYS_SYSTEM_INFO, "system");
            Coosys.addAtt(map, cinfo, VOStarTable.COOSYS_EPOCH_INFO, "epoch");
            Coosys.addAtt(map, cinfo, VOStarTable.COOSYS_EQUINOX_INFO, "equinox");
            return map.size() > 0 ? new Coosys(map) : null;
        }

        private static void addAtt(Map<String, String> map, ColumnInfo cinfo, ValueInfo key, String attname) {
            String value = (String)cinfo.getAuxDatumValue(key, String.class);
            if (value != null && value.trim().length() > 0) {
                map.put(attname, value);
            }
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        Writer writer;
        static final int BUFLENG = 10240;
        char[] mainBuf = new char[10240];

        WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            char[] buf = len <= 10240 ? this.mainBuf : new char[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = (char)b[off++];
            }
            this.writer.write(buf, 0, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static class FITSVOSerializer
    extends StreamableVOSerializer {
        private final FitsTableSerializer fitser;

        FITSVOSerializer(StarTable table, FitsTableSerializer fitser) throws IOException {
            super(table, DataFormat.FITS, "FITS");
            this.fitser = fitser;
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            int ncol = this.getTable().getColumnCount();
            for (int icol = 0; icol < ncol; ++icol) {
                char tform = this.fitser.getFormatChar(icol);
                int[] dims = this.fitser.getDimensions(icol);
                String badval = this.fitser.getBadValue(icol);
                if (dims != null) {
                    String datatype;
                    Encoder encoder = Encoder.getEncoder(this.getTable().getColumnInfo(icol), true, false);
                    String content = encoder.getFieldContent();
                    Map atts = VOSerializer.getFieldAttributes(encoder, this.coosysMap_);
                    switch (tform) {
                        case 'L': {
                            datatype = "boolean";
                            break;
                        }
                        case 'X': {
                            datatype = "bit";
                            break;
                        }
                        case 'B': {
                            datatype = "unsignedByte";
                            break;
                        }
                        case 'I': {
                            datatype = "short";
                            break;
                        }
                        case 'J': {
                            datatype = "int";
                            break;
                        }
                        case 'K': {
                            datatype = "long";
                            break;
                        }
                        case 'A': {
                            datatype = "char";
                            break;
                        }
                        case 'E': {
                            datatype = "float";
                            break;
                        }
                        case 'D': {
                            datatype = "double";
                            break;
                        }
                        case 'C': {
                            datatype = "floatComplex";
                            break;
                        }
                        case 'M': {
                            datatype = "doubleComplex";
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown format letter " + tform));
                        }
                    }
                    atts.put("datatype", datatype);
                    if (dims.length == 0) {
                        if (!"1".equals(atts.get("arraysize"))) {
                            atts.remove("arraysize");
                        }
                    } else {
                        StringBuffer arraysize = new StringBuffer();
                        for (int i = 0; i < dims.length; ++i) {
                            if (i > 0) {
                                arraysize.append('x');
                            }
                            arraysize.append(dims[i]);
                        }
                        atts.put("arraysize", arraysize.toString());
                    }
                    encoder.setNullString(badval);
                    VOSerializer.writeFieldElement(writer, content, atts);
                    continue;
                }
                writer.write("<!-- Omitted column " + this.getTable().getColumnInfo(icol) + " -->");
                writer.newLine();
            }
        }

        @Override
        public void streamData(DataOutput out) throws IOException {
            FitsConstants.writeEmptyPrimary((DataOutput)out);
            new FitsTableWriter().writeTableHDU(this.getTable(), this.fitser, out);
        }
    }

    private static class Binary2VOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        Binary2VOSerializer(StarTable table, boolean magicNulls) {
            super(table, DataFormat.BINARY2, "BINARY2");
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.coosysMap_, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamData(DataOutput out) throws IOException {
            IntList icolList = new IntList(this.encoders.length);
            for (int icol = 0; icol < this.encoders.length; ++icol) {
                if (this.encoders[icol] == null) continue;
                icolList.add(icol);
            }
            int[] icols = icolList.toIntArray();
            int ncol = icols.length;
            boolean[] nullFlags = new boolean[ncol];
            RowSequence rseq = this.getTable().getRowSequence();
            try {
                while (rseq.next()) {
                    Object cell;
                    int icol;
                    int jcol;
                    Object[] row = rseq.getRow();
                    for (jcol = 0; jcol < ncol; ++jcol) {
                        icol = icols[jcol];
                        cell = row[icol];
                        nullFlags[jcol] = cell == null;
                    }
                    FlagIO.writeFlags(out, nullFlags);
                    for (jcol = 0; jcol < ncol; ++jcol) {
                        icol = icols[jcol];
                        cell = row[icol];
                        this.encoders[icol].encodeToStream(cell, out);
                    }
                }
            }
            finally {
                rseq.close();
            }
        }
    }

    private static class BinaryVOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        BinaryVOSerializer(StarTable table, boolean magicNulls) {
            super(table, DataFormat.BINARY, "BINARY");
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.coosysMap_, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamData(DataOutput out) throws IOException {
            int ncol = this.encoders.length;
            RowSequence rseq = this.getTable().getRowSequence();
            try {
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        encoder.encodeToStream(row[icol], out);
                    }
                }
            }
            finally {
                rseq.close();
            }
        }
    }

    static abstract class StreamableVOSerializer
    extends VOSerializer {
        private final String tagname;

        private StreamableVOSerializer(StarTable table, DataFormat format, String tagname) {
            super(table, format);
            this.tagname = tagname;
        }

        public abstract void streamData(DataOutput var1) throws IOException;

        @Override
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<" + this.tagname + ">");
            writer.newLine();
            writer.write("<STREAM encoding='base64'>");
            writer.newLine();
            Base64OutputStream b64out = new Base64OutputStream(new WriterOutputStream(writer), 16);
            DataOutputStream dataout = new DataOutputStream(b64out);
            this.streamData(dataout);
            dataout.flush();
            b64out.endBase64();
            writer.write("</STREAM>");
            writer.newLine();
            writer.write("</" + this.tagname + ">");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
        }

        @Override
        public void writeHrefDataElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
            xmlwriter.write("<DATA>");
            xmlwriter.newLine();
            xmlwriter.write('<' + this.tagname + '>');
            xmlwriter.newLine();
            xmlwriter.write("<STREAM" + StreamableVOSerializer.formatAttribute("href", href) + "/>");
            xmlwriter.newLine();
            xmlwriter.write("</" + this.tagname + ">");
            xmlwriter.newLine();
            xmlwriter.write("</DATA>");
            xmlwriter.newLine();
            this.streamData(streamout);
        }
    }

    private static class TabledataVOSerializer
    extends VOSerializer {
        private final Encoder[] encoders;

        TabledataVOSerializer(StarTable table, boolean magicNulls) {
            super(table, DataFormat.TABLEDATA);
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.coosysMap_, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<TABLEDATA>");
            writer.newLine();
            int ncol = this.encoders.length;
            RowSequence rseq = this.getTable().getRowSequence();
            try {
                while (rseq.next()) {
                    writer.write("  <TR>");
                    writer.newLine();
                    Object[] rowdata = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        String text = encoder.encodeAsText(rowdata[icol]);
                        writer.write("    <TD>");
                        writer.write(TabledataVOSerializer.formatText(text));
                        writer.write("</TD>");
                        writer.newLine();
                    }
                    writer.write("  </TR>");
                    writer.newLine();
                }
            }
            finally {
                rseq.close();
            }
            writer.write("</TABLEDATA>");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
            writer.flush();
        }

        @Override
        public void writeHrefDataElement(BufferedWriter writer, String href, DataOutput streamout) {
            throw new UnsupportedOperationException("TABLEDATA only supports inline output");
        }
    }
}

