/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.URLValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.GroupElement;
import uk.ac.starlink.votable.LinkElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.ParamRefElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TabularData;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOTableDomainMappers;

public class VOStarTable
extends AbstractStarTable {
    private TableElement votable;
    private TabularData tdata;
    private ColumnInfo[] colinfos;
    private boolean doneParams;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");
    public static final ValueInfo ID_INFO = new DefaultValueInfo("VOTable ID", String.class, "VOTable ID attribute");
    public static final ValueInfo UCD_INFO = new DefaultValueInfo("UCD", String.class, "Table UCD");
    public static final ValueInfo UTYPE_INFO = new DefaultValueInfo("utype", String.class, "Usage-specific type (ties value to an external data model)");
    public static final ValueInfo XTYPE_INFO = new DefaultValueInfo("xtype", String.class, "VOTable xtype attribute");
    public static final ValueInfo WIDTH_INFO = new DefaultValueInfo("VOTable width", Integer.class, "VOTable width attribute");
    public static final ValueInfo PRECISION_INFO = new DefaultValueInfo("VOTable precision", String.class, "VOTable precision attribute");
    public static final ValueInfo REF_INFO = new DefaultValueInfo("VOTable ref", String.class, "VOTable ref attribute");
    public static final ValueInfo TYPE_INFO = new DefaultValueInfo("Type", String.class, "VOTable type attribute");
    public static final ValueInfo DATATYPE_INFO = new DefaultValueInfo("Datatype", String.class, "VOTable data type name");
    public static final ValueInfo COOSYS_SYSTEM_INFO = new DefaultValueInfo("CoosysSystem", String.class, "Sky coordinate system name from COOSYS");
    public static final ValueInfo COOSYS_EPOCH_INFO = new DefaultValueInfo("CoosysEpoch", String.class, "Sky epoch from COOSYS");
    public static final ValueInfo COOSYS_EQUINOX_INFO = new DefaultValueInfo("CoosysEquinox", String.class, "Sky equinox from COOSYS");
    private static final ValueInfo nullInfo = Tables.NULL_VALUE_INFO;
    private static final ValueInfo ubyteInfo = Tables.UBYTE_FLAG_INFO;
    private static final List auxDataInfos = Arrays.asList(DATATYPE_INFO, nullInfo, XTYPE_INFO, COOSYS_SYSTEM_INFO, COOSYS_EPOCH_INFO, COOSYS_EQUINOX_INFO, ubyteInfo, WIDTH_INFO, PRECISION_INFO, ID_INFO, REF_INFO, TYPE_INFO);

    public VOStarTable(TableElement votable) throws IOException {
        this(votable, votable.getData());
    }

    VOStarTable(TableElement votable, TabularData tdata) {
        this.votable = votable;
        this.tdata = tdata;
        this.setName(VOStarTable.calculateName(votable));
    }

    @Override
    public int getColumnCount() {
        return this.tdata.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.votable.getNrows();
    }

    @Override
    public boolean isRandom() {
        return this.tdata.isRandom();
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        if (this.colinfos == null) {
            FieldElement[] fields = this.votable.getFields();
            int ncol = fields.length;
            this.colinfos = new ColumnInfo[ncol];
            for (int i = 0; i < ncol; ++i) {
                VOElement coosys;
                String blankstr;
                FieldElement field = fields[i];
                ColumnInfo cinfo = new ColumnInfo(VOStarTable.getValueInfo(field));
                List auxdata = cinfo.getAuxData();
                if (field.hasAttribute("ID")) {
                    String id = field.getAttribute("ID");
                    auxdata.add(new DescribedValue(ID_INFO, id));
                }
                if (field.hasAttribute("datatype")) {
                    String datatype = field.getAttribute("datatype");
                    auxdata.add(new DescribedValue(DATATYPE_INFO, datatype));
                    if ("unsignedByte".equals(datatype)) {
                        auxdata.add(new DescribedValue(ubyteInfo, Boolean.TRUE));
                    }
                }
                if ((blankstr = field.getNull()) != null) {
                    Object blank = blankstr;
                    try {
                        Class clazz = cinfo.getContentClass();
                        if (clazz == Byte.class) {
                            blank = Byte.valueOf(blankstr);
                        } else if (clazz == Short.class) {
                            blank = Short.valueOf(blankstr);
                        } else if (clazz == Integer.class) {
                            blank = Integer.valueOf(blankstr);
                        } else if (clazz == Long.class) {
                            blank = Long.valueOf(blankstr);
                        }
                    }
                    catch (NumberFormatException e) {
                        blank = blankstr;
                    }
                    auxdata.add(new DescribedValue(nullInfo, blank));
                }
                if (field.hasAttribute("width")) {
                    String width = field.getAttribute("width");
                    try {
                        int wv = Integer.parseInt(width);
                        auxdata.add(new DescribedValue(WIDTH_INFO, new Integer(wv)));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (field.hasAttribute("precision")) {
                    String precision = field.getAttribute("precision");
                    auxdata.add(new DescribedValue(PRECISION_INFO, precision));
                }
                if (field.hasAttribute("type")) {
                    String type = field.getAttribute("type");
                    auxdata.add(new DescribedValue(TYPE_INFO, type));
                }
                String xtype = null;
                if (field.hasAttribute("xtype")) {
                    xtype = field.getAttribute("xtype");
                    auxdata.add(new DescribedValue(XTYPE_INFO, xtype));
                }
                if ((coosys = field.getCoosys()) != null) {
                    if (coosys.hasAttribute("system")) {
                        String system = coosys.getAttribute("system");
                        auxdata.add(new DescribedValue(COOSYS_SYSTEM_INFO, system));
                    }
                    if (coosys.hasAttribute("epoch")) {
                        String epoch = coosys.getAttribute("epoch");
                        auxdata.add(new DescribedValue(COOSYS_EPOCH_INFO, epoch));
                    }
                    if (coosys.hasAttribute("equinox")) {
                        String equinox = coosys.getAttribute("equinox");
                        auxdata.add(new DescribedValue(COOSYS_EQUINOX_INFO, equinox));
                    }
                }
                if (field.hasAttribute("ref")) {
                    String ref = field.getAttribute("ref");
                    auxdata.add(new DescribedValue(REF_INFO, ref));
                }
                VOElement[] links = field.getChildrenByName("LINK");
                for (int j = 0; j < links.length; ++j) {
                    auxdata.add(VOStarTable.getDescribedValue((LinkElement)links[j]));
                }
                cinfo.setDomainMappers(VOTableDomainMappers.getMappers(cinfo, xtype));
                this.colinfos[i] = cinfo;
            }
        }
        return this.colinfos[icol];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getParameters() {
        if (!this.doneParams) {
            DescribedValue dval;
            ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
            String description = this.votable.getDescription();
            if (description != null && description.trim().length() > 0) {
                DefaultValueInfo descInfo = new DefaultValueInfo("Description", String.class);
                params.add(new DescribedValue(descInfo, description.trim()));
            }
            if (this.votable.hasAttribute("ucd")) {
                dval = new DescribedValue(UCD_INFO, this.votable.getAttribute("ucd"));
                params.add(dval);
            }
            if (this.votable.hasAttribute("utype")) {
                dval = new DescribedValue(UTYPE_INFO, this.votable.getAttribute("utype"));
                params.add(dval);
            }
            ArrayList pelList = new ArrayList();
            for (VOElement ancestor = this.votable; ancestor != null; ancestor = ancestor.getParent()) {
                VOStarTable.addParamElements(ancestor, pelList);
            }
            for (VOElement el : pelList) {
                String tag = el.getVOTagName();
                if (el instanceof ParamElement) {
                    ParamElement pel = (ParamElement)el;
                    params.add(new DescribedValue(VOStarTable.getValueInfo(pel), pel.getObject()));
                    continue;
                }
                if (el instanceof LinkElement) {
                    LinkElement lel = (LinkElement)el;
                    params.add(VOStarTable.getDescribedValue(lel));
                    continue;
                }
                if ("INFO".equals(tag)) {
                    String content = DOMUtils.getTextContent(el);
                    String descrip = content != null && content.trim().length() > 0 ? content : null;
                    DefaultValueInfo info = new DefaultValueInfo(el.getHandle(), String.class, descrip);
                    DescribedValue dval2 = new DescribedValue(info, el.getAttribute("value"));
                    params.add(dval2);
                    continue;
                }
                assert (false) : el;
            }
            VOStarTable vOStarTable = this;
            synchronized (vOStarTable) {
                if (!this.doneParams) {
                    super.getParameters().addAll(params);
                    this.doneParams = true;
                }
            }
        }
        return super.getParameters();
    }

    @Override
    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return this.tdata.getRowSequence();
    }

    @Override
    public Object[] getRow(long lrow) throws IOException {
        if (this.isRandom()) {
            return this.tdata.getRow(lrow);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getCell(long lrow, int icol) throws IOException {
        if (this.isRandom()) {
            return this.tdata.getCell(lrow, icol);
        }
        throw new UnsupportedOperationException();
    }

    private static String calculateName(TableElement table) {
        boolean multiTable;
        Document doc;
        if (table.getName() != null) {
            return table.getName();
        }
        String sysid = ((VODocument)table.getOwnerDocument()).getSystemId();
        if (sysid != null) {
            int sindex = sysid.lastIndexOf(47);
            if (sindex < 0 || sindex == sysid.length() - 1) {
                sindex = sysid.lastIndexOf(92);
            }
            if (sindex > 0 && sindex < sysid.length() - 1) {
                sysid = sysid.substring(sindex + 1);
            }
        }
        boolean bl = (doc = table.getOwnerDocument()) instanceof VODocument ? ((VODocument)doc).getElementCount("TABLE") > 1 : (multiTable = true);
        if (multiTable) {
            return (sysid == null ? "" : sysid) + "#" + (table.getElementSequence() + 1);
        }
        return sysid == null ? "votable" : sysid;
    }

    private static void addParamElements(VOElement parent, List pelList) {
        VOElement[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            VOElement child = children[i];
            if (child instanceof ParamElement) {
                if (pelList.contains(child)) continue;
                pelList.add(child);
                continue;
            }
            if (child instanceof ParamRefElement) {
                ParamElement pel = ((ParamRefElement)child).getParam();
                if (pel != null) {
                    if (pelList.contains(pel)) continue;
                    pelList.add(pel);
                    continue;
                }
                String msg = new StringBuffer().append("Ignoring PARAMref element with no referent ").append('\"').append(child.getAttribute("ref")).append('\"').toString();
                logger_.warning(msg);
                continue;
            }
            if (child instanceof LinkElement) {
                if (pelList.contains(child)) continue;
                pelList.add(child);
                continue;
            }
            if ("INFO".equals(child.getVOTagName())) {
                if (pelList.contains(child)) continue;
                pelList.add(child);
                continue;
            }
            if (!(child instanceof GroupElement)) continue;
            VOStarTable.addParamElements(child, pelList);
        }
    }

    public static ValueInfo getValueInfo(FieldElement field) {
        Decoder decoder = field.getDecoder();
        Class clazz = decoder.getContentClass();
        String name = field.getHandle();
        long[] shapel = decoder.getDecodedShape();
        DefaultValueInfo info = new DefaultValueInfo(name, clazz);
        info.setDescription(field.getDescription());
        info.setUnitString(field.getUnit());
        info.setUCD(field.getUcd());
        info.setUtype(field.getUtype());
        info.setShape(shapel == null || shapel.length == 0 ? null : Decoder.longsToInts(shapel));
        info.setElementSize(decoder.getElementSize());
        return info;
    }

    static DescribedValue getDescribedValue(LinkElement link) {
        try {
            URL url = link.getHref();
            URLValueInfo vinfo = new URLValueInfo(link.getHandle(), link.getDescription());
            return new DescribedValue(vinfo, url);
        }
        catch (MalformedURLException e) {
            String href = link.getAttribute("href");
            DefaultValueInfo vinfo = new DefaultValueInfo(link.getHandle(), String.class, link.getDescription());
            return new DescribedValue(vinfo, href);
        }
    }
}

