/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.MultiTableStreamer;
import uk.ac.starlink.votable.TableStreamer;
import uk.ac.starlink.votable.VOElementFactory;

public class VOTableBuilder
implements TableBuilder,
MultiTableBuilder {
    private boolean strict_;
    private static Pattern htmlPattern = Pattern.compile("<x?html", 2);

    public VOTableBuilder() {
        this(VOElementFactory.isStrictByDefault());
    }

    public VOTableBuilder(boolean strict) {
        this.strict_ = strict;
    }

    @Override
    public String getFormatName() {
        return "VOTable";
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws TableFormatException, IOException {
        VOTableBuilder.checkForHtml(datsrc);
        int itab = 0;
        String pos = datsrc.getPosition();
        if (pos != null) {
            try {
                itab = Integer.parseInt(pos);
            }
            catch (NumberFormatException e) {
                throw new TableFormatException("Expecting integer for position in " + datsrc + " (got \"" + pos + "\")", e);
            }
            if (itab < 0) {
                throw new TableFormatException("Expecting integer >= 0 for position in" + datsrc + " (got " + itab + ")");
            }
        }
        RowStore rowStore = storagePolicy.makeRowStore();
        InputSource saxSrc = new InputSource(datsrc.getInputStream());
        saxSrc.setSystemId(datsrc.getSystemId());
        try {
            TableStreamer.streamStarTable(saxSrc, rowStore, itab, this.strict_);
        }
        catch (SAXException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        return rowStore.getStarTable();
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy storagePolicy) throws TableFormatException, IOException {
        VOTableBuilder.checkForHtml(datsrc);
        String frag = datsrc.getPosition();
        if (frag != null && frag.trim().length() > 0) {
            return Tables.singleTableSequence(this.makeStarTable(datsrc, false, storagePolicy));
        }
        InputSource saxSrc = new InputSource(datsrc.getInputStream());
        saxSrc.setSystemId(datsrc.getSystemId());
        try {
            return MultiTableStreamer.streamStarTables(saxSrc, storagePolicy, this.strict_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        String pri = flavor.getPrimaryType();
        String sub = flavor.getSubType();
        return pri.equals("text") && sub.equals("xml") || pri.equals("application") && sub.equals("xml") || pri.equals("application") && sub.equals("x-votable+xml");
    }

    @Override
    public void streamStarTable(InputStream istrm, TableSink sink, String index) throws IOException {
        int itable = index != null && index.matches("[0-9]+") ? Integer.parseInt(index) : 0;
        try {
            TableStreamer.streamStarTable(new InputSource(istrm), sink, itable, this.strict_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static void checkForHtml(DataSource datsrc) throws IOException {
        String sintro = new String(datsrc.getIntro());
        if (htmlPattern.matcher(new String(datsrc.getIntro())).lookingAt()) {
            throw new TableFormatException("Looks like HTML - bet it's not a VOTable");
        }
    }
}

