/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.SkeletonDOMBuilder;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VODocument;

public class VOTableDOMBuilder
implements ContentHandler {
    private final Worker worker_;

    public VOTableDOMBuilder(StoragePolicy storagePolicy, boolean strict) {
        this.worker_ = new Worker(storagePolicy, strict);
    }

    public VODocument getDocument() {
        return (VODocument)this.worker_.getDocument();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.worker_.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.worker_.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.worker_.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.worker_.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.worker_.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.worker_.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.worker_.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.worker_.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.worker_.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.worker_.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.worker_.skippedEntity(name);
    }

    private static class Worker
    extends SkeletonDOMBuilder
    implements TableHandler {
        private final StoragePolicy storagePolicy_;
        private RowStore rowStore_;

        Worker(StoragePolicy storagePolicy, boolean strict) {
            super(strict);
            this.storagePolicy_ = storagePolicy;
            this.setTableHandler(this);
        }

        @Override
        protected void processBinaryHref(URL url, Attributes atts, boolean isBinary2) {
            TableElement tableEl = this.getTableElement();
            if (tableEl != null) {
                String encoding = this.getAttribute(atts, "encoding");
                Decoder[] decoders = SkeletonDOMBuilder.getDecoders(tableEl.getFields());
                TableBodies.HrefBinaryTabularData tdata = new TableBodies.HrefBinaryTabularData(decoders, url, encoding, isBinary2);
                tableEl.setData(tdata);
            }
        }

        @Override
        protected void processFitsHref(URL url, String extnum, Attributes atts) throws SAXException {
            TableElement tableEl = this.getTableElement();
            if (tableEl != null) {
                try {
                    DataSource datsrc = DataSource.makeDataSource(url);
                    datsrc.setPosition(extnum);
                    StarTable startab = new FitsTableBuilder().makeStarTable(datsrc, false, this.storagePolicy_);
                    TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(startab);
                    tableEl.setData(tdata);
                }
                catch (IOException e) {
                    throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
                }
            }
        }

        @Override
        public void startTable(StarTable meta) throws SAXException {
            this.rowStore_ = this.storagePolicy_.makeConfiguredRowStore(meta);
        }

        @Override
        public void rowData(Object[] row) throws SAXException {
            try {
                this.rowStore_.acceptRow(row);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
            }
        }

        @Override
        public void endTable() throws SAXException {
            try {
                this.rowStore_.endRows();
                TableElement tableEl = this.getTableElement();
                if (tableEl != null) {
                    StarTable st = this.rowStore_.getStarTable();
                    tableEl.setData(new TableBodies.StarTableTabularData(st));
                }
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
            }
            this.rowStore_ = null;
        }
    }
}

