/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.ArrayList;
import java.util.regex.Pattern;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.table.ValueInfo;

class VOTableDomainMappers {
    static final Pattern ISO8601_UNIT_PATTERN = Pattern.compile("iso.?8601", 2);
    static final Pattern ISO8601_UCD_PATTERN = Pattern.compile("time(\\.(epoch|start|end))?(;.*)?|TIME_DATE(_.*)?", 2);
    static final Pattern OBSCORE_T_UTYPE_PATTERN = Pattern.compile(".*Char\\.TimeAxis\\.Coverage\\.Bounds\\.Limits.*", 2);

    VOTableDomainMappers() {
    }

    public static DomainMapper[] getMappers(ValueInfo info, String xtype) {
        ArrayList<TimeMapper> mappers = new ArrayList<TimeMapper>();
        Class clazz = info.getContentClass();
        String units = info.getUnitString();
        String ucd = info.getUCD();
        String utype = info.getUtype();
        if (xtype == null) {
            xtype = "";
        }
        if (units == null) {
            units = "";
        }
        if (ucd == null) {
            ucd = "";
        }
        if (utype == null) {
            utype = "";
        }
        units = VOTableDomainMappers.unquote(units.trim()).trim();
        if (String.class.isAssignableFrom(clazz) && ("iso8601".equals(xtype) || ISO8601_UNIT_PATTERN.matcher(xtype).matches() || "adql:TIMESTAMP".equalsIgnoreCase(xtype) || "timestamp".equalsIgnoreCase(xtype) || ISO8601_UNIT_PATTERN.matcher(units).matches() || ISO8601_UCD_PATTERN.matcher(ucd).matches())) {
            mappers.add(TimeMapper.ISO_8601);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if ("mjd".equalsIgnoreCase(xtype) || OBSCORE_T_UTYPE_PATTERN.matcher(utype).matches() && "d".equals(units)) {
                mappers.add(TimeMapper.MJD);
            } else if ("jd".equalsIgnoreCase(xtype)) {
                mappers.add(TimeMapper.JD);
            } else if ("yr".equals(units) || "a".equals(units) || "year".equals(units)) {
                mappers.add(TimeMapper.DECIMAL_YEAR);
            }
        }
        return mappers.toArray(new DomainMapper[0]);
    }

    private static String unquote(String str) {
        int leng = str.length();
        if (leng > 1 && (str.charAt(0) == '\'' && str.charAt(leng - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(leng - 1) == '\"')) {
            return str.substring(1, leng - 1);
        }
        return str;
    }
}

