/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.Cursor;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public abstract class VOTableFitsTableWriter
extends AbstractFitsTableWriter {
    private VOTableVersion votVersion_ = VOTableVersion.getDefaultVersion();
    private static String XML_ENCODING = "UTF-8";
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    protected VOTableFitsTableWriter(String formatName) {
        super(formatName);
    }

    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        ArrayList<StarTable> tableList = new ArrayList<StarTable>();
        while ((table = tableSeq.nextTable()) != null) {
            tableList.add(table);
        }
        StarTable[] tables = tableList.toArray(new StarTable[0]);
        int ntable = tables.length;
        FitsTableSerializer[] fitsers = new FitsTableSerializer[ntable];
        for (int i = 0; i < ntable; ++i) {
            fitsers[i] = this.createSerializer(tables[i]);
        }
        DataOutputStream dout = new DataOutputStream(out);
        out = null;
        this.writePrimaryHDU(tables, fitsers, dout);
        for (int i = 0; i < ntable; ++i) {
            this.writeTableHDU(tables[i], fitsers[i], dout);
        }
        dout.flush();
    }

    public void setVotableVersion(VOTableVersion votVersion) {
        this.votVersion_ = votVersion;
    }

    private void writePrimaryHDU(StarTable[] tables, FitsTableSerializer[] fitsers, DataOutput strm) throws IOException {
        Exception thrown = null;
        try {
            this.writeVOTablePrimary(tables, fitsers, strm);
            return;
        }
        catch (IOException e) {
            thrown = e;
        }
        catch (FitsException e) {
            thrown = e;
        }
        assert (thrown != null);
        logger.log(Level.WARNING, "Failed to write VOTable metadata to primary HDU", thrown);
        FitsConstants.writeEmptyPrimary((DataOutput)strm);
    }

    private void writeVOTablePrimary(StarTable[] tables, FitsTableSerializer[] fitsers, DataOutput out) throws IOException, FitsException {
        int ntable = tables.length;
        if (fitsers.length != ntable) {
            throw new IllegalArgumentException("table/serializer count mismatch");
        }
        StringWriter textWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(textWriter);
        VOTableWriter votWriter = new VOTableWriter(null, false, this.votVersion_);
        votWriter.writePreTableXML(writer);
        String comment = new StringBuffer().append("<!-- ").append("Describes BINTABLE extensions in the following ").append(ntable == 1 ? "HDU" : ntable + " HDUs").append(".").append("-->").toString();
        writer.write(comment);
        writer.newLine();
        for (int i = 0; i < ntable; ++i) {
            StarTable table = tables[i];
            FitsTableSerializer fitser = fitsers[i];
            VOSerializer voser = VOSerializer.makeFitsSerializer(tables[i], fitsers[i]);
            voser.writePreDataXML(writer);
            writer.write("<!-- Dummy VOTable - no DATA element -->");
            writer.newLine();
            voser.writePostDataXML(writer);
        }
        votWriter.writePostTableXML(writer);
        writer.flush();
        byte[] textBytes = textWriter.getBuffer().toString().getBytes(XML_ENCODING);
        int nbyte = textBytes.length;
        Header hdr = new Header();
        hdr.addValue("SIMPLE", true, "Standard FITS format");
        hdr.addValue("BITPIX", 8L, "Character data");
        hdr.addValue("NAXIS", 1L, "Text string");
        hdr.addValue("NAXIS1", nbyte, "Number of characters");
        this.customisePrimaryHeader(hdr);
        hdr.addValue("EXTEND", true, "There are standard extensions");
        String plural = ntable == 1 ? "" : "s";
        String[] comments = new String[]{" ", "The data in this primary HDU consists of bytes which", "comprise a VOTABLE document.", "The VOTable describes the metadata of the table" + plural + " contained", "in the following BINTABLE extension" + plural + ".", "Such a BINTABLE extension can be used on its own as a perfectly", "good table, but the information from this HDU may provide some", "useful additional metadata.", ntable == 1 ? "There is one following BINTABLE." : "There are " + ntable + " following BINTABLEs."};
        for (int i = 0; i < comments.length; ++i) {
            hdr.insertComment(comments[i]);
        }
        hdr.addValue("NTABLE", ntable, "Number of following BINTABLE HDUs");
        hdr.insertCommentStyle("END", "");
        assert (this.primaryHeaderOK(hdr));
        FitsConstants.writeHeader((DataOutput)out, (Header)hdr);
        out.write(textBytes);
        int partial = textBytes.length % 2880;
        if (partial > 0) {
            int pad = 2880 - partial;
            out.write(new byte[pad]);
        }
    }

    protected abstract void customisePrimaryHeader(Header var1) throws HeaderCardException;

    private boolean primaryHeaderOK(Header hdr) {
        boolean ok = true;
        ByteArrayOutputStream bstrm = new ByteArrayOutputStream();
        Cursor it = hdr.iterator();
        while (it.hasNext()) {
            String card = ((HeaderCard)it.next()).toString();
            ok = ok && card.length() == 80;
            for (int i = 0; i < card.length(); ++i) {
                bstrm.write((byte)card.charAt(i));
            }
        }
        return ok && this.isMagic(bstrm.toByteArray());
    }

    public boolean isMagic(byte[] buffer) {
        int ntest = 36;
        int pos = 0;
        boolean ncard = false;
        for (int il = 0; il < 36 && buffer.length > pos + 80; ++il) {
            char[] cbuf = new char[80];
            for (int ic = 0; ic < 80; ++ic) {
                cbuf[ic] = (char)(buffer[pos++] & 0xFF);
            }
            HeaderCard card = new HeaderCard(new String(cbuf));
            if (this.isMagic(il, card.getKey(), card.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean isMagic(int icard, String key, String value) {
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && "T".equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && "8".equals(value);
            }
            case 2: {
                return "NAXIS".equals(key) && "1".equals(value);
            }
            case 3: {
                return "NAXIS1".equals(key);
            }
        }
        return true;
    }
}

