/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public abstract class VOTableVersion {
    public static final VOTableVersion V10 = new VersionLike10("1.0");
    public static final VOTableVersion V11 = new VersionLike11("1.1");
    public static final VOTableVersion V12 = new VersionLike12("1.2");
    public static final VOTableVersion V13 = new VersionLike13("1.3");
    private static final Map<String, VOTableVersion> VERSION_MAP = Collections.unmodifiableMap(VOTableVersion.createMap(new VOTableVersion[]{V10, V11, V12, V13}));
    public static final String DEFAULT_VERSION_STRING = "1.3";
    public static final String VOTABLE_VERSION_PROP = "votable.version";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");
    private final String versionNumber_;

    protected VOTableVersion(String versionNumber) {
        this.versionNumber_ = versionNumber;
    }

    public String getVersionNumber() {
        return this.versionNumber_;
    }

    public abstract String getXmlNamespace();

    public abstract String getSchemaLocation();

    public abstract Schema getSchema();

    public abstract String getDoctypeDeclaration();

    public abstract URL getDtdUrl();

    public String toString() {
        return this.versionNumber_;
    }

    public abstract boolean allowEmptyTd();

    public abstract boolean allowBinary2();

    public abstract boolean allowXtype();

    public static Map<String, VOTableVersion> getKnownVersions() {
        return VERSION_MAP;
    }

    public static VOTableVersion getDefaultVersion() {
        String vnum = DEFAULT_VERSION_STRING;
        try {
            vnum = System.getProperty(VOTABLE_VERSION_PROP, vnum);
            if (!VERSION_MAP.containsKey(vnum)) {
                logger_.warning("Unknown VOTable version \"" + vnum + "\" - use default " + DEFAULT_VERSION_STRING);
                vnum = DEFAULT_VERSION_STRING;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        VOTableVersion version = VERSION_MAP.get(vnum);
        assert (version != null);
        return version;
    }

    private static Map<String, VOTableVersion> createMap(VOTableVersion[] versions) {
        LinkedHashMap<String, VOTableVersion> map = new LinkedHashMap<String, VOTableVersion>();
        for (int i = 0; i < versions.length; ++i) {
            VOTableVersion vers = versions[i];
            map.put(vers.getVersionNumber(), vers);
        }
        return map;
    }

    private static class VersionLike13
    extends VersionLike12 {
        VersionLike13(String version) {
            super(version);
        }

        @Override
        public boolean allowEmptyTd() {
            return true;
        }

        @Override
        public boolean allowBinary2() {
            return true;
        }
    }

    private static class VersionLike12
    extends VersionLike11 {
        VersionLike12(String version) {
            super(version);
        }

        @Override
        public boolean allowXtype() {
            return true;
        }
    }

    private static class VersionLike11
    extends VersionLike10 {
        private boolean schemaTried_;
        private Schema schema_;

        VersionLike11(String version) {
            super(version);
        }

        @Override
        public String getXmlNamespace() {
            return "http://www.ivoa.net/xml/VOTable/v" + this.getVersionNumber();
        }

        @Override
        public String getSchemaLocation() {
            return this.getXmlNamespace();
        }

        @Override
        public String getDoctypeDeclaration() {
            return null;
        }

        @Override
        public URL getDtdUrl() {
            return null;
        }

        @Override
        public synchronized Schema getSchema() {
            if (!this.schemaTried_) {
                this.schemaTried_ = true;
                String loc = "/uk/ac/starlink/util/text/VOTable" + this.getVersionNumber() + ".xsd";
                URL surl = VOTableVersion.class.getResource(loc);
                if (surl == null) {
                    logger_.warning("No VOTable schema found at " + loc);
                } else {
                    try {
                        this.schema_ = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(surl);
                    }
                    catch (Exception e) {
                        logger_.warning("Failed to initialize schema from " + surl + " - " + e);
                    }
                }
            }
            return this.schema_;
        }
    }

    private static class VersionLike10
    extends VOTableVersion {
        VersionLike10(String version) {
            super(version);
        }

        @Override
        public String getXmlNamespace() {
            return null;
        }

        @Override
        public String getSchemaLocation() {
            return null;
        }

        @Override
        public String getDoctypeDeclaration() {
            return "<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">";
        }

        @Override
        public URL getDtdUrl() {
            return VOTableVersion.class.getResource("/uk/ac/starlink/util/text/VOTable.dtd");
        }

        @Override
        public boolean allowXtype() {
            return false;
        }

        @Override
        public boolean allowEmptyTd() {
            return false;
        }

        @Override
        public boolean allowBinary2() {
            return false;
        }

        @Override
        public Schema getSchema() {
            return null;
        }
    }
}

