/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.Base64OutputStream;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;

public class VOTableWriter
implements StarTableWriter,
MultiStarTableWriter {
    private DataFormat dataFormat;
    private boolean inline;
    private VOTableVersion version;
    private boolean writeSchemaLocation;
    private String xmlDeclaration = "<?xml version='1.0'?>";
    public static final String DEFAULT_XML_DECLARATION = "<?xml version='1.0'?>";
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    public VOTableWriter() {
        this(DataFormat.TABLEDATA, true);
    }

    public VOTableWriter(DataFormat dataFormat, boolean inline) {
        this(dataFormat, inline, VOTableVersion.getDefaultVersion());
    }

    public VOTableWriter(DataFormat dataFormat, boolean inline, VOTableVersion version) {
        this.dataFormat = dataFormat;
        this.inline = inline;
        this.version = version;
    }

    @Override
    public void writeStarTable(StarTable startab, String location, StarTableOutput sto) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(startab), location, sto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        OutputStream out = null;
        try {
            File file;
            out = sto.getOutputStream(location);
            File file2 = file = out instanceof FileOutputStream ? new File(location) : null;
            if (!this.inline && file == null) {
                throw new TableFormatException("Can't write non-inline format to a stream");
            }
            this.writeStarTables(tableSeq, out, file);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void writeStarTable(StarTable startab, OutputStream out) throws IOException {
        this.writeStarTable(startab, out, null);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        this.writeStarTables(tableSeq, out, null);
    }

    public void writeStarTable(StarTable startab, OutputStream out, File file) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(startab), out, file);
    }

    public void writeStarTables(TableSequence tableSeq, OutputStream out, File file) throws IOException {
        StarTable startab;
        OutputStreamWriter osw;
        try {
            osw = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "What? UTF-8 unsupported?", e);
            assert (false);
            osw = new OutputStreamWriter(out);
        }
        BufferedWriter writer = new BufferedWriter(osw);
        this.writePreTableXML(writer);
        int itable = 0;
        while ((startab = tableSeq.nextTable()) != null) {
            VOSerializer serializer = VOSerializer.makeSerializer(this.dataFormat, this.version, startab);
            serializer.writePreDataXML(writer);
            if (this.inline || file == null) {
                if (!this.inline) {
                    assert (file == null);
                    logger.warning("Writing VOTable inline - can't do href when no filename is supplied");
                }
                if (serializer instanceof VOSerializer.StreamableVOSerializer) {
                    String tagname;
                    VOSerializer.StreamableVOSerializer streamer = (VOSerializer.StreamableVOSerializer)serializer;
                    if (this.dataFormat == DataFormat.FITS) {
                        tagname = "FITS";
                    } else if (this.dataFormat == DataFormat.BINARY) {
                        tagname = "BINARY";
                    } else if (this.dataFormat == DataFormat.BINARY2) {
                        tagname = "BINARY2";
                    } else {
                        throw new AssertionError((Object)("Unknown format " + this.dataFormat.toString()));
                    }
                    writer.write("<DATA>");
                    writer.newLine();
                    writer.write('<' + tagname + '>');
                    writer.newLine();
                    writer.write("<STREAM encoding='base64'>");
                    writer.newLine();
                    writer.flush();
                    Base64OutputStream b64strm = new Base64OutputStream(new BufferedOutputStream(out), 16);
                    DataOutputStream dataout = new DataOutputStream(b64strm);
                    streamer.streamData(dataout);
                    dataout.flush();
                    b64strm.endBase64();
                    b64strm.flush();
                    writer.write("</STREAM>");
                    writer.newLine();
                    writer.write("</" + tagname + ">");
                    writer.newLine();
                    writer.write("</DATA>");
                    writer.newLine();
                } else {
                    serializer.writeInlineDataElement(writer);
                }
            } else {
                assert (file != null);
                String basename = file.getName();
                int dotpos = basename.lastIndexOf(46);
                basename = dotpos > 0 ? basename.substring(0, dotpos) : basename;
                String extension = this.dataFormat == DataFormat.FITS ? ".fits" : ".bin";
                String dataname = basename + "-data" + (itable > 0 ? Integer.toString(itable) : "") + extension;
                File datafile = new File(file.getParentFile(), dataname);
                logger.info("Writing VOTable href data at " + datafile);
                DataOutputStream dataout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(datafile)));
                serializer.writeHrefDataElement(writer, dataname, dataout);
                dataout.close();
            }
            serializer.writePostDataXML(writer);
            ++itable;
        }
        this.writePostTableXML(writer);
        writer.flush();
    }

    public void writeInlineStarTable(StarTable startab, BufferedWriter writer) throws IOException {
        this.writeInlineStarTables(new StarTable[]{startab}, writer);
    }

    public void writeInlineStarTables(StarTable[] startabs, BufferedWriter writer) throws IOException {
        this.writePreTableXML(writer);
        for (int i = 0; i < startabs.length; ++i) {
            VOSerializer.makeSerializer(this.dataFormat, this.version, startabs[i]).writeInlineTableElement(writer);
        }
        this.writePostTableXML(writer);
        writer.flush();
    }

    protected void writePreTableXML(BufferedWriter writer) throws IOException {
        String doctypeDeclaration;
        if (this.xmlDeclaration != null && this.xmlDeclaration.length() > 0) {
            writer.write(this.xmlDeclaration);
            writer.newLine();
        }
        if ((doctypeDeclaration = this.version.getDoctypeDeclaration()) != null && doctypeDeclaration.length() > 0) {
            writer.write(doctypeDeclaration);
            writer.newLine();
        }
        writer.write("<VOTABLE");
        String versionNumber = this.version.getVersionNumber();
        if (versionNumber != null) {
            writer.write(VOSerializer.formatAttribute("version", versionNumber));
        }
        String xmlNamespace = this.version.getXmlNamespace();
        String schemaLocation = this.version.getSchemaLocation();
        if (xmlNamespace != null) {
            if (this.writeSchemaLocation && schemaLocation != null) {
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xsi:schemaLocation", xmlNamespace + " " + schemaLocation));
            }
            writer.newLine();
            writer.write(VOSerializer.formatAttribute("xmlns", xmlNamespace));
        }
        writer.write(">");
        writer.newLine();
        writer.write("<!--");
        writer.newLine();
        writer.write(" !  VOTable written by STIL version " + IOUtils.getResourceContents(StarTable.class, "stil.version", null) + " (" + VOSerializer.formatText(this.getClass().getName()) + ")");
        writer.newLine();
        writer.write(" !  at " + AbstractFitsTableWriter.getCurrentDate());
        writer.newLine();
        writer.write(" !-->");
        writer.newLine();
        writer.write("<RESOURCE>");
        writer.newLine();
    }

    protected void writePostTableXML(BufferedWriter writer) throws IOException {
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write("</VOTABLE>");
        writer.newLine();
    }

    @Override
    public boolean looksLikeFile(String filename) {
        return filename.endsWith(".xml") || filename.endsWith(".vot") || filename.endsWith(".votable");
    }

    @Override
    public String getFormatName() {
        StringBuffer fname = new StringBuffer("votable");
        if (this.dataFormat == DataFormat.TABLEDATA) {
            fname.append("-tabledata");
            return fname.toString();
        }
        if (this.dataFormat == DataFormat.FITS) {
            fname.append("-fits");
        } else if (this.dataFormat == DataFormat.BINARY) {
            fname.append("-binary");
        } else if (this.dataFormat == DataFormat.BINARY2) {
            fname.append("-binary2");
        } else assert (false);
        fname.append(this.inline ? "-inline" : "-href");
        return fname.toString();
    }

    @Override
    public String getMimeType() {
        String type = "application/x-votable+xml";
        String serialization = this.dataFormat == DataFormat.TABLEDATA ? "TABLEDATA" : (this.dataFormat == DataFormat.BINARY ? "BINARY" : (this.dataFormat == DataFormat.BINARY2 ? "BINARY2" : (this.dataFormat == DataFormat.FITS ? "FITS" : null)));
        StringBuffer sbuf = new StringBuffer(type);
        if (serialization != null) {
            sbuf.append("; serialization=").append(serialization);
        }
        return sbuf.toString();
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public boolean getInline() {
        return this.inline;
    }

    public void setXMLDeclaration(String xmlDecl) {
        this.xmlDeclaration = xmlDecl;
    }

    public String getXMLDeclaration() {
        return this.xmlDeclaration;
    }

    public void setVotableVersion(VOTableVersion version) {
        this.version = version;
    }

    public VOTableVersion getVotableVersion() {
        return this.version;
    }

    public void setWriteSchemaLocation(boolean writeSchemaLocation) {
        this.writeSchemaLocation = writeSchemaLocation;
    }

    public boolean getWriteSchemaLocation() {
        return this.writeSchemaLocation;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.dataFormat.toString());
        if (this.dataFormat != DataFormat.TABLEDATA) {
            sbuf.append(",").append(this.inline ? "inline" : "href");
        }
        sbuf.append(",v").append(this.version.getVersionNumber());
        return sbuf.toString();
    }

    public static StarTableWriter[] getStarTableWriters() {
        VOTableVersion version = VOTableVersion.getDefaultVersion();
        ArrayList<VOTableWriter> wlist = new ArrayList<VOTableWriter>();
        wlist.add(new VOTableWriter(DataFormat.TABLEDATA, true, version));
        wlist.add(new VOTableWriter(DataFormat.BINARY, true, version));
        if (version.allowBinary2()) {
            wlist.add(new VOTableWriter(DataFormat.BINARY2, true, version));
        }
        wlist.add(new VOTableWriter(DataFormat.FITS, false, version));
        wlist.add(new VOTableWriter(DataFormat.BINARY, false, version));
        if (version.allowBinary2()) {
            wlist.add(new VOTableWriter(DataFormat.BINARY2, false, version));
        }
        wlist.add(new VOTableWriter(DataFormat.FITS, true));
        return wlist.toArray(new StarTableWriter[0]);
    }
}

