/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.dom;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import uk.ac.starlink.votable.dom.DelegatingAttr;
import uk.ac.starlink.votable.dom.DelegatingCDATASection;
import uk.ac.starlink.votable.dom.DelegatingCharacterData;
import uk.ac.starlink.votable.dom.DelegatingComment;
import uk.ac.starlink.votable.dom.DelegatingDocumentFragment;
import uk.ac.starlink.votable.dom.DelegatingDocumentType;
import uk.ac.starlink.votable.dom.DelegatingElement;
import uk.ac.starlink.votable.dom.DelegatingEntity;
import uk.ac.starlink.votable.dom.DelegatingEntityReference;
import uk.ac.starlink.votable.dom.DelegatingNamedNodeMap;
import uk.ac.starlink.votable.dom.DelegatingNode;
import uk.ac.starlink.votable.dom.DelegatingNodeList;
import uk.ac.starlink.votable.dom.DelegatingNotation;
import uk.ac.starlink.votable.dom.DelegatingProcessingInstruction;
import uk.ac.starlink.votable.dom.DelegatingText;

public class DelegatingDocument
extends DelegatingNode
implements Document {
    private final Document base_;
    private final Map delegates_ = new HashMap();
    private String documentURI_;

    public DelegatingDocument(Document base, String documentURI) {
        super(base);
        this.setDocument(this);
        if (base == null) {
            throw new NullPointerException();
        }
        this.documentURI_ = documentURI;
        this.base_ = base;
    }

    public DelegatingDocument(String documentURI) {
        this(DelegatingDocument.makeEmptyDocument(), documentURI);
    }

    protected DelegatingNode getDelegator(Node baseNode) {
        DelegatingNode delegator;
        if (baseNode == null) {
            delegator = null;
        } else {
            delegator = (DelegatingNode)this.delegates_.get(baseNode);
            if (delegator == null) {
                delegator = this.createDelegator(baseNode);
                this.delegates_.put(baseNode, delegator);
            }
        }
        return delegator;
    }

    protected Document getBaseDocument() {
        return this.base_;
    }

    private DelegatingNode createDelegator(Node baseNode) {
        if (baseNode == null) {
            throw new NullPointerException();
        }
        if (baseNode instanceof CDATASection) {
            return this.createDelegatingCDATASection((CDATASection)baseNode);
        }
        if (baseNode instanceof Comment) {
            return this.createDelegatingComment((Comment)baseNode);
        }
        if (baseNode instanceof Text) {
            return this.createDelegatingText((Text)baseNode);
        }
        if (baseNode instanceof CharacterData) {
            return this.createDelegatingCharacterData((CharacterData)baseNode);
        }
        if (baseNode instanceof Attr) {
            return this.createDelegatingAttr((Attr)baseNode);
        }
        if (baseNode instanceof DocumentFragment) {
            return this.createDelegatingDocumentFragment((DocumentFragment)baseNode);
        }
        if (baseNode instanceof DocumentType) {
            return this.createDelegatingDocumentType((DocumentType)baseNode);
        }
        if (baseNode instanceof Element) {
            return this.createDelegatingElement((Element)baseNode);
        }
        if (baseNode instanceof Entity) {
            return this.createDelegatingEntity((Entity)baseNode);
        }
        if (baseNode instanceof EntityReference) {
            return this.createDelegatingEntityReference((EntityReference)baseNode);
        }
        if (baseNode instanceof Notation) {
            return this.createDelegatingNotation((Notation)baseNode);
        }
        if (baseNode instanceof ProcessingInstruction) {
            return this.createDelegatingProcessingInstruction((ProcessingInstruction)baseNode);
        }
        return this.createDelegatingSimpleNode(baseNode);
    }

    protected DelegatingNode createDelegatingSimpleNode(Node baseNode) {
        return baseNode == null ? null : new DelegatingNode(baseNode, this);
    }

    protected DelegatingAttr createDelegatingAttr(Attr baseNode) {
        return baseNode == null ? null : new DelegatingAttr(baseNode, this);
    }

    protected DelegatingAttr createDelegatingAttr(Attr baseNode, boolean isId) {
        return baseNode == null ? null : new DelegatingAttr(baseNode, this, isId);
    }

    protected DelegatingCDATASection createDelegatingCDATASection(CDATASection baseNode) {
        return baseNode == null ? null : new DelegatingCDATASection(baseNode, this);
    }

    protected DelegatingCharacterData createDelegatingCharacterData(CharacterData baseNode) {
        return baseNode == null ? null : new DelegatingCharacterData(baseNode, this);
    }

    protected DelegatingComment createDelegatingComment(Comment baseNode) {
        return baseNode == null ? null : new DelegatingComment(baseNode, this);
    }

    protected DelegatingDocumentFragment createDelegatingDocumentFragment(DocumentFragment baseNode) {
        return baseNode == null ? null : new DelegatingDocumentFragment(baseNode, this);
    }

    protected DelegatingDocumentType createDelegatingDocumentType(DocumentType baseNode) {
        return baseNode == null ? null : new DelegatingDocumentType(baseNode, this);
    }

    protected DelegatingElement createDelegatingElement(Element baseNode) {
        return baseNode == null ? null : new DelegatingElement(baseNode, this);
    }

    protected DelegatingEntity createDelegatingEntity(Entity baseNode) {
        return baseNode == null ? null : new DelegatingEntity(baseNode, this);
    }

    protected DelegatingEntityReference createDelegatingEntityReference(EntityReference baseNode) {
        return baseNode == null ? null : new DelegatingEntityReference(baseNode, this);
    }

    protected DelegatingNotation createDelegatingNotation(Notation baseNode) {
        return baseNode == null ? null : new DelegatingNotation(baseNode, this);
    }

    protected DelegatingProcessingInstruction createDelegatingProcessingInstruction(ProcessingInstruction baseNode) {
        return baseNode == null ? null : new DelegatingProcessingInstruction(baseNode, this);
    }

    protected DelegatingText createDelegatingText(Text baseNode) {
        return baseNode == null ? null : new DelegatingText(baseNode, this);
    }

    protected NodeList createDelegatingNodeList(NodeList baseList) {
        return baseList == null ? null : new DelegatingNodeList(baseList, this);
    }

    protected NamedNodeMap createDelegatingNamedNodeMap(NamedNodeMap baseMap) {
        return baseMap == null ? null : new DelegatingNamedNodeMap(baseMap, this);
    }

    private static Document makeEmptyDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw (RuntimeException)new IllegalStateException("Can't create a new Document").initCause(e);
        }
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.base_.getImplementation();
    }

    @Override
    public DocumentType getDoctype() {
        return (DocumentType)((Object)this.getDelegator(this.base_.getDoctype()));
    }

    @Override
    public Element getDocumentElement() {
        return (Element)((Object)this.getDelegator(this.base_.getDocumentElement()));
    }

    @Override
    public Element createElement(String tagName) {
        return (Element)((Object)this.getDelegator(this.base_.createElement(tagName)));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return (DocumentFragment)((Object)this.getDelegator(this.base_.createDocumentFragment()));
    }

    @Override
    public Text createTextNode(String data) {
        return (Text)((Object)this.getDelegator(this.base_.createTextNode(data)));
    }

    @Override
    public Comment createComment(String data) {
        return (Comment)((Object)this.getDelegator(this.base_.createComment(data)));
    }

    @Override
    public CDATASection createCDATASection(String data) {
        return (CDATASection)((Object)this.getDelegator(this.base_.createCDATASection(data)));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return (ProcessingInstruction)((Object)this.getDelegator(this.base_.createProcessingInstruction(target, data)));
    }

    @Override
    public Attr createAttribute(String name) {
        return (Attr)((Object)this.getDelegator(this.base_.createAttribute(name)));
    }

    @Override
    public EntityReference createEntityReference(String name) {
        return (EntityReference)((Object)this.getDelegator(this.base_.createEntityReference(name)));
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.createDelegatingNodeList(this.base_.getElementsByTagName(tagname));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        return this.getDelegator(this.base_.importNode(importedNode, deep));
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return (Element)((Object)this.getDelegator(this.base_.createElementNS(namespaceURI, qualifiedName)));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return (Attr)((Object)this.getDelegator(this.base_.createAttributeNS(namespaceURI, qualifiedName)));
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.base_.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public Element getElementById(String elementId) {
        return (Element)((Object)this.getDelegator(this.base_.getElementById(elementId)));
    }

    @Override
    public String getInputEncoding() {
        return this.base_.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.base_.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.base_.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) {
        this.base_.setXmlStandalone(xmlStandalone);
    }

    @Override
    public String getXmlVersion() {
        return this.base_.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) {
        this.base_.setXmlVersion(xmlVersion);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.base_.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.base_.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI_ == null ? this.base_.getDocumentURI() : this.documentURI_;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI_ = null;
        this.base_.setDocumentURI(documentURI);
    }

    @Override
    public Node adoptNode(Node source) {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.base_.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        this.base_.normalizeDocument();
    }

    @Override
    public Node renameNode(Node node, String namespaceURI, String qualifiedName) {
        return this.getDelegator(this.base_.renameNode(DelegatingNode.getBaseNode(node, this), namespaceURI, qualifiedName));
    }
}

