/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import uk.ac.starlink.votable.dom.DelegatingDocument;

public class DelegatingNode
implements Node {
    private final Node base_;
    private DelegatingDocument doc_;

    protected DelegatingNode(Node base, DelegatingDocument doc) {
        this.base_ = base;
        this.setDocument(doc);
    }

    DelegatingNode(Node base) {
        this.base_ = base;
    }

    void setDocument(DelegatingDocument doc) {
        if (this.base_ instanceof DelegatingNode && ((DelegatingNode)this.base_).doc_ == this) {
            throw new IllegalArgumentException("Attempt to use delegating node as delegate in same document");
        }
        this.doc_ = doc;
    }

    static Node getBaseNode(Node node, Document doc) {
        if (node == null) {
            return null;
        }
        if (node instanceof DelegatingNode) {
            DelegatingNode dnode = (DelegatingNode)node;
            if (dnode.doc_ == doc || doc == null) {
                return dnode.base_;
            }
            throw new DOMException(4, "Wrong document");
        }
        throw new DOMException(4, "Not a delegating node " + node + " (" + node.getClass().getName() + ")");
    }

    @Override
    public String getNodeName() {
        return this.base_.getNodeName();
    }

    @Override
    public String getNodeValue() {
        return this.base_.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.base_.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return this.base_.getNodeType();
    }

    @Override
    public Node getParentNode() {
        Node baseParent = this.base_.getParentNode();
        if (baseParent != null && baseParent == this.base_.getOwnerDocument()) {
            return this.doc_;
        }
        return this.doc_.getDelegator(baseParent);
    }

    @Override
    public NodeList getChildNodes() {
        return this.doc_.createDelegatingNodeList(this.base_.getChildNodes());
    }

    @Override
    public Node getFirstChild() {
        return this.doc_.getDelegator(this.base_.getFirstChild());
    }

    @Override
    public Node getLastChild() {
        return this.doc_.getDelegator(this.base_.getLastChild());
    }

    @Override
    public Node getPreviousSibling() {
        return this.doc_.getDelegator(this.base_.getPreviousSibling());
    }

    @Override
    public Node getNextSibling() {
        return this.doc_.getDelegator(this.base_.getNextSibling());
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.doc_.createDelegatingNamedNodeMap(this.base_.getAttributes());
    }

    @Override
    public Document getOwnerDocument() {
        return this == this.doc_ ? null : this.doc_;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        Node refChildBase = DelegatingNode.getBaseNode(refChild, null);
        return this.doc_.getDelegator(this.base_.insertBefore(newChildBase, refChildBase));
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        Node oldChildBase = DelegatingNode.getBaseNode(oldChild, null);
        return this.doc_.getDelegator(this.base_.replaceChild(newChildBase, oldChildBase));
    }

    @Override
    public Node removeChild(Node oldChild) {
        Node oldChildBase = DelegatingNode.getBaseNode(oldChild, null);
        return this.doc_.getDelegator(this.base_.removeChild(oldChildBase));
    }

    @Override
    public Node appendChild(Node newChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        return this.doc_.getDelegator(this.base_.appendChild(newChildBase));
    }

    @Override
    public boolean hasChildNodes() {
        return this.base_.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.doc_.getDelegator(this.base_.cloneNode(deep));
    }

    @Override
    public void normalize() {
        this.base_.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.base_.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.base_.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.base_.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.base_.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        return this.base_.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.base_.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.base_.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) {
        if (other instanceof DelegatingNode) {
            return this.base_.compareDocumentPosition(DelegatingNode.getBaseNode(other, null));
        }
        throw new DOMException(9, "Wrong type of node");
    }

    @Override
    public String getTextContent() {
        return this.base_.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) {
        this.base_.setTextContent(textContent);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.base_.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.base_.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.base_.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isSameNode(Node other) {
        if (other instanceof DelegatingNode) {
            return this.base_.isSameNode(DelegatingNode.getBaseNode(other, this.doc_));
        }
        return false;
    }

    @Override
    public boolean isEqualNode(Node other) {
        return this.base_.isEqualNode(other);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.base_.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.base_.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.base_.getUserData(key);
    }
}

