/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import uk.ac.starlink.astrogrid.AcrBranch;
import uk.ac.starlink.astrogrid.AcrConnector;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;

public class AcrConnection
extends Connection {
    private final AcrBranch root_;
    private final XmlRpcClient client_;
    private boolean cacheDirectories_;
    public static String ACR_FILE = ".astrogrid-desktop";
    public static int HTTP_CHUNK = 0x100000;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.astrogrid");

    public AcrConnection(AcrConnector connector) throws IOException {
        super(connector, new HashMap());
        URL url;
        try {
            url = AcrConnection.getServerURL();
        }
        catch (FileNotFoundException e) {
            String msg = "The ACR is does not appear to be running (no ~/" + ACR_FILE + ")\n" + "To enable MySpace access, start the Astrogrid " + "Desktop\n" + "(http://software.astrogrid.org/jnlp/" + "astrogrid-desktop/astrogrid-desktop.jnlp)";
            throw (IOException)new IOException(msg).initCause(e);
        }
        this.client_ = new XmlRpcClient(url);
        logger_.info("xml-rpc server for ACR: \"" + url + "\"");
        String homeUri = (String)this.execute("astrogrid.myspace.getHome", null);
        this.root_ = new AcrBranch(this, homeUri, homeUri, null);
    }

    public boolean isConnected() {
        try {
            Object isConn = this.execute("astrogrid.community.isLoggedIn", null);
            return Boolean.TRUE.equals(isConn);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Branch getRoot() {
        return this.root_;
    }

    public void logOut() {
    }

    public String getHome() {
        return this.root_.uri_;
    }

    public boolean getCacheDirectories() {
        return this.cacheDirectories_;
    }

    public void setCacheDirectories(boolean cache) {
        this.cacheDirectories_ = cache;
    }

    public Object execute(String cmd, Object[] args) throws IOException {
        Vector argv = args == null ? new Vector() : new Vector<Object>(Arrays.asList(args));
        logger_.info("xmlrpc: " + cmd + argv);
        try {
            Object result = this.client_.execute(cmd, argv);
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Throwable) {
                Throwable err = (Throwable)result;
                String msg = err.getMessage();
                if (msg == null) {
                    msg = "ACR error";
                }
                throw (IOException)new IOException(msg).initCause(err);
            }
            if (result instanceof Collection) {
                return ((Collection)result).toArray();
            }
            return result;
        }
        catch (XmlRpcException e) {
            throw (IOException)new IOException("Error communicating with ACR").initCause(e);
        }
    }

    public OutputStream getOutputStream(String outUri) throws IOException {
        try {
            return this.getHttpOutputStream(outUri);
        }
        catch (IOException e) {
            logger_.warning("Failed to output using HTTP streaming try temporary file: " + e);
            return this.getTempFileOutputStream(outUri);
        }
    }

    private OutputStream getHttpOutputStream(String outUri) throws IOException {
        Object[] uriArgs = new Object[]{outUri};
        boolean exists = (Boolean)this.execute("astrogrid.myspace.exists", uriArgs);
        if (!exists) {
            this.execute("astrogrid.myspace.createFile", uriArgs);
        } else {
            logger_.warning("Overwriting existing MySpace file " + outUri);
        }
        String outLoc = (String)this.execute("astrogrid.myspace.getWriteContentURL", uriArgs);
        URL url = new URL(outLoc);
        final HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setAllowUserInteraction(false);
        httpConn.setDoOutput(true);
        httpConn.setUseCaches(false);
        httpConn.setRequestMethod("PUT");
        httpConn.setChunkedStreamingMode(HTTP_CHUNK);
        logger_.config("Streaming with chunk size " + HTTP_CHUNK + "to remote URL " + url);
        httpConn.connect();
        OutputStream httpStream = httpConn.getOutputStream();
        return new FilterOutputStream(httpStream){

            public void close() throws IOException {
                this.flush();
                super.close();
                int response = httpConn.getResponseCode();
                logger_.info("Response code from writable HTTP connection: " + response);
            }
        };
    }

    private OutputStream getTempFileOutputStream(final String outUri) throws IOException {
        final File file = File.createTempFile("acr-temp", ".dat");
        file.deleteOnExit();
        final String fileURL = file.toURL().toString();
        FileOutputStream ostrm = new FileOutputStream(file){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                try {
                    AcrConnection.this.execute("astrogrid.myspace.copyURLToContent", new Object[]{fileURL, outUri});
                }
                finally {
                    if (file.delete()) {
                        logger_.info("Temporary file " + file + " deleted");
                    }
                }
            }
        };
        logger_.info("Writing MySpace-bound data to temp file " + file);
        return ostrm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getServerURL() throws IOException {
        InputStream istrm = null;
        try {
            int c;
            File rvfile = new File(System.getProperty("user.home"), ACR_FILE);
            istrm = new BufferedInputStream(new FileInputStream(rvfile));
            StringBuffer sbuf = new StringBuffer();
            while ((c = istrm.read()) >= 0 && c != 10 && c != 13) {
                sbuf.append((char)c);
            }
            URL uRL = new URL(sbuf.toString().trim() + "xmlrpc");
            return uRL;
        }
        finally {
            if (istrm != null) {
                try {
                    istrm.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

