/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.mirage;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import uk.ac.starlink.mirage.MirageFormatter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.FilestoreTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoadPanel;
import uk.ac.starlink.util.AuxClassLoader;

public class MirageDriver {
    public static final String MIRAGE_CLASS = "mirage.Mirage";
    public static final String MIRAGE_CLASSPATH_PROP = "uk.ac.starlink.mirage.class.path";

    public static void main(String[] args) throws IOException, Exception {
        StarTable table = null;
        boolean dump = false;
        String usage = "Usage:\n   MirageDriver [-help] | [-dump] table | [mirageflags] table\n";
        ArrayList<String> mirageArgs = new ArrayList<String>();
        if (args.length == 0) {
            StarTable[] tables = TableLoadPanel.loadTables(null, new FilestoreTableLoadDialog(), new StarTableFactory(false));
            StarTable starTable = table = tables != null && tables.length > 0 ? tables[0] : null;
            if (table == null) {
                System.err.println("No table selected");
                System.exit(1);
            }
        } else {
            String tableName = null;
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                String arg = it.next();
                if (arg.equals("-dump")) {
                    dump = true;
                    continue;
                }
                if (arg.equals("-help") || arg.equals("-h")) {
                    System.out.println(usage);
                    System.exit(0);
                    continue;
                }
                if (arg.equals("-log") || arg.equals("-cmd") || arg.equals("-path")) {
                    try {
                        mirageArgs.add(arg);
                        mirageArgs.add(it.next());
                    }
                    catch (NoSuchElementException e) {
                        System.err.println(usage);
                        System.exit(1);
                    }
                    continue;
                }
                if (arg.equals("-off")) {
                    mirageArgs.add(arg);
                    continue;
                }
                if (arg.startsWith("-")) {
                    mirageArgs.add(arg);
                    continue;
                }
                if (tableName != null) {
                    System.err.println(usage);
                    System.exit(1);
                    continue;
                }
                tableName = arg;
            }
            if (tableName == null) {
                System.err.println(usage);
                System.exit(1);
            }
            try {
                table = new StarTableFactory(false).makeStarTable(tableName);
            }
            catch (IOException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
        if (dump) {
            MirageFormatter mf = new MirageFormatter(System.out);
            mf.writeMirageFormat(table);
        } else if (MirageDriver.isMirageAvailable()) {
            MirageDriver.invokeMirage(table, mirageArgs);
        } else {
            System.err.println("Mirage application not found.");
            System.err.println("The class mirage.Mirage must exist on the path named by the property uk.ac.starlink.mirage.class.path");
            System.exit(1);
        }
    }

    public static boolean isMirageAvailable() {
        try {
            String miragePath = System.getProperty(MIRAGE_CLASSPATH_PROP);
            Class<?> mirageClass = new AuxClassLoader(miragePath).loadClass(MIRAGE_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void invokeMirage(StarTable table, List margs) throws ClassNotFoundException, Exception {
        String miragePath = System.getProperty(MIRAGE_CLASSPATH_PROP);
        Class<?> mirageClass = new AuxClassLoader(miragePath).loadClass(MIRAGE_CLASS);
        File tmpfile = File.createTempFile("mdata", ".dat");
        tmpfile.deleteOnExit();
        FileOutputStream ostrm = new FileOutputStream(tmpfile);
        PrintStream pstrm = new PrintStream(ostrm);
        new MirageFormatter(pstrm).writeMirageFormat(table);
        ((OutputStream)ostrm).close();
        pstrm.close();
        if (margs == null) {
            margs = new ArrayList<String>();
        }
        margs.add("-data");
        margs.add(tmpfile.getPath());
        MirageDriver.invokeMain(mirageClass, margs.toArray(new String[0]));
    }

    private static void invokeMain(Class clazz, String[] args) throws Exception {
        Class[] mainArgsClasses = new Class[]{String;.class};
        Method mainMethod = clazz.getMethod("main", mainArgsClasses);
        mainMethod.invoke(null, new Object[]{args});
    }
}

