/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.mirage;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;

public class MirageFormatter {
    protected PrintStream strm;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public MirageFormatter(PrintStream strm) {
        this.strm = strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMirageFormat(StarTable table) throws IOException {
        int i;
        this.strm.println("#\n# Written by " + this);
        int ncol = table.getColumnCount();
        String[] colNames = new String[ncol];
        boolean[] isUsed = new boolean[ncol];
        boolean[] isText = new boolean[ncol];
        int nText = 0;
        for (i = 0; i < ncol; ++i) {
            Class clazz;
            ColumnInfo cinfo = table.getColumnInfo(i);
            String colName = cinfo.getName();
            if (colName == null) continue;
            colNames[i] = colName = colName.replaceAll("\\s+", "_");
            if ((class$java$lang$Number == null ? MirageFormatter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz = cinfo.getContentClass())) {
                isUsed[i] = true;
                continue;
            }
            if (clazz.equals(class$java$lang$String == null ? MirageFormatter.class$("java.lang.String") : class$java$lang$String)) {
                isUsed[i] = true;
                isText[i] = true;
                ++nText;
                continue;
            }
            this.strm.println("# Omitted column " + i + ": " + cinfo);
        }
        this.strm.println("#\n# Column names");
        this.strm.print("format var");
        for (i = 0; i < ncol; ++i) {
            if (!isUsed[i]) continue;
            this.strm.print(" " + colNames[i]);
        }
        this.strm.println();
        if (nText > 0) {
            this.strm.println("#\n# Text columns");
            for (i = 0; i < ncol; ++i) {
                if (!isText[i]) continue;
                this.strm.println("format text " + colNames[i]);
            }
        }
        this.strm.println("#\n# Table data");
        RowSequence rseq = table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int i2 = 0; i2 < ncol; ++i2) {
                    String cell;
                    if (!isUsed[i2]) continue;
                    Object datum = row[i2];
                    if (datum == null) {
                        cell = "<blank>";
                    } else {
                        cell = row[i2].toString().trim();
                        if (isText[i2]) {
                            cell = cell.length() == 0 ? "<blank>" : cell.replaceAll("\\s+", "_");
                        }
                    }
                    this.strm.print(cell);
                    this.strm.print(' ');
                }
                this.strm.println();
            }
        }
        finally {
            rseq.close();
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static void main(String[] args) throws IOException {
        StarTable tab;
        String usage = "Usage: MirageFormatter table\n";
        if (args.length != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        if ((tab = new StarTableFactory(false).makeStarTable(args[0])) == null) {
            System.err.println("No known table " + args[0]);
            System.exit(1);
        }
        new MirageFormatter(System.out).writeMirageFormat(tab);
    }
}

