/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.IOUtils;

public abstract class AbstractFitsTableWriter
extends StreamStarTableWriter
implements MultiStarTableWriter {
    private String formatName_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected AbstractFitsTableWriter(String formatName) {
        this.setFormatName(formatName);
    }

    @Override
    public String getFormatName() {
        return this.formatName_;
    }

    public void setFormatName(String formatName) {
        this.formatName_ = formatName;
    }

    @Override
    public String getMimeType() {
        return "application/fits";
    }

    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(table), out);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        DataOutputStream ostrm = new DataOutputStream(out);
        this.writePrimaryHDU(ostrm);
        while ((table = tableSeq.nextTable()) != null) {
            this.writeTableHDU(table, this.createSerializer(table), ostrm);
        }
        ostrm.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        OutputStream out = sto.getOutputStream(location);
        try {
            out = new BufferedOutputStream(out);
            this.writeStarTables(tableSeq, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public void writePrimaryHDU(DataOutput out) throws IOException {
        FitsConstants.writeEmptyPrimary(out);
    }

    public void writeTableHDU(StarTable table, FitsTableSerializer fitser, DataOutput out) throws IOException {
        try {
            Header hdr = fitser.getHeader();
            this.addMetadata(hdr);
            FitsConstants.writeHeader(out, hdr);
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        fitser.writeData(out);
    }

    protected abstract FitsTableSerializer createSerializer(StarTable var1) throws IOException;

    protected void addMetadata(Header hdr) {
        try {
            hdr.addValue("DATE-HDU", AbstractFitsTableWriter.getCurrentDate(), "Date of HDU creation (UTC)");
            hdr.addValue("STILVERS", IOUtils.getResourceContents(StarTable.class, (String)"stil.version", null), "Version of STIL software");
            hdr.addValue("STILCLAS", this.getClass().getName(), "Author class in STIL software");
        }
        catch (HeaderCardException e) {
            logger_.warning("Trouble adding metadata header cards " + e);
        }
    }

    public static String getCurrentDate() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        fmt.setTimeZone(utc);
        fmt.setCalendar(new GregorianCalendar(utc, Locale.UK));
        return fmt.format(new Date());
    }
}

