/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.util.logging.Logger;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.HeaderCards;
import uk.ac.starlink.fits.WideFits;

public abstract class AbstractWideFits
implements WideFits {
    private final int icolContainer_;
    private final int extColMax_;
    private final String name_;
    public static final String KEY_ICOL_CONTAINER = "XT_ICOL";
    public static final String KEY_NCOL_EXT = "XT_NCOL";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected AbstractWideFits(int icolContainer, int extColMax, String implName) {
        this.icolContainer_ = icolContainer;
        if (this.icolContainer_ > 999) {
            throw new IllegalArgumentException("Container column index > 999");
        }
        this.extColMax_ = extColMax;
        this.name_ = implName + (icolContainer == 999 ? "" : Integer.valueOf(icolContainer));
    }

    @Override
    public int getContainerColumnIndex() {
        return this.icolContainer_;
    }

    @Override
    public int getExtColumnMax() {
        return this.extColMax_;
    }

    @Override
    public void addContainerColumnHeader(Header hdr, long nbyteExt, long nslice) {
        String dimStr;
        int formSiz;
        char formChr;
        long elSize;
        long l = elSize = nslice > 0L ? nbyteExt / nslice : nbyteExt;
        if (elSize % 2L == 0L) {
            formChr = 'I';
            formSiz = 2;
        } else {
            formChr = 'B';
            formSiz = 1;
        }
        long nEl = nbyteExt / (long)formSiz;
        assert (nEl * (long)formSiz == nbyteExt);
        if (nslice > 0L) {
            if (nEl % nslice == 0L) {
                dimStr = new StringBuffer().append('(').append(nEl / nslice).append(',').append(nslice).append(')').toString();
            } else {
                logger_.severe(nEl + " not divisible by " + nslice + " - no TDIM" + this.icolContainer_);
                dimStr = null;
            }
        } else {
            dimStr = null;
        }
        BintableColumnHeader colhead = BintableColumnHeader.createStandardHeader(this.icolContainer_);
        String forcol = " for column " + this.icolContainer_;
        try {
            hdr.addValue(colhead.getKeyName("TTYPE"), "XT_MORECOLS", "label" + forcol);
            hdr.addValue(colhead.getKeyName("TFORM"), nEl + "" + formChr, "format" + forcol);
            if (dimStr != null) {
                hdr.addValue(colhead.getKeyName("TDIM"), dimStr, "dimensions" + forcol);
            }
            hdr.addValue(colhead.getKeyName("TCOMM"), "Extension buffer for columns beyond " + this.icolContainer_, null);
        }
        catch (HeaderCardException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addExtensionHeader(Header hdr, int ncolExt) {
        try {
            hdr.addValue(KEY_ICOL_CONTAINER, this.icolContainer_, "index of container column");
            hdr.addValue(KEY_NCOL_EXT, ncolExt, "total columns including extended");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getExtendedColumnCount(HeaderCards cards, int ncolStd) {
        Integer icolContainerValue = cards.getIntValue(KEY_ICOL_CONTAINER);
        Integer ncolExtValue = cards.getIntValue(KEY_NCOL_EXT);
        if (icolContainerValue == null && ncolExtValue == null) {
            return ncolStd;
        }
        if (icolContainerValue == null || ncolExtValue == null) {
            logger_.warning("FITS header has one but not both of XT_ICOL and XT_NCOL - no extended columns");
            return ncolStd;
        }
        int icolContainer = icolContainerValue;
        int ncolExt = ncolExtValue;
        if (icolContainer != ncolStd) {
            logger_.warning("FITS header XT_ICOL=" + icolContainer + " != standard column count (TFIELDS) " + ncolStd + " - no extended columns");
            return ncolStd;
        }
        for (String tkey : new String[]{"TTYPE", "TFORM", "TCOMM"}) {
            cards.useKey(tkey + icolContainer);
        }
        logger_.config("Located extended columns in wide FITS file");
        return ncolExt;
    }

    public String toString() {
        return this.name_;
    }

    public static WideFits createAlphaWideFits(int icolContainer) {
        return new AlphaWideFits(icolContainer);
    }

    public static WideFits createHierarchWideFits(int icolContainer) {
        return new HierarchWideFits(icolContainer);
    }

    public static void logWideWrite(Logger logger, int nStdcol, int nAllcol) {
        if (nAllcol > nStdcol) {
            logger.warning("Using non-standard extended column convention");
            logger.warning("Other FITS software may not see columns " + nStdcol + "-" + nAllcol);
        }
    }

    public static void logWideRead(Logger logger, int nStdcol, int nAllcol) {
        if (nAllcol > nStdcol) {
            logger.info("Using non-standard extended column convention for columns " + nStdcol + "-" + nAllcol);
        }
    }

    static class HierarchWideFits
    extends AbstractWideFits {
        public static final String NAMESPACE = "XT";

        public HierarchWideFits(int icolContainer) {
            super(icolContainer, Integer.MAX_VALUE, "hierarch");
        }

        @Override
        public BintableColumnHeader createExtendedHeader(int icolContainer, final int jcol) {
            return new BintableColumnHeader(){

                @Override
                public String getKeyName(String stdName) {
                    return new StringBuffer().append("HIERARCH").append(".").append(HierarchWideFits.NAMESPACE).append(".").append(stdName).append(jcol).toString();
                }
            };
        }

        @Override
        public void addExtensionHeader(Header hdr, int ncolExt) {
            this.checkHasHierarch(false);
            super.addExtensionHeader(hdr, ncolExt);
        }

        @Override
        public int getExtendedColumnCount(HeaderCards cards, int ncolStd) {
            int ncolExt = super.getExtendedColumnCount(cards, ncolStd);
            if (ncolExt > ncolStd) {
                this.checkHasHierarch(true);
            }
            return ncolExt;
        }

        private void checkHasHierarch(boolean isRead) {
            if (!FitsFactory.getUseHierarch()) {
                logger_.severe("FitsFactory.useHierarch=false: HIERARCH-based wide FITS table convention " + (isRead ? "read" : "write") + " will fail!");
            }
        }
    }

    static class AlphaWideFits
    extends AbstractWideFits {
        private static final char DIGIT0 = 'A';
        private static final int NDIGIT = 26;

        public AlphaWideFits(int icolContainer) {
            super(icolContainer, icolContainer - 1 + 17576, "alpha");
        }

        @Override
        public BintableColumnHeader createExtendedHeader(int icolContainer, int jcol) {
            final String jcolStr = this.encodeInteger(jcol - icolContainer);
            return new BintableColumnHeader(){

                @Override
                public String getKeyName(String stdName) {
                    return stdName + jcolStr;
                }
            };
        }

        public String encodeInteger(int ix) {
            int base = 26;
            int max = base * base * base;
            if (ix >= 0 && ix < max) {
                char[] digits = new char[3];
                int j = ix;
                for (int k = 0; k < 3; ++k) {
                    digits[2 - k] = (char)(65 + j % base);
                    j /= base;
                }
                return new String(digits);
            }
            String msg = "Out of range (0-" + (max - 1) + "): " + ix;
            throw new NumberFormatException(msg);
        }
    }
}

