/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;

abstract class ArrayStorage {
    private final Class componentClass_;
    private final char formatChar_;
    private final int typeBytes_;
    public static ArrayStorage BOOLEAN = new ArrayStorage(Boolean.TYPE, 'L', 1){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            boolean[] values = (boolean[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeByte(values[i] ? 84 : 70);
            }
        }
    };
    public static ArrayStorage BYTE = new ArrayStorage(Byte.TYPE, 'B', 1){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            out.write((byte[])array);
        }
    };
    public static ArrayStorage SHORT = new ArrayStorage(Short.TYPE, 'I', 2){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            short[] values = (short[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeShort(values[i]);
            }
        }
    };
    public static ArrayStorage INT = new ArrayStorage(Integer.TYPE, 'J', 4){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            int[] values = (int[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeInt(values[i]);
            }
        }
    };
    public static ArrayStorage LONG = new ArrayStorage(Long.TYPE, 'K', 8){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            long[] values = (long[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeLong(values[i]);
            }
        }
    };
    public static ArrayStorage FLOAT = new ArrayStorage(Float.TYPE, 'E', 4){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            float[] values = (float[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeFloat(values[i]);
            }
        }
    };
    public static ArrayStorage DOUBLE = new ArrayStorage(Double.TYPE, 'D', 8){

        @Override
        public void writeArray(Object array, DataOutput out) throws IOException {
            double[] values = (double[])array;
            for (int i = 0; i < values.length; ++i) {
                out.writeDouble(values[i]);
            }
        }
    };

    protected ArrayStorage(Class componentClass, char formatChar, int typeBytes) {
        this.componentClass_ = componentClass;
        this.formatChar_ = formatChar;
        this.typeBytes_ = typeBytes;
    }

    public Class getComponentClass() {
        return this.componentClass_;
    }

    public char getFormatChar() {
        return this.formatChar_;
    }

    public int getTypeBytes() {
        return this.typeBytes_;
    }

    public abstract void writeArray(Object var1, DataOutput var2) throws IOException;
}

