/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;

abstract class ArrayWriter {
    private final char formatChar_;
    private final int nByte_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected ArrayWriter(char formatChar, int nByte) {
        this.formatChar_ = formatChar;
        this.nByte_ = nByte;
    }

    public char getFormatChar() {
        return this.formatChar_;
    }

    public int getByteCount() {
        return this.nByte_;
    }

    public abstract void writeElement(DataOutput var1, Object var2, int var3) throws IOException;

    public abstract void writePad(DataOutput var1) throws IOException;

    public abstract double getZero();

    public static ArrayWriter createArrayWriter(ColumnInfo cinfo, boolean allowSignedByte) {
        Class clazz = cinfo.getContentClass();
        boolean isUbyte = Boolean.TRUE.equals(cinfo.getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class));
        if (isUbyte) {
            if (clazz == short[].class) {
                return new NormalArrayWriter('B', 1, new short[]{0}){

                    @Override
                    public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                        out.writeByte(((short[])array)[ix]);
                    }
                };
            }
            logger_.warning("Ignoring " + Tables.UBYTE_FLAG_INFO + " on non-short[] column " + cinfo);
        }
        if (clazz == boolean[].class) {
            return new ArrayWriter('L', 1){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeByte(((boolean[])array)[ix] ? 84 : 70);
                }

                @Override
                public void writePad(DataOutput out) throws IOException {
                    out.writeByte(0);
                }

                @Override
                public double getZero() {
                    return 0.0;
                }
            };
        }
        if (clazz == byte[].class) {
            if (allowSignedByte) {
                return new NormalArrayWriter('B', 1, new byte[]{0}){

                    @Override
                    public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                        out.writeByte(((byte[])array)[ix] ^ 0xFFFFFF80);
                    }

                    @Override
                    public double getZero() {
                        return -128.0;
                    }
                };
            }
            return new NormalArrayWriter('I', 2, new byte[]{0}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeShort(((byte[])array)[ix]);
                }
            };
        }
        if (clazz == short[].class) {
            return new NormalArrayWriter('I', 2, new short[]{0}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeShort(((short[])array)[ix]);
                }
            };
        }
        if (clazz == int[].class) {
            return new NormalArrayWriter('J', 4, new int[]{0}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeInt(((int[])array)[ix]);
                }
            };
        }
        if (clazz == long[].class) {
            return new NormalArrayWriter('K', 8, new long[]{0L}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeLong(((long[])array)[ix]);
                }
            };
        }
        if (clazz == float[].class) {
            return new NormalArrayWriter('E', 4, new float[]{Float.NaN}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeFloat(((float[])array)[ix]);
                }
            };
        }
        if (clazz == double[].class) {
            return new NormalArrayWriter('D', 8, new double[]{Double.NaN}){

                @Override
                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeDouble(((double[])array)[ix]);
                }
            };
        }
        return null;
    }

    private static abstract class NormalArrayWriter
    extends ArrayWriter {
        private final Object pad1_;

        protected NormalArrayWriter(char formatChar, int nByte, Object pad1) {
            super(formatChar, nByte);
            this.pad1_ = pad1;
            if (Array.getLength(pad1) != 1) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void writePad(DataOutput out) throws IOException {
            this.writeElement(out, this.pad1_, 0);
        }

        @Override
        public double getZero() {
            return 0.0;
        }
    }
}

