/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import uk.ac.starlink.fits.HeaderCards;

public abstract class BintableColumnHeader {
    protected BintableColumnHeader() {
    }

    public abstract String getKeyName(String var1);

    public String getStringValue(HeaderCards cards, String stdName) {
        String key = this.getKeyName(stdName);
        return key == null ? null : cards.getStringValue(key);
    }

    public Long getLongValue(HeaderCards cards, String stdName) {
        String key = this.getKeyName(stdName);
        return key == null ? null : cards.getLongValue(key);
    }

    public Double getDoubleValue(HeaderCards cards, String stdName) {
        String key = this.getKeyName(stdName);
        return key == null ? null : cards.getDoubleValue(key);
    }

    public boolean containsKey(HeaderCards cards, String stdName) {
        String key = this.getKeyName(stdName);
        return key != null && cards.containsKey(key);
    }

    public static BintableColumnHeader createStandardHeader(int jcol) {
        final String jcolStr = Integer.toString(jcol);
        return new BintableColumnHeader(){

            @Override
            public String getKeyName(String stdName) {
                return stdName + jcolStr;
            }
        };
    }
}

