/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import uk.ac.starlink.fits.AbstractWideFits;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BasicInputThreadLocal;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.ColumnReader;
import uk.ac.starlink.fits.HeaderCards;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class BintableStarTable
extends AbstractStarTable
implements Closeable {
    private final int ncol_;
    private final long nrow_;
    private final ColumnInfo[] colInfos_;
    private final ColumnReader[] colReaders_;
    private final int rowLength_;
    private final int[] colOffsets_;
    public static final ValueInfo TNULL_INFO = new DefaultValueInfo(Tables.NULL_VALUE_INFO.getName(), Tables.NULL_VALUE_INFO.getContentClass(), "Bad value indicator (TNULLn card)");
    public static final ValueInfo TSCAL_INFO = new DefaultValueInfo("Scale", Double.class, "Multiplier for values (TSCALn card)");
    public static final ValueInfo TZERO_INFO = new DefaultValueInfo("Zero", Number.class, "Offset for values (TZEROn card)");
    public static final ValueInfo TDISP_INFO = new DefaultValueInfo("Format", String.class, "Display format in FORTRAN notation (TDISPn card)");
    public static final ValueInfo TBCOL_INFO = new DefaultValueInfo("Start column", Integer.class, "Start column for data (TBCOLn card)");
    public static final ValueInfo TFORM_INFO = new DefaultValueInfo("Format code", String.class, "Data type code (TFORMn card)");
    private static final ValueInfo[] AUX_DATA_INFOS = new ValueInfo[]{TNULL_INFO, TSCAL_INFO, TZERO_INFO, TDISP_INFO, TBCOL_INFO, TFORM_INFO};
    static final BigInteger TWO63 = BigInteger.ONE.shiftLeft(63);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected BintableStarTable(Header hdr, boolean isRandom, WideFits wide) throws FitsException {
        boolean hasExtCol;
        HeaderCards cards = new HeaderCards(hdr);
        if (!cards.getStringValue("XTENSION").equals("BINTABLE")) {
            throw new IllegalArgumentException("Not a binary table header");
        }
        this.nrow_ = cards.getLongValue("NAXIS2").intValue();
        int ncolStd = cards.getIntValue("TFIELDS");
        this.ncol_ = wide != null ? wide.getExtendedColumnCount(cards, ncolStd) : ncolStd;
        boolean bl = hasExtCol = this.ncol_ > ncolStd;
        if (hasExtCol) {
            assert (wide != null);
            AbstractWideFits.logWideRead(logger_, ncolStd, this.ncol_);
        }
        long heapOffset = isRandom ? (cards.containsKey("THEAP") ? cards.getLongValue("THEAP") : this.nrow_ * (long)cards.getIntValue("NAXIS1").intValue()) : -1L;
        this.colInfos_ = new ColumnInfo[this.ncol_];
        this.colReaders_ = new ColumnReader[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnReader reader;
            String tutype;
            String tucd;
            String tform;
            Number zero;
            double scale;
            String[] sdims;
            boolean hasBlank;
            long blank;
            String tdisp;
            String tunit;
            int jcol = icol + 1;
            BintableColumnHeader colhead = hasExtCol && jcol >= ncolStd ? wide.createExtendedHeader(ncolStd, jcol) : BintableColumnHeader.createStandardHeader(jcol);
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            List auxdata = cinfo.getAuxData();
            this.colInfos_[icol] = cinfo;
            String ttype = colhead.getStringValue(cards, "TTYPE");
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = colhead.getStringValue(cards, "TUNIT")) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = colhead.getStringValue(cards, "TDISP")) != null) {
                auxdata.add(new DescribedValue(TDISP_INFO, tdisp));
            }
            if (colhead.containsKey(cards, "TNULL")) {
                blank = colhead.getLongValue(cards, "TNULL");
                hasBlank = true;
                auxdata.add(new DescribedValue(TNULL_INFO, new Long(blank)));
            } else {
                cinfo.setNullable(false);
                blank = 0L;
                hasBlank = false;
            }
            int[] dims = null;
            String tdim = colhead.getStringValue(cards, "TDIM");
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    dims = new int[sdims.length];
                    for (int i = 0; i < sdims.length; ++i) {
                        dims[i] = Integer.parseInt(sdims[i]);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (colhead.containsKey(cards, "TSCAL")) {
                scale = colhead.getDoubleValue(cards, "TSCAL");
                auxdata.add(new DescribedValue(TSCAL_INFO, new Double(scale)));
            } else {
                scale = 1.0;
            }
            if (colhead.containsKey(cards, "TZERO")) {
                Object zval;
                boolean zInLongRange;
                String zstr = colhead.getStringValue(cards, "TZERO");
                BigDecimal zbig = new BigDecimal(zstr);
                boolean zIsInt = zbig.compareTo(new BigDecimal(zbig.toBigInteger())) == 0;
                boolean bl2 = zInLongRange = zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MIN_VALUE))) >= 0 && zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE))) <= 0;
                if (zbig.compareTo(new BigDecimal(TWO63)) == 0) {
                    zero = TWO63;
                    zval = zstr;
                } else if (zIsInt && zInLongRange) {
                    zero = new Long(zbig.longValue());
                    zval = zero;
                } else {
                    zero = new Double(zbig.doubleValue());
                    zval = zero;
                }
                DefaultValueInfo zInfo = new DefaultValueInfo(TZERO_INFO);
                zInfo.setContentClass(zval.getClass());
                auxdata.add(new DescribedValue(zInfo, zval));
            } else {
                zero = new Long(0L);
            }
            String tbcol = colhead.getStringValue(cards, "TBCOL");
            if (tbcol != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(TBCOL_INFO, new Integer(bcolval)));
            }
            if ((tform = colhead.getStringValue(cards, "TFORM")) == null) {
                throw new FitsException("Missing column format header " + colhead.getKeyName("TFORM"));
            }
            auxdata.add(new DescribedValue(TFORM_INFO, tform));
            String tcomm = colhead.getStringValue(cards, "TCOMM");
            if (tcomm != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = colhead.getStringValue(cards, "TUCD")) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = colhead.getStringValue(cards, "TUTYP")) != null) {
                cinfo.setUtype(tutype);
            }
            try {
                reader = ColumnReader.createColumnReader(tform, scale, zero, hasBlank, blank, dims, ttype, heapOffset);
            }
            catch (FitsException e) {
                throw (FitsException)new FitsException("Error parsing header line TFORM" + jcol + " = " + tform).initCause(e);
            }
            if (reader.getContentClass().equals(String.class)) {
                cinfo.setNullable(true);
            }
            cinfo.setContentClass(reader.getContentClass());
            if (reader.getLength() > 0) {
                cinfo.setShape(reader.getShape());
            }
            cinfo.setElementSize(reader.getElementSize());
            if (reader.isUnsignedByte()) {
                cinfo.setAuxDatum(new DescribedValue(Tables.UBYTE_FLAG_INFO, Boolean.TRUE));
            }
            this.colReaders_[icol] = reader;
        }
        int leng = 0;
        this.colOffsets_ = new int[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            this.colOffsets_[icol] = leng;
            leng += this.colReaders_[icol].getLength();
        }
        this.rowLength_ = cards.getIntValue("NAXIS1");
        if (!hasExtCol && this.rowLength_ != leng) {
            throw new FitsException("Got wrong row length: " + this.rowLength_ + " != " + leng);
        }
        if (cards.containsKey("EXTNAME")) {
            String tname = cards.getStringValue("EXTNAME");
            if (cards.containsKey("EXTVER")) {
                tname = tname + "-" + cards.getStringValue("EXTVER");
            }
            this.setName(tname);
        }
        this.getParameters().addAll(Arrays.asList(cards.getUnusedParams()));
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public List getColumnAuxDataInfos() {
        return Arrays.asList(AUX_DATA_INFOS);
    }

    protected Object readCell(BasicInput stream, int icol) throws IOException {
        return this.colReaders_[icol].readValue(stream);
    }

    protected Object[] readRow(BasicInput stream) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.colReaders_[icol].readValue(stream);
        }
        return row;
    }

    protected int getRowLength() {
        return this.rowLength_;
    }

    protected int[] getColumnOffsets() {
        return this.colOffsets_;
    }

    public static BintableStarTable createTable(Header hdr, InputFactory inputFact, WideFits wide) throws IOException, FitsException {
        return inputFact.isRandom() ? new RandomBintableStarTable(hdr, inputFact, wide) : new SequentialBintableStarTable(hdr, inputFact, wide);
    }

    public static void streamStarTable(Header hdr, BasicInput input, WideFits wide, TableSink sink) throws FitsException, IOException {
        InputFactory dummyFact = new InputFactory(){

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public BasicInput createInput(boolean isSeq) {
                throw new UnsupportedOperationException("Metadata only");
            }

            @Override
            public void close() {
            }
        };
        SequentialBintableStarTable meta = new SequentialBintableStarTable(hdr, dummyFact, wide);
        sink.acceptMetadata(meta);
        long nrow = meta.getRowCount();
        for (long i = 0L; i < nrow; ++i) {
            Object[] row = meta.readRow(input);
            sink.acceptRow(row);
        }
        sink.endRows();
        long datasize = nrow * (long)meta.rowLength_;
        int over = (int)(datasize % 2880L);
        if (over > 0) {
            input.skip(over);
        }
    }

    private static class RandomBintableStarTable
    extends BintableStarTable {
        private final InputFactory inputFact_;
        private final BasicInputThreadLocal randomInputThreadLocal_;
        private final int rowLength_;
        private final int[] colOffsets_;

        RandomBintableStarTable(Header hdr, InputFactory inputFact, WideFits wide) throws IOException, FitsException {
            super(hdr, true, wide);
            this.inputFact_ = inputFact;
            if (!inputFact.isRandom()) {
                throw new IllegalArgumentException("not random");
            }
            this.rowLength_ = this.getRowLength();
            this.colOffsets_ = this.getColumnOffsets();
            this.randomInputThreadLocal_ = new BasicInputThreadLocal(inputFact, false);
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * (long)this.rowLength_ + (long)this.colOffsets_[icol]);
            return this.readCell(randomInput, icol);
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * (long)this.rowLength_);
            return this.readRow(randomInput);
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            assert (input.isRandom());
            final long endPos = this.getRowCount() * (long)this.rowLength_;
            return new RowSequence(){
                long pos;
                {
                    this.pos = -RandomBintableStarTable.this.rowLength_;
                }

                @Override
                public boolean next() {
                    this.pos += (long)RandomBintableStarTable.this.rowLength_;
                    return this.pos < endPos;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos + (long)RandomBintableStarTable.this.colOffsets_[icol]);
                        return RandomBintableStarTable.this.readCell(input, icol);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos);
                        return RandomBintableStarTable.this.readRow(input);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.randomInputThreadLocal_.close();
            this.inputFact_.close();
        }
    }

    private static class SequentialBintableStarTable
    extends BintableStarTable {
        private final InputFactory inputFact_;

        public SequentialBintableStarTable(Header hdr, InputFactory inputFact, WideFits wide) throws FitsException {
            super(hdr, false, wide);
            this.inputFact_ = inputFact;
        }

        @Override
        public boolean isRandom() {
            return false;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            final Object[] beforeStart = new Object[]{};
            final long nrow = this.getRowCount();
            final int rowLength = this.getRowLength();
            return new RowSequence(){
                long lrow_ = -1L;
                Object[] row_ = beforeStart;
                long nskip_ = 0L;

                @Override
                public boolean next() throws IOException {
                    if (this.lrow_ < nrow - 1L) {
                        if (this.row_ == null) {
                            this.nskip_ += (long)rowLength;
                        }
                        this.row_ = null;
                        ++this.lrow_;
                        return true;
                    }
                    return false;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    return this.getRow()[icol];
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.row_ == beforeStart) {
                        throw new IllegalStateException();
                    }
                    if (this.row_ == null) {
                        if (this.nskip_ != 0L) {
                            input.skip(this.nskip_);
                            this.nskip_ = 0L;
                        }
                        this.row_ = SequentialBintableStarTable.this.readRow(input);
                    }
                    return this.row_;
                }

                @Override
                public void close() throws IOException {
                    if (this.nskip_ != 0L) {
                        input.skip(this.nskip_);
                        this.nskip_ = 0L;
                    }
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.inputFact_.close();
        }
    }
}

