/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.Unmapper;

public abstract class BlockMappedInput
implements BasicInput {
    private final FileChannel channel_;
    private final long pos_;
    private final long size_;
    private final String logName_;
    private final long blockSize_;
    private final int nblock_;
    private final Unmapper unmapper_;
    int iblock_;
    MappedByteBuffer buffer_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");
    public static final int DEFAULT_BLOCKSIZE = 0x10000000;
    public static final long DEFAULT_EXPIRYMILLIS = 20000L;

    protected BlockMappedInput(FileChannel channel, long pos, long size, String logName, int blockSize) throws IOException {
        this.channel_ = channel;
        this.pos_ = pos;
        this.size_ = size;
        this.logName_ = logName;
        this.blockSize_ = blockSize;
        long nb = (size - 1L) / this.blockSize_ + 1L;
        this.nblock_ = (int)nb;
        if ((long)this.nblock_ != nb) {
            throw new IllegalArgumentException("Block count " + nb + " too high");
        }
        logger_.info(this.logName_ + " mapping as " + this.nblock_ + " blocks of " + this.blockSize_ + " bytes");
        this.iblock_ = -1;
        this.buffer_ = channel.map(FileChannel.MapMode.READ_ONLY, pos, 0L);
        this.unmapper_ = Unmapper.getInstance();
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buffer_.get();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(1).get();
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buffer_.getShort();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(2).getShort();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer_.getInt();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(4).getInt();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer_.getLong();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(8).getLong();
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buffer_.getFloat();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(4).getFloat();
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buffer_.getDouble();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(8).getDouble();
        }
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public void seek(long offset) throws IOException {
        int ib = (int)(offset / this.blockSize_);
        int ioff = (int)(offset % this.blockSize_);
        if (ib != this.iblock_) {
            if (ioff > 0) {
                this.setCurrentBlock(ib);
            } else if (ioff == 0) {
                if (ib == this.iblock_ + 1) {
                    ib = this.iblock_;
                    ioff = this.buffer_.limit();
                } else if (ib == this.nblock_) {
                    this.setCurrentBlock(this.nblock_ - 1);
                    ib = this.iblock_;
                    ioff = this.buffer_.limit();
                } else {
                    this.setCurrentBlock(ib);
                }
            } else {
                throw new IllegalArgumentException(ioff + " < 0");
            }
        }
        assert (ib == this.iblock_);
        assert ((long)ib * this.blockSize_ + (long)ioff == offset || ib == -1 && this.buffer_.limit() == 0 && this.buffer_.position() == 0);
        try {
            this.buffer_.position(ioff);
        }
        catch (IllegalArgumentException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public long getOffset() {
        if (this.iblock_ >= 0) {
            return (long)this.iblock_ * this.blockSize_ + (long)this.buffer_.position();
        }
        assert (this.iblock_ == -1);
        assert (this.buffer_.limit() == 0 && this.buffer_.position() == 0);
        return 0L;
    }

    @Override
    public void skip(long nbyte) throws IOException {
        this.seek(this.getOffset() + nbyte);
    }

    public int getBlockCount() {
        return this.nblock_;
    }

    protected abstract MappedByteBuffer acquireBlock(int var1) throws IOException;

    MappedByteBuffer mapBlock(int iblock) throws IOException {
        long offset = (long)iblock * this.blockSize_;
        long leng = Math.min(this.blockSize_, this.size_ - offset);
        logger_.config("Mapping file region " + (iblock + 1) + "/" + this.nblock_);
        return this.channel_.map(FileChannel.MapMode.READ_ONLY, this.pos_ + offset, leng);
    }

    void unmapBlock(int iblock, MappedByteBuffer buf) {
        if (iblock >= 0) {
            boolean unmapped = this.unmapper_.unmap(buf);
            logger_.config("Expiring cached buffer " + (iblock + 1) + "/" + this.nblock_ + " of " + this.logName_ + (unmapped ? " (unmapped)" : " (not unmapped)"));
        }
    }

    private ByteBuffer getAssuredBuffer(int count) throws IOException {
        int nr;
        if (!this.buffer_.hasRemaining()) {
            this.setCurrentBlock(this.iblock_ + 1);
            if (this.buffer_.remaining() >= count) {
                return this.buffer_;
            }
        }
        byte[] array = new byte[count];
        for (int i = 0; i < count; i += nr) {
            if (!this.buffer_.hasRemaining()) {
                this.setCurrentBlock(this.iblock_ + 1);
            }
            nr = Math.min(count - i, this.buffer_.remaining());
            this.buffer_.get(array, i, nr);
        }
        return ByteBuffer.wrap(array);
    }

    private void setCurrentBlock(int iblock) throws IOException {
        MappedByteBuffer buf;
        if (iblock < this.nblock_) {
            buf = this.acquireBlock(iblock);
            assert (buf.position() == 0);
        } else {
            throw new EOFException();
        }
        this.buffer_ = buf;
        this.iblock_ = iblock;
    }

    public static BlockMappedInput createInput(FileChannel channel, long pos, long size, String logName, boolean caching) throws IOException {
        return BlockMappedInput.createInput(channel, pos, size, logName, 0x10000000, caching ? 20000L : 0L);
    }

    public static BlockMappedInput createInput(FileChannel channel, long pos, long size, String logName, int blockSize, long expiryMillis) throws IOException {
        return expiryMillis > 0L ? new CachingBlockMappedInput(channel, pos, size, logName, blockSize, expiryMillis) : new UniqueBlockMappedInput(channel, pos, size, logName, blockSize);
    }

    private static class CachingBlockMappedInput
    extends BlockMappedInput {
        private final int nblock_;
        private final long expiryMillis_;
        private final long tidyMillis_;
        private final MappedByteBuffer[] bufs_;
        private final long[] useEpochs_;
        private long lastTidy_;

        public CachingBlockMappedInput(FileChannel channel, long pos, long size, String logName, int blockSize, long expiryMillis) throws IOException {
            super(channel, pos, size, logName, blockSize);
            this.expiryMillis_ = expiryMillis;
            this.tidyMillis_ = expiryMillis / 4L;
            this.nblock_ = this.getBlockCount();
            this.bufs_ = new MappedByteBuffer[this.nblock_];
            this.useEpochs_ = new long[this.nblock_];
            this.lastTidy_ = System.currentTimeMillis();
        }

        @Override
        protected MappedByteBuffer acquireBlock(int iblock) throws IOException {
            MappedByteBuffer buf = this.bufs_[iblock];
            if (buf == null) {
                buf = this.mapBlock(iblock);
                long now = System.currentTimeMillis();
                if (now - this.lastTidy_ > this.tidyMillis_) {
                    this.tidyCache(now - this.expiryMillis_);
                    this.lastTidy_ = now;
                }
                this.bufs_[iblock] = buf;
                this.useEpochs_[iblock] = now;
            } else {
                buf.position(0);
            }
            return buf;
        }

        @Override
        public void close() {
            this.tidyCache(Long.MAX_VALUE);
        }

        private void tidyCache(long lastOkUse) {
            for (int i = 0; i < this.nblock_; ++i) {
                MappedByteBuffer buf = this.bufs_[i];
                long useEpoch = this.useEpochs_[i];
                if (buf == null || useEpoch >= lastOkUse) continue;
                this.bufs_[i] = null;
                this.unmapBlock(i, buf);
            }
        }
    }

    private static class UniqueBlockMappedInput
    extends BlockMappedInput {
        public UniqueBlockMappedInput(FileChannel channel, long pos, long size, String logName, int blockSize) throws IOException {
            super(channel, pos, size, logName, blockSize);
        }

        @Override
        protected MappedByteBuffer acquireBlock(int iblock) throws IOException {
            int oldIndex = this.iblock_;
            MappedByteBuffer oldBuffer = this.buffer_;
            if (oldBuffer != null) {
                this.unmapBlock(oldIndex, oldBuffer);
            }
            return this.mapBlock(iblock);
        }

        @Override
        public void close() {
            int oldIndex = this.iblock_;
            MappedByteBuffer oldBuffer = this.buffer_;
            if (oldBuffer != null) {
                this.iblock_ = -1;
                this.buffer_ = null;
                this.unmapBlock(oldIndex, oldBuffer);
            }
        }
    }
}

