/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;

public class ColFitsTableBuilder
implements TableBuilder {
    private final WideFits wide_;

    public ColFitsTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public ColFitsTableBuilder(WideFits wide) {
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "colfits-basic";
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream from colFITS format");
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (!FitsConstants.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        ArrayDataInput in = FitsConstants.getInputStreamStart(datsrc);
        long pos = 0L;
        Header hdr = new Header();
        try {
            pos += FitsConstants.skipHDUs(in, 1);
        }
        catch (FitsException e) {
            throw (TableFormatException)new TableFormatException("FITS read error").initCause(e);
        }
        catch (EOFException e) {
            throw (TableFormatException)new TableFormatException("No extensions").initCause(e);
        }
        finally {
            in.close();
        }
        return new ColFitsStarTable(datsrc, hdr, pos += (long)FitsConstants.readHeader(hdr, in), false, this.wide_);
    }
}

