/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.table.Tables;

abstract class ColumnReader {
    private final Class clazz_;
    private final int[] shape_;
    private final int length_;
    private final boolean isUnsignedByte_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    ColumnReader(Class clazz, int[] shape, int length, boolean isUnsignedByte) {
        this.clazz_ = clazz;
        this.shape_ = shape;
        this.length_ = length;
        this.isUnsignedByte_ = isUnsignedByte;
    }

    ColumnReader(Class clazz, int length, boolean isUnsignedByte) {
        this(clazz, null, length, isUnsignedByte);
    }

    abstract Object readValue(BasicInput var1) throws IOException;

    Class getContentClass() {
        return this.clazz_;
    }

    int[] getShape() {
        return this.shape_;
    }

    int getElementSize() {
        return -1;
    }

    int getLength() {
        return this.length_;
    }

    boolean isUnsignedByte() {
        return this.isUnsignedByte_;
    }

    public static ColumnReader createColumnReader(String tform, double scale, Number zeroNum, boolean hasBlank, long blank, int[] tdims, String ttype, final long heapStart) throws FitsException {
        int sleng;
        char vtype;
        int[] dims;
        Matcher fmatch = Pattern.compile("([0-9]*)([LXBIJKAEDCMPQ])(.*)").matcher(tform);
        if (!fmatch.lookingAt()) {
            throw new FitsException("Error parsing TFORM value " + tform);
        }
        String scount = fmatch.group(1);
        int count = scount.length() == 0 ? 1 : Integer.parseInt(scount);
        char type = fmatch.group(2).charAt(0);
        String matchA = fmatch.group(3).trim();
        if (type == 'P' || type == 'Q') {
            dims = tdims == null ? new int[]{-1} : tdims;
        } else if (count == 1) {
            dims = null;
        } else if (tdims == null) {
            dims = new int[]{count};
        } else {
            int[] nArray;
            int nel = 1;
            for (int i = 0; i < tdims.length; ++i) {
                nel *= tdims[i];
            }
            if (nel == count) {
                nArray = tdims;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = count;
            }
            dims = nArray;
        }
        if (type == 'P') {
            if (heapStart >= 0L) {
                vtype = matchA.charAt(0);
                final ArrayReader aReader = ColumnReader.createArrayReader(vtype, scale, zeroNum, hasBlank, blank, dims);
                return new ColumnReader(aReader.getContentClass(), aReader.getShape(), 8, aReader.isUnsignedByte()){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        int nel = stream.readInt();
                        int heapOffset = stream.readInt();
                        if (nel > 0) {
                            long point = stream.getOffset();
                            stream.seek(heapStart + (long)heapOffset);
                            Object array = aReader.readArray(stream, nel);
                            stream.seek(point);
                            return array;
                        }
                        return aReader.readArray(stream, 0);
                    }

                    @Override
                    int getElementSize() {
                        return aReader.getElementSize();
                    }
                };
            }
            logger_.warning("Column " + ttype + "(TFORM=" + tform + ") - " + "variable length arrays not supported " + "in sequential mode");
            String value = "?";
            return new ColumnReader(String.class, 8, false){

                @Override
                Object readValue(BasicInput stream) throws IOException {
                    int nel = stream.readInt();
                    int offset = stream.readInt();
                    return nel > 0 ? "?" : "";
                }

                @Override
                int getElementSize() {
                    return "?".length();
                }
            };
        }
        if (type == 'Q') {
            if (heapStart >= 0L) {
                vtype = matchA.charAt(0);
                final ArrayReader aReader = ColumnReader.createArrayReader(vtype, scale, zeroNum, hasBlank, blank, dims);
                return new ColumnReader(aReader.getContentClass(), aReader.getShape(), 16, aReader.isUnsignedByte()){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        long lnel = stream.readLong();
                        long heapOffset = stream.readLong();
                        int nel = Tables.checkedLongToInt(lnel);
                        if (nel > 0) {
                            long point = stream.getOffset();
                            stream.seek(heapStart + heapOffset);
                            Object array = aReader.readArray(stream, nel);
                            stream.seek(point);
                            return array;
                        }
                        return aReader.readArray(stream, 0);
                    }

                    @Override
                    int getElementSize() {
                        return aReader.getElementSize();
                    }
                };
            }
            logger_.warning("Column " + ttype + "(TFORM=" + tform + ") - " + "variable length arrays not supported " + "in sequential mode");
            String value = "?";
            return new ColumnReader(String.class, 16, false){

                @Override
                Object readValue(BasicInput stream) throws IOException {
                    long nel = stream.readLong();
                    long offset = stream.readLong();
                    return nel > 0L ? "?" : "";
                }

                @Override
                int getElementSize() {
                    return "?".length();
                }
            };
        }
        if (count == 1) {
            return ColumnReader.createScalarColumnReader(type, scale, zeroNum, hasBlank, blank);
        }
        if (type == 'A' && matchA.matches("[0-9]+") & dims.length == 1 && dims[0] % (sleng = Integer.parseInt(matchA)) == 0) {
            dims = new int[]{sleng, dims[0] / sleng};
        }
        final ArrayReader aReader = ColumnReader.createArrayReader(type, scale, zeroNum, hasBlank, blank, dims);
        boolean isComplex = type == 'C' || type == 'M';
        final int primCount = (isComplex ? 2 : 1) * count;
        return new ColumnReader(aReader.getContentClass(), aReader.getShape(), aReader.getByteCount(primCount), aReader.isUnsignedByte()){

            @Override
            Object readValue(BasicInput stream) throws IOException {
                return aReader.readArray(stream, primCount);
            }

            @Override
            int getElementSize() {
                return aReader.getElementSize();
            }
        };
    }

    private static ColumnReader createScalarColumnReader(char type, final double scale, Number zeroNum, final boolean hasBlank, final long blank) {
        final long lZero = zeroNum.longValue();
        final double dZero = zeroNum.doubleValue();
        boolean isScaled = scale != 1.0 || dZero != 0.0;
        boolean isOffset = scale == 1.0 && dZero != 0.0;
        boolean intOffset = isOffset && ColumnReader.isInteger(zeroNum);
        switch (type) {
            case 'L': {
                ColumnReader reader = new ColumnReader(Boolean.class, 1, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        switch (stream.readByte()) {
                            case 84: {
                                return Boolean.TRUE;
                            }
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return null;
                    }
                };
                return reader;
            }
            case 'X': {
                ColumnReader reader = new ColumnReader(Boolean.class, 1, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        byte b = stream.readByte();
                        return (b & 0x80) != 0;
                    }
                };
                return reader;
            }
            case 'B': {
                ColumnReader reader;
                boolean shortable;
                int mask = 255;
                boolean bl = shortable = intOffset && dZero >= -32768.0 && dZero < 32511.0;
                if (dZero == -128.0 && scale == 1.0) {
                    reader = new ColumnReader(Byte.class, 1, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            byte val = stream.readByte();
                            return hasBlank && val == (byte)blank ? null : new Byte((byte)(val ^ 0xFFFFFF80));
                        }
                    };
                } else if (shortable) {
                    final short sZero = (short)lZero;
                    reader = new ColumnReader(Short.class, 1, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            byte val = stream.readByte();
                            return hasBlank && val == (byte)blank ? null : new Short((short)((val & 0xFF) + sZero));
                        }
                    };
                } else {
                    reader = isScaled ? new ColumnReader(Float.class, 1, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            byte val = stream.readByte();
                            return hasBlank && val == (byte)blank ? null : new Float((double)(val & 0xFF) * scale + dZero);
                        }
                    } : new ColumnReader(Short.class, 1, true){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            byte val = stream.readByte();
                            return hasBlank && val == (byte)blank ? null : new Short((short)(val & 0xFF));
                        }
                    };
                }
                return reader;
            }
            case 'I': {
                ColumnReader reader;
                boolean intable;
                boolean bl = intable = intOffset && dZero > -2.14745088E9 && dZero < 2.14745088E9;
                if (intable) {
                    final int iZero = (int)lZero;
                    reader = new ColumnReader(Integer.class, 2, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            short val = stream.readShort();
                            return hasBlank && val == (short)blank ? null : new Integer(val + iZero);
                        }
                    };
                } else {
                    reader = isScaled ? new ColumnReader(Float.class, 2, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            short val = stream.readShort();
                            return hasBlank && val == (short)blank ? null : new Float((float)((double)val * scale + dZero));
                        }
                    } : new ColumnReader(Short.class, 2, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            short val = stream.readShort();
                            return hasBlank && val == (short)blank ? null : new Short(val);
                        }
                    };
                }
                return reader;
            }
            case 'J': {
                boolean longable;
                boolean bl = longable = intOffset && dZero > -9.223372034707292E18 && dZero < 9.223372034707292E18;
                ColumnReader reader = longable ? new ColumnReader(Long.class, 4, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        long val = stream.readInt();
                        return hasBlank && val == (long)((int)blank) ? null : new Long(val + lZero);
                    }
                } : (isScaled ? new ColumnReader(Double.class, 4, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Double((double)val * scale + dZero);
                    }
                } : new ColumnReader(Integer.class, 4, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Integer(val);
                    }
                });
                return reader;
            }
            case 'K': {
                ColumnReader reader;
                if (zeroNum.equals(BintableStarTable.TWO63) && scale == 1.0) {
                    long lMin = Long.MIN_VALUE;
                    long lMax = -1L;
                    final LongRanger ranger = new LongRanger(lMin, lMax, zeroNum, "null");
                    reader = new ColumnReader(Long.class, 8, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            long val = stream.readLong();
                            if (hasBlank && val == blank) {
                                return null;
                            }
                            return ranger.inRange(val) ? new Long(val + Long.MAX_VALUE + 1L) : null;
                        }
                    };
                } else if (intOffset) {
                    long lMin = lZero < 0L ? Long.MIN_VALUE - lZero : Long.MIN_VALUE;
                    long lMax = lZero > 0L ? Long.MAX_VALUE - lZero : Long.MAX_VALUE;
                    final LongRanger ranger = new LongRanger(lMin, lMax, zeroNum, "null");
                    reader = new ColumnReader(Long.class, 8, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            long val = stream.readLong();
                            if (hasBlank && val == blank) {
                                return null;
                            }
                            return ranger.inRange(val) ? new Long(val + lZero) : null;
                        }
                    };
                } else {
                    reader = isScaled ? new ColumnReader(Double.class, 8, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            long val = stream.readLong();
                            return hasBlank && val == blank ? null : new Double((double)val * scale + dZero);
                        }
                    } : new ColumnReader(Long.class, 8, false){

                        @Override
                        Object readValue(BasicInput stream) throws IOException {
                            long val = stream.readLong();
                            return hasBlank && val == blank ? null : new Long(val);
                        }
                    };
                }
                return reader;
            }
            case 'A': {
                ColumnReader reader = new ColumnReader(Character.class, 1, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        char c = (char)(stream.readByte() & 0xFF);
                        return new Character(c);
                    }
                };
                return reader;
            }
            case 'E': {
                ColumnReader reader = isScaled ? new ColumnReader(Float.class, 4, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float((double)val * scale + dZero);
                    }
                } : new ColumnReader(Float.class, 4, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float(val);
                    }
                };
                return reader;
            }
            case 'D': {
                ColumnReader reader = isScaled ? new ColumnReader(Double.class, 8, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val * scale + dZero);
                    }
                } : new ColumnReader(Double.class, 8, false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val);
                    }
                };
                return reader;
            }
            case 'C': 
            case 'M': {
                int[] complexDims = new int[]{2};
                final ArrayReader complexReader = type == 'C' ? ColumnReader.createFloatsArrayReader(complexDims, scale, dZero) : ColumnReader.createDoublesArrayReader(complexDims, scale, dZero);
                return new ColumnReader(complexReader.getContentClass(), complexDims, complexReader.getByteCount(2), false){

                    @Override
                    Object readValue(BasicInput stream) throws IOException {
                        return complexReader.readArray(stream, 2);
                    }

                    @Override
                    int getElementSize() {
                        return complexReader.getElementSize();
                    }
                };
            }
        }
        throw new AssertionError((Object)("Unknown TFORM type " + type));
    }

    private static ArrayReader createArrayReader(char type, final double scale, Number zeroNum, final boolean hasBlank, final long blank, final int[] dims) {
        final long lZero = zeroNum.longValue();
        final double dZero = zeroNum.doubleValue();
        boolean isScaled = scale != 1.0 || dZero != 0.0;
        boolean isOffset = scale == 1.0 && dZero != 0.0;
        boolean intOffset = isOffset && ColumnReader.isInteger(zeroNum);
        switch (type) {
            case 'L': {
                ArrayReader reader = new ArrayReader(boolean[].class, dims, 1, false){

                    @Override
                    Object readArray(BasicInput stream, int count) throws IOException {
                        boolean[] value = new boolean[count];
                        for (int i = 0; i < count; ++i) {
                            value[i] = stream.readByte() == 84;
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'X': {
                ArrayReader reader = new ArrayReader(boolean[].class, dims, -1, false){

                    @Override
                    Object readArray(BasicInput stream, int count) throws IOException {
                        boolean[] value = new boolean[count];
                        int ibit = 0;
                        int b = 0;
                        for (int i = 0; i < count; ++i) {
                            if (ibit == 0) {
                                ibit = 8;
                                b = stream.readByte();
                            }
                            value[i] = (b & 0x80) != 0;
                            b <<= 1;
                            --ibit;
                        }
                        return value;
                    }

                    @Override
                    int getByteCount(int nel) {
                        return (nel + 7) / 8;
                    }
                };
                return reader;
            }
            case 'B': {
                ArrayReader reader;
                boolean shortable;
                int mask = 255;
                boolean bl = shortable = intOffset && dZero >= -32768.0 && dZero < 32511.0;
                if (dZero == -128.0 && scale == 1.0) {
                    reader = new ArrayReader(byte[].class, dims, 1, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            byte[] value = new byte[count];
                            for (int i = 0; i < count; ++i) {
                                byte val = stream.readByte();
                                value[i] = (byte)(val ^ 0xFFFFFF80);
                            }
                            return value;
                        }
                    };
                } else if (shortable) {
                    final short sZero = (short)lZero;
                    reader = new ArrayReader(short[].class, dims, 1, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            short[] value = new short[count];
                            for (int i = 0; i < count; ++i) {
                                byte val = stream.readByte();
                                value[i] = (short)((val & 0xFF) + sZero);
                            }
                            return value;
                        }
                    };
                } else {
                    reader = isScaled ? new ArrayReader(float[].class, dims, 1, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            float[] value = new float[count];
                            for (int i = 0; i < count; ++i) {
                                byte val = stream.readByte();
                                value[i] = hasBlank && val == (byte)blank ? Float.NaN : (float)((double)(val & 0xFF) * scale + dZero);
                            }
                            return value;
                        }
                    } : new ArrayReader(short[].class, dims, 1, true){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            short[] value = new short[count];
                            for (int i = 0; i < count; ++i) {
                                byte val = stream.readByte();
                                value[i] = (short)(val & 0xFF);
                            }
                            return value;
                        }
                    };
                }
                return reader;
            }
            case 'I': {
                ArrayReader reader;
                boolean intable;
                boolean bl = intable = intOffset && dZero > -2.14745088E9 && dZero < 2.14745088E9;
                if (intable) {
                    final int iZero = (int)lZero;
                    reader = new ArrayReader(int[].class, dims, 2, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            int[] value = new int[count];
                            for (int i = 0; i < count; ++i) {
                                short val = stream.readShort();
                                value[i] = val + iZero;
                            }
                            return value;
                        }
                    };
                } else {
                    reader = isScaled ? new ArrayReader(float[].class, dims, 2, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            float[] value = new float[count];
                            for (int i = 0; i < count; ++i) {
                                short val = stream.readShort();
                                value[i] = hasBlank && val == (short)blank ? Float.NaN : (float)((double)val * scale + dZero);
                            }
                            return value;
                        }
                    } : new ArrayReader(short[].class, dims, 2, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            short[] value = new short[count];
                            for (int i = 0; i < count; ++i) {
                                short val;
                                value[i] = val = stream.readShort();
                            }
                            return value;
                        }
                    };
                }
                return reader;
            }
            case 'J': {
                boolean longable;
                boolean bl = longable = intOffset && dZero > -9.223372034707292E18 && dZero < 9.223372034707292E18;
                ArrayReader reader = longable ? new ArrayReader(long[].class, dims, 4, false){

                    @Override
                    Object readArray(BasicInput stream, int count) throws IOException {
                        long[] value = new long[count];
                        for (int i = 0; i < count; ++i) {
                            int val = stream.readInt();
                            value[i] = (long)val + lZero;
                        }
                        return value;
                    }
                } : (isScaled ? new ArrayReader(double[].class, dims, 4, false){

                    @Override
                    Object readArray(BasicInput stream, int count) throws IOException {
                        double[] value = new double[count];
                        for (int i = 0; i < count; ++i) {
                            int val = stream.readInt();
                            value[i] = hasBlank && val == (int)blank ? Double.NaN : (double)val * scale + dZero;
                        }
                        return value;
                    }
                } : new ArrayReader(int[].class, dims, 4, false){

                    @Override
                    Object readArray(BasicInput stream, int count) throws IOException {
                        int[] value = new int[count];
                        for (int i = 0; i < count; ++i) {
                            int val;
                            value[i] = val = stream.readInt();
                        }
                        return value;
                    }
                });
                return reader;
            }
            case 'K': {
                ArrayReader reader;
                if (zeroNum.equals(BintableStarTable.TWO63) && scale == 1.0) {
                    long lMin = Long.MIN_VALUE;
                    long lMax = -1L;
                    final LongRanger ranger = new LongRanger(lMin, lMax, zeroNum, Long.toString(Long.MIN_VALUE));
                    reader = new ArrayReader(long[].class, dims, 8, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            long[] value = new long[count];
                            for (int i = 0; i < count; ++i) {
                                long val = stream.readLong();
                                value[i] = ranger.inRange(val) ? val + Long.MAX_VALUE + 1L : Long.MIN_VALUE;
                            }
                            return value;
                        }
                    };
                } else if (intOffset) {
                    long lMax = lZero > 0L ? Long.MAX_VALUE - lZero : Long.MAX_VALUE;
                    long lMin = lZero < 0L ? Long.MIN_VALUE - lZero : Long.MIN_VALUE;
                    final LongRanger ranger = new LongRanger(lMin, lMax, zeroNum, Long.toString(Long.MIN_VALUE));
                    reader = new ArrayReader(long[].class, dims, 8, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            long[] value = new long[count];
                            for (int i = 0; i < count; ++i) {
                                long val = stream.readLong();
                                value[i] = ranger.inRange(val) ? val + lZero : Long.MIN_VALUE;
                            }
                            return value;
                        }
                    };
                } else {
                    reader = isScaled ? new ArrayReader(double[].class, dims, 8, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            double[] value = new double[count];
                            for (int i = 0; i < count; ++i) {
                                long val = stream.readLong();
                                value[i] = hasBlank && val == blank ? Double.NaN : (double)val * scale + dZero;
                            }
                            return value;
                        }
                    } : new ArrayReader(long[].class, dims, 8, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            long[] value = new long[count];
                            for (int i = 0; i < count; ++i) {
                                long val;
                                value[i] = val = stream.readLong();
                            }
                            return value;
                        }
                    };
                }
                return reader;
            }
            case 'A': {
                ArrayReader reader;
                if (dims.length == 1) {
                    reader = new ArrayReader(String.class, null, 1, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            return ColumnReader.readString(stream, count);
                        }

                        @Override
                        int getElementSize() {
                            return dims[0];
                        }
                    };
                } else {
                    int nel = 1;
                    for (int i = 1; i < dims.length; ++i) {
                        nel *= dims[i];
                    }
                    final int stringLength = dims[0];
                    int nString = nel;
                    int[] shape = new int[dims.length - 1];
                    System.arraycopy(dims, 1, shape, 0, dims.length - 1);
                    reader = new ArrayReader(String[].class, shape, 1, false){

                        @Override
                        Object readArray(BasicInput stream, int count) throws IOException {
                            int nString = (count + stringLength - 1) / stringLength;
                            String[] value = new String[nString];
                            for (int i = 0; i < nString; ++i) {
                                int nchar = Math.min(count, stringLength);
                                value[i] = ColumnReader.readString(stream, nchar);
                                count -= nchar;
                            }
                            assert (count == 0);
                            return value;
                        }

                        @Override
                        int getElementSize() {
                            return stringLength;
                        }
                    };
                }
                return reader;
            }
            case 'E': {
                return ColumnReader.createFloatsArrayReader(dims, scale, dZero);
            }
            case 'D': {
                return ColumnReader.createDoublesArrayReader(dims, scale, dZero);
            }
            case 'C': {
                return ColumnReader.createFloatsArrayReader(ColumnReader.complexShape(dims), scale, dZero);
            }
            case 'M': {
                return ColumnReader.createDoublesArrayReader(ColumnReader.complexShape(dims), scale, dZero);
            }
        }
        throw new AssertionError((Object)("Unknown TFORM type " + type));
    }

    private static ArrayReader createFloatsArrayReader(int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ArrayReader(float[].class, shape, 4, false){

                @Override
                Object readArray(BasicInput stream, int count) throws IOException {
                    float[] value = new float[count];
                    for (int i = 0; i < count; ++i) {
                        float val = stream.readFloat();
                        value[i] = (float)((double)val * scale + zero);
                    }
                    return value;
                }
            };
        }
        return new ArrayReader(float[].class, shape, 4, false){

            @Override
            Object readArray(BasicInput stream, int count) throws IOException {
                float[] value = new float[count];
                for (int i = 0; i < count; ++i) {
                    value[i] = stream.readFloat();
                }
                return value;
            }
        };
    }

    private static ArrayReader createDoublesArrayReader(int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ArrayReader(double[].class, shape, 8, false){

                @Override
                Object readArray(BasicInput stream, int count) throws IOException {
                    double[] value = new double[count];
                    for (int i = 0; i < count; ++i) {
                        double val = stream.readDouble();
                        value[i] = val * scale + zero;
                    }
                    return value;
                }
            };
        }
        return new ArrayReader(double[].class, shape, 8, false){

            @Override
            Object readArray(BasicInput stream, int count) throws IOException {
                double[] value = new double[count];
                for (int i = 0; i < count; ++i) {
                    value[i] = stream.readDouble();
                }
                return value;
            }
        };
    }

    private static String readString(BasicInput stream, int count) throws IOException {
        char[] letters = new char[count];
        int last = -1;
        boolean end = false;
        for (int i = 0; i < count; ++i) {
            char letter = (char)(stream.readByte() & 0xFF);
            if (letter == '\u0000') {
                end = true;
            }
            if (end) continue;
            letters[i] = letter;
            if (letter == ' ') continue;
            last = i;
        }
        int leng = last + 1;
        return leng == 0 ? null : new String(letters, 0, leng);
    }

    private static int[] complexShape(int[] dims) {
        if (dims == null) {
            return new int[]{2};
        }
        int[] shape = new int[dims.length + 1];
        shape[0] = 2;
        System.arraycopy(dims, 0, shape, 1, dims.length);
        return shape;
    }

    private static boolean isInteger(Number num) {
        if (num instanceof Byte || num instanceof Short || num instanceof Integer || num instanceof Long) {
            return true;
        }
        if (num instanceof BigInteger) {
            BigInteger bnum = (BigInteger)num;
            return bnum.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && bnum.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0;
        }
        assert (num instanceof Float || num instanceof Double || num instanceof BigDecimal);
        return false;
    }

    private static abstract class ArrayReader {
        private final Class clazz_;
        private final int[] shape_;
        private final int elBytes_;
        private final boolean isUnsignedByte_;

        ArrayReader(Class clazz, int[] shape, int elBytes, boolean isUnsignedByte) {
            this.clazz_ = clazz;
            this.shape_ = shape;
            this.elBytes_ = elBytes;
            this.isUnsignedByte_ = isUnsignedByte;
        }

        abstract Object readArray(BasicInput var1, int var2) throws IOException;

        Class getContentClass() {
            return this.clazz_;
        }

        int[] getShape() {
            return this.shape_;
        }

        int getElementSize() {
            return -1;
        }

        int getByteCount(int count) {
            return this.elBytes_ * count;
        }

        boolean isUnsignedByte() {
            return this.isUnsignedByte_;
        }
    }

    private static class LongRanger {
        private final long lMin_;
        private final long lMax_;
        private final Number zeroNum_;
        private final String failReturn_;
        private boolean hasWarned_;

        LongRanger(long lMin, long lMax, Number zeroNum, String failReturn) {
            this.lMin_ = lMin;
            this.lMax_ = lMax;
            this.zeroNum_ = zeroNum;
            this.failReturn_ = failReturn;
        }

        boolean inRange(long lval) {
            if (lval >= this.lMin_ && lval <= this.lMax_) {
                return true;
            }
            if (!this.hasWarned_) {
                String msg = "Cannot represent large offset long values - will return " + this.failReturn_ + " (offset=" + this.zeroNum_ + ";" + " first value=" + lval + ")";
                logger_.warning(msg);
                this.hasWarned_ = true;
            }
            return false;
        }
    }
}

