/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import uk.ac.starlink.fits.ArrayStorage;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.ColumnStore;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.IntegerStorage;
import uk.ac.starlink.table.ValueInfo;

abstract class FileColumnStore
implements ColumnStore {
    private final ValueInfo info_;
    private final File file_;
    private final DataOutput out_;
    private final char formatChar_;
    private final int typeBytes_;
    private final boolean dumpCopy_;
    private long nrow_;
    private int[] itemShape_;
    private byte[] copyBuf_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected FileColumnStore(ValueInfo info, char formatChar, int typeBytes, boolean dumpCopy) throws IOException {
        this.info_ = info;
        this.formatChar_ = formatChar;
        this.typeBytes_ = typeBytes;
        this.dumpCopy_ = dumpCopy;
        this.setItemShape(new int[]{1});
        this.file_ = File.createTempFile("col-" + info.getName().replaceAll("\\W+", ""), ".bin");
        this.file_.deleteOnExit();
        this.out_ = new BufferedDataOutputStream(new FileOutputStream(this.file_));
    }

    protected FileColumnStore(ValueInfo info, char formatChar, int typeBytes) throws IOException {
        this(info, formatChar, typeBytes, false);
    }

    @Override
    public void storeValue(Object value) throws IOException {
        this.storeValue(value, this.out_);
        ++this.nrow_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamData(DataOutput out) throws IOException {
        if (this.dumpCopy_) {
            FileInputStream in = new FileInputStream(this.file_);
            int bufsiz = 65536;
            byte[] buf = new byte[bufsiz];
            long start = System.currentTimeMillis();
            try {
                int count;
                for (long nbyte = this.getDataLength(); nbyte > 0L; nbyte -= (long)count) {
                    count = in.read(buf, 0, (int)Math.min(nbyte, (long)bufsiz));
                    if (count < 0) {
                        throw new EOFException();
                    }
                    out.write(buf, 0, count);
                }
            }
            finally {
                in.close();
            }
            logger_.config("Dump data rate: " + 0.001f * (float)this.getDataLength() / (float)(System.currentTimeMillis() - start) + " Mbyte/sec");
        } else {
            BufferedDataInputStream in = new BufferedDataInputStream(new FileInputStream(this.file_));
            try {
                for (long irow = 0L; irow < this.nrow_; ++irow) {
                    this.copyValue(in, out);
                }
            }
            finally {
                if (in instanceof InputStream) {
                    ((InputStream)in).close();
                }
            }
        }
    }

    @Override
    public void endStores() throws IOException {
        if (this.out_ instanceof OutputStream) {
            ((OutputStream)((Object)this.out_)).close();
        }
    }

    @Override
    public long getDataLength() {
        return (long)(FileColumnStore.multiply(this.itemShape_) * this.typeBytes_) * this.nrow_;
    }

    @Override
    public void addHeaderInfo(Header hdr, BintableColumnHeader colhead, int jcol) throws HeaderCardException {
        String utype;
        String ucd;
        String comm;
        String forcol = " for column " + jcol;
        String name = this.info_.getName();
        if (name != null && name.trim().length() > 0) {
            FitsConstants.addTrimmedValue(hdr, colhead.getKeyName("TTYPE"), name, "label" + forcol);
        }
        long nItem = (long)FileColumnStore.multiply(this.itemShape_) * this.nrow_;
        hdr.addValue(colhead.getKeyName("TFORM"), nItem + "" + this.formatChar_, "format" + forcol);
        StringBuffer dimbuf = new StringBuffer("(");
        for (int i = 0; i < this.itemShape_.length; ++i) {
            dimbuf.append(this.itemShape_[i]).append(',');
        }
        dimbuf.append(this.nrow_).append(')');
        hdr.addValue(colhead.getKeyName("TDIM"), dimbuf.toString(), "dimensions" + forcol);
        String unit = this.info_.getUnitString();
        if (unit != null && unit.trim().length() > 0) {
            FitsConstants.addTrimmedValue(hdr, colhead.getKeyName("TUNIT"), unit, "units" + forcol);
        }
        if ((comm = this.info_.getDescription()) != null && comm.trim().length() > 0) {
            try {
                hdr.addValue(colhead.getKeyName("TCOMM"), comm, null);
            }
            catch (HeaderCardException e) {
                // empty catch block
            }
        }
        if ((ucd = this.info_.getUCD()) != null && ucd.trim().length() > 0 && ucd.length() < 68) {
            try {
                hdr.addValue(colhead.getKeyName("TUCD"), ucd, null);
            }
            catch (HeaderCardException e) {
                // empty catch block
            }
        }
        if ((utype = this.info_.getUtype()) != null && utype.trim().length() > 0 && utype.length() < 68) {
            try {
                hdr.addValue(colhead.getKeyName("TUTYP"), utype, null);
            }
            catch (HeaderCardException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void dispose() throws IOException {
        if (this.file_.exists()) {
            this.file_.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    protected abstract void storeValue(Object var1, DataOutput var2) throws IOException;

    protected void copyValue(DataInput in, DataOutput out) throws IOException {
        in.readFully(this.copyBuf_);
        out.write(this.copyBuf_);
    }

    protected void setItemShape(int[] shape) {
        this.itemShape_ = shape;
        this.copyBuf_ = new byte[FileColumnStore.multiply(this.itemShape_) * this.typeBytes_];
    }

    ValueInfo getValueInfo() {
        return this.info_;
    }

    private static int multiply(int[] dims) {
        int product = 1;
        for (int i = 0; i < dims.length; ++i) {
            product *= dims[i];
        }
        return product;
    }

    public static ColumnStore createColumnStore(ValueInfo info) throws IOException {
        Class clazz = info.getContentClass();
        if (clazz == Boolean.class) {
            return new FileColumnStore(info, 'L', 1, true){

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    int b = Boolean.TRUE.equals(value) ? 84 : (Boolean.FALSE.equals(value) ? 70 : 0);
                    out.writeByte(b);
                }
            };
        }
        if (clazz == Byte.class) {
            return new IntegerColumnStore(info, IntegerStorage.createByteStorage()){

                @Override
                public void addHeaderInfo(Header hdr, BintableColumnHeader colhead, int jcol) throws HeaderCardException {
                    super.addHeaderInfo(hdr, colhead, jcol);
                    hdr.addValue(colhead.getKeyName("TZERO"), -128.0, "unsigned offset");
                }
            };
        }
        if (clazz == Short.class) {
            return new IntegerColumnStore(info, IntegerStorage.createShortStorage());
        }
        if (clazz == Integer.class) {
            return new IntegerColumnStore(info, IntegerStorage.createIntStorage());
        }
        if (clazz == Long.class) {
            return new IntegerColumnStore(info, IntegerStorage.createLongStorage());
        }
        if (clazz == Float.class) {
            return new FileColumnStore(info, 'E', 4, true){

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    out.writeFloat(value instanceof Number ? ((Number)value).floatValue() : Float.NaN);
                }
            };
        }
        if (clazz == Double.class) {
            return new FileColumnStore(info, 'D', 8, true){

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    out.writeDouble(value instanceof Number ? ((Number)value).doubleValue() : Double.NaN);
                }
            };
        }
        if (clazz == Character.class) {
            return new FileColumnStore(info, 'A', 1, true){

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    out.writeByte(value instanceof Character ? (int)((Character)value).charValue() : 32);
                }
            };
        }
        if (clazz == String.class) {
            return new FileColumnStore(info, 'A', 1){
                int maxleng_ = 1;
                byte[] copyBuffer_;

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    String sval = (String)value;
                    int leng = sval == null ? 0 : sval.length();
                    this.maxleng_ = Math.max(this.maxleng_, leng);
                    out.writeInt(leng);
                    for (int i = 0; i < leng; ++i) {
                        out.writeByte((byte)sval.charAt(i));
                    }
                }

                @Override
                public void endStores() throws IOException {
                    super.endStores();
                    this.setItemShape(new int[]{this.maxleng_});
                    this.copyBuffer_ = new byte[this.maxleng_];
                }

                @Override
                protected void copyValue(DataInput in, DataOutput out) throws IOException {
                    int leng = in.readInt();
                    if (leng < 0 || leng > this.maxleng_) {
                        throw new IOException("Corrupted temporary file");
                    }
                    in.readFully(this.copyBuffer_, 0, leng);
                    Arrays.fill(this.copyBuffer_, leng, this.maxleng_, (byte)0);
                    out.write(this.copyBuffer_);
                }
            };
        }
        if (clazz == byte[].class) {
            int[] dims = info.getShape();
            ArrayStorage handler = ArrayStorage.BYTE;
            return dims != null && dims.length > 0 && dims[dims.length - 1] > 0 ? new FixedArrayColumnStore(info, handler){

                @Override
                public void addHeaderInfo(Header hdr, BintableColumnHeader colhead, int jcol) throws HeaderCardException {
                    super.addHeaderInfo(hdr, colhead, jcol);
                    hdr.addValue(colhead.getKeyName("TZERO"), -128.0, "unsigned offset");
                }
            } : new VariableArrayColumnStore(info, handler){

                @Override
                public void addHeaderInfo(Header hdr, BintableColumnHeader colhead, int jcol) throws HeaderCardException {
                    super.addHeaderInfo(hdr, colhead, jcol);
                    hdr.addValue(colhead.getKeyName("TZERO"), -128.0, "unsigned offset");
                }
            };
        }
        if (clazz == boolean[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.BOOLEAN);
        }
        if (clazz == short[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.SHORT);
        }
        if (clazz == int[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.INT);
        }
        if (clazz == long[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.LONG);
        }
        if (clazz == float[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.FLOAT);
        }
        if (clazz == double[].class) {
            return FileColumnStore.createArrayColumnStore(info, ArrayStorage.DOUBLE);
        }
        if (clazz == String[].class) {
            return new FileColumnStore(info, 'A', 1){
                int maxChars_ = 1;
                int maxStrings_;
                byte[] blankString_;

                @Override
                protected void storeValue(Object value, DataOutput out) throws IOException {
                    if (value instanceof String[]) {
                        String[] strings = (String[])value;
                        int nstring = strings.length;
                        out.writeInt(nstring);
                        this.maxStrings_ = Math.max(this.maxStrings_, nstring);
                        for (int is = 0; is < nstring; ++is) {
                            String sval = strings[is];
                            int nchar = sval == null ? 0 : sval.length();
                            out.writeInt(nchar);
                            this.maxChars_ = Math.max(this.maxChars_, nchar);
                            for (int ic = 0; ic < nchar; ++ic) {
                                out.writeByte((byte)sval.charAt(ic));
                            }
                        }
                    }
                }

                @Override
                public void endStores() throws IOException {
                    super.endStores();
                    this.setItemShape(new int[]{this.maxChars_, this.maxStrings_});
                    this.blankString_ = new byte[this.maxChars_];
                    Arrays.fill(this.blankString_, (byte)0);
                }

                @Override
                protected void copyValue(DataInput in, DataOutput out) throws IOException {
                    int is;
                    int nstring = in.readInt();
                    if (nstring < 0 || nstring > this.maxStrings_) {
                        throw new IOException("Corrupted temp file for " + this.getValueInfo());
                    }
                    for (is = 0; is < nstring; ++is) {
                        int ic;
                        int nchar = in.readInt();
                        if (nchar < 0 || nchar > this.maxChars_) {
                            throw new IOException("Corrupted temp file for " + this.getValueInfo());
                        }
                        for (ic = 0; ic < nchar; ++ic) {
                            out.writeByte(in.readByte());
                        }
                        for (ic = nchar; ic < this.maxChars_; ++ic) {
                            out.writeByte(0);
                        }
                    }
                    for (is = nstring; is < this.maxStrings_; ++is) {
                        out.write(this.blankString_);
                    }
                }
            };
        }
        return null;
    }

    private static FileColumnStore createArrayColumnStore(ValueInfo info, ArrayStorage handler) throws IOException {
        int[] dims = info.getShape();
        return dims != null && dims.length > 0 && dims[dims.length - 1] > 0 ? new FixedArrayColumnStore(info, handler) : new VariableArrayColumnStore(info, handler);
    }

    private static class IntegerColumnStore
    extends FileColumnStore {
        private final IntegerStorage handler_;
        private final byte[] copyBuffer_;
        private boolean hasNulls_;
        private byte[] badBuffer_;
        private final byte GOOD = 1;
        private final byte BAD = (byte)2;

        IntegerColumnStore(ValueInfo info, IntegerStorage handler) throws IOException {
            super(info, handler.getFormatChar(), handler.getTypeBytes());
            this.handler_ = handler;
            this.copyBuffer_ = new byte[handler.getTypeBytes()];
        }

        @Override
        protected void storeValue(Object value, DataOutput out) throws IOException {
            if (value instanceof Number) {
                out.write(1);
                long val = ((Number)value).longValue();
                this.handler_.writeValue(val, out);
            } else {
                this.hasNulls_ = true;
                out.write(2);
            }
        }

        @Override
        public void endStores() throws IOException {
            super.endStores();
            if (this.hasNulls_) {
                this.badBuffer_ = this.handler_.getBadBytes();
                if (this.badBuffer_ == null) {
                    this.badBuffer_ = new byte[this.handler_.getTypeBytes()];
                    this.badBuffer_[0] = -128;
                    logger_.warning("Can't find unused null value for column " + this.getValueInfo() + " - using 0x80...");
                }
            }
        }

        @Override
        protected void copyValue(DataInput in, DataOutput out) throws IOException {
            byte[] buf;
            switch (in.readByte()) {
                case 1: {
                    in.readFully(this.copyBuffer_);
                    buf = this.copyBuffer_;
                    break;
                }
                case 2: {
                    buf = this.badBuffer_;
                    break;
                }
                default: {
                    throw new IOException("Corrupted data");
                }
            }
            out.write(buf);
        }

        @Override
        public void addHeaderInfo(Header hdr, BintableColumnHeader colhead, int jcol) throws HeaderCardException {
            Number bad;
            super.addHeaderInfo(hdr, colhead, jcol);
            if (this.hasNulls_ && (bad = this.handler_.getBadNumber()) != null) {
                hdr.addValue(colhead.getKeyName("TNULL"), bad.longValue(), "blank value");
            }
        }
    }

    private static class VariableArrayColumnStore
    extends FileColumnStore {
        private final ArrayStorage handler_;
        private final Object buffer_;
        private final byte[] byteBuffer_;
        private final byte[] blankBuffer_;
        private final int blockSize_;
        private final int[] blockShape_;
        private int maxBlocks_;

        VariableArrayColumnStore(ValueInfo info, ArrayStorage handler) throws IOException {
            super(info, handler.getFormatChar(), handler.getTypeBytes());
            this.handler_ = handler;
            int[] dims = info.getShape();
            if (dims != null && dims.length > 1) {
                this.blockShape_ = new int[dims.length - 1];
                System.arraycopy(dims, 0, this.blockShape_, 0, dims.length - 1);
                this.blockSize_ = FileColumnStore.multiply(this.blockShape_);
            } else {
                this.blockShape_ = new int[0];
                this.blockSize_ = 1;
            }
            this.buffer_ = Array.newInstance(handler.getComponentClass(), this.blockSize_);
            this.byteBuffer_ = new byte[this.blockSize_ * handler.getTypeBytes()];
            this.blankBuffer_ = (byte[])this.byteBuffer_.clone();
        }

        @Override
        protected void storeValue(Object value, DataOutput out) throws IOException {
            int nblock = value != null && value.getClass() == this.buffer_.getClass() ? Array.getLength(value) / this.blockSize_ : 0;
            out.writeInt(nblock);
            this.maxBlocks_ = Math.max(this.maxBlocks_, nblock);
            for (int i = 0; i < nblock; ++i) {
                System.arraycopy(value, i * this.blockSize_, this.buffer_, 0, this.blockSize_);
                this.handler_.writeArray(this.buffer_, out);
            }
        }

        @Override
        public void endStores() throws IOException {
            super.endStores();
            int[] dims = new int[this.blockShape_.length + 1];
            System.arraycopy(this.blockShape_, 0, dims, 0, this.blockShape_.length);
            dims[this.blockShape_.length] = this.maxBlocks_;
            this.setItemShape(dims);
        }

        @Override
        protected void copyValue(DataInput in, DataOutput out) throws IOException {
            int i;
            int nblock = in.readInt();
            if (nblock < 0 || nblock > this.maxBlocks_) {
                throw new IOException("Corrupted column store file for " + this.getValueInfo());
            }
            for (i = 0; i < nblock; ++i) {
                in.readFully(this.byteBuffer_);
                out.write(this.byteBuffer_);
            }
            for (i = nblock; i < this.maxBlocks_; ++i) {
                out.write(this.blankBuffer_);
            }
        }
    }

    private static class FixedArrayColumnStore
    extends FileColumnStore {
        private final ArrayStorage handler_;
        private final Object buffer_;
        private final int size_;

        FixedArrayColumnStore(ValueInfo info, ArrayStorage handler) throws IOException {
            super(info, handler.getFormatChar(), handler.getTypeBytes(), true);
            this.handler_ = handler;
            this.size_ = FileColumnStore.multiply(info.getShape());
            this.buffer_ = Array.newInstance(handler.getComponentClass(), this.size_);
            this.setItemShape(info.getShape());
        }

        @Override
        protected void storeValue(Object value, DataOutput out) throws IOException {
            if (value == null || value.getClass() != this.buffer_.getClass() || Array.getLength(value) != this.size_) {
                value = this.buffer_;
            }
            this.handler_.writeArray(value, out);
        }
    }
}

