/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayBuilder;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.ConvertArrayImpl;
import uk.ac.starlink.array.Converter;
import uk.ac.starlink.array.Function;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.TypeConverter;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsURL;
import uk.ac.starlink.fits.MappedFile;
import uk.ac.starlink.fits.ReadableFitsArrayImpl;
import uk.ac.starlink.fits.WritableFitsArrayImpl;
import uk.ac.starlink.util.URLUtils;

public class FitsArrayBuilder
implements ArrayBuilder {
    private static FitsArrayBuilder instance = new FitsArrayBuilder();
    private static final int MAPPED_MAX_SIZE = Integer.MAX_VALUE;
    private List extensions = new ArrayList(FitsConstants.defaultFitsExtensions());
    private static Logger logger = Logger.getLogger("uk.ac.starlink.fits");

    private FitsArrayBuilder() {
    }

    public static FitsArrayBuilder getInstance() {
        return instance;
    }

    ArrayDataInput getReadableStream(URL url, AccessMode mode) throws IOException {
        FitsURL furl = FitsURL.parseURL(url, this.extensions);
        if (furl == null) {
            return null;
        }
        URL container = furl.getContainer();
        int hdu = furl.getHDU();
        ArrayDataInput stream = null;
        if (container.getProtocol().equals("file")) {
            String modechars = mode == AccessMode.READ ? "r" : "rw";
            File file = new File(URLUtils.urlToUri((URL)container));
            String filename = file.getPath();
            BufferedFile bstrm = new BufferedFile(filename);
            FitsConstants.skipHDUs(bstrm, hdu);
            long start = bstrm.getFilePointer();
            FitsConstants.skipHDUs(bstrm, 1);
            long leng = bstrm.getFilePointer() - start;
            bstrm.close();
            if (leng <= Integer.MAX_VALUE) {
                stream = new MappedFile(filename, modechars, start, (int)leng);
            } else {
                stream = new BufferedFile(filename, modechars);
                ((BufferedFile)stream).seek(start);
            }
        }
        if (stream == null) {
            if (mode != AccessMode.READ) {
                throw new IOException("Access mode " + mode + " not supported for " + url);
            }
            InputStream istrm = container.openStream();
            stream = new BufferedDataInputStream(istrm);
            FitsConstants.skipHDUs(stream, hdu);
        }
        return stream;
    }

    public NDArray makeNDArray(URL url, AccessMode mode) throws IOException {
        ArrayDataInput stream = this.getReadableStream(url, mode);
        if (stream == null) {
            return null;
        }
        return this.makeNDArray(stream, mode, url);
    }

    public NDArray makeNDArray(ArrayDataInput stream, AccessMode mode) throws IOException {
        return this.makeNDArray(stream, mode, null);
    }

    private NDArray makeNDArray(ArrayDataInput stream, AccessMode mode, URL url) throws IOException {
        ReadableFitsArrayImpl impl;
        try {
            impl = new ReadableFitsArrayImpl(stream, mode);
        }
        catch (FitsException e) {
            throw new IOException(e.getMessage());
        }
        Type type = impl.getType();
        boolean scaled = false;
        Header hdr = impl.getHeader();
        double bscale = 1.0;
        double bzero = 0.0;
        boolean digits = false;
        if (hdr.containsKey("BSCALE")) {
            bscale = hdr.getDoubleValue("BSCALE");
        }
        if (hdr.containsKey("BZERO")) {
            bzero = hdr.getDoubleValue("BZERO");
        }
        if (bscale != 1.0 || bzero != 0.0) {
            Type stype = bscale - (double)((float)bscale) == 0.0 && bzero - (double)((float)bzero) == 0.0 ? Type.FLOAT : Type.DOUBLE;
            final double scale = bscale;
            final double invscale = 1.0 / bscale;
            final double zero = bzero;
            Function scaler = new Function(){

                public double forward(double x) {
                    return zero + scale * x;
                }

                public double inverse(double y) {
                    return (y - zero) * invscale;
                }
            };
            BridgeNDArray nda = new BridgeNDArray((ArrayImpl)impl);
            TypeConverter conv = new TypeConverter(nda.getType(), nda.getBadHandler(), stype, stype.defaultBadHandler(), scaler);
            impl = new ConvertArrayImpl((NDArray)nda, (Converter)conv);
        }
        return new BridgeNDArray((ArrayImpl)impl, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NDArray makeNewNDArray(URL url, NDShape shape, Type type, BadHandler bh) throws IOException {
        ArrayDataOutput stream;
        FitsURL furl = FitsURL.parseURL(url, this.extensions);
        if (furl == null) {
            return null;
        }
        URL container = furl.getContainer();
        int hdu = furl.getHDU();
        if (container.getProtocol().equals("file")) {
            String filename = container.getPath();
            if (hdu == 0) {
                if (new File(filename).delete()) {
                    logger.info("Deleted existing file " + filename + " prior to rewriting");
                }
                stream = new BufferedFile(filename, "rw");
            } else {
                int ihdu;
                assert (hdu > 0);
                BufferedFile bstrm = new BufferedFile(filename, "r");
                long pos = 0L;
                long leng = bstrm.length();
                for (ihdu = 0; pos < leng && ihdu < hdu; ++ihdu) {
                    Header hdr;
                    bstrm.seek(pos);
                    try {
                        hdr = new Header(bstrm);
                    }
                    catch (TruncatedFileException e) {
                        throw (IOException)new IOException("Cannot create new HDU except at end of FITS file").initCause(e);
                    }
                    long dsize = FitsConstants.getDataSize(hdr);
                    pos = bstrm.getFilePointer() + dsize;
                }
                bstrm.close();
                if (pos != leng || ihdu != hdu) throw new IOException("Cannot create new HDU except at end of FITS file");
                stream = new BufferedFile(filename, "rw");
                ((BufferedFile)stream).seek(pos);
            }
        } else {
            if (hdu > 0) {
                throw new IOException("Can't access HDU after first one in non-seekable stream");
            }
            URLConnection conn = container.openConnection();
            conn.setDoInput(false);
            conn.setDoOutput(true);
            conn.connect();
            OutputStream ostrm = conn.getOutputStream();
            stream = new BufferedDataOutputStream(ostrm);
        }
        boolean primary = hdu == 0;
        Number badval = FitsArrayBuilder.getBlankValue(type, bh);
        WritableFitsArrayImpl impl = new WritableFitsArrayImpl(shape, type, badval, stream, primary, null);
        return new BridgeNDArray((ArrayImpl)impl, url);
    }

    public NDArray makeNewNDArray(OutputStream stream, NDShape shape, Type type, BadHandler bh, boolean primary, HeaderCard[] cards) throws IOException {
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        BufferedDataOutputStream strm = new BufferedDataOutputStream(stream);
        Number badval = FitsArrayBuilder.getBlankValue(type, bh);
        WritableFitsArrayImpl impl = new WritableFitsArrayImpl(shape, type, badval, strm, primary, cards);
        return new BridgeNDArray((ArrayImpl)impl);
    }

    private static Number getBlankValue(Type type, BadHandler bh) {
        if (bh == null) {
            return type.defaultBadValue();
        }
        if (type.isFloating()) {
            return type.defaultBadValue();
        }
        return bh.getBadValue();
    }
}

