/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;

public class FitsConstants {
    public static final String NDARRAY_PREFIX = "NDA_";
    public static final HeaderCard END_CARD = new HeaderCard("END                                                                             ");
    public static final String NDARRAY_ORIGIN = "NDA_O";
    public static final String NDX_PREFIX = "NDX_";
    public static final String NDX_XML = "NDX_XML";
    public static final String WCS_ENCODING = "FITS-WCS";
    public static final int FITS_BLOCK = 2880;
    public static final int MAX_NCOLSTD = 999;
    private static final String[] extensions = new String[]{".fits", ".fit", ".fts", ".FITS", ".FIT", ".FTS", ".lilo", ".lihi", ".silo", ".sihi", ".mxlo", ".mxhi", ".rilo", ".rihi", ".vdlo", ".vdhi"};
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.fits");

    public static List defaultFitsExtensions() {
        return Collections.unmodifiableList(Arrays.asList(extensions));
    }

    static String originCardName(int naxis) {
        return NDARRAY_ORIGIN + (naxis + 1);
    }

    static int typeToBitpix(Type type) {
        if (type == Type.BYTE) {
            return 8;
        }
        if (type == Type.SHORT) {
            return 16;
        }
        if (type == Type.INT) {
            return 32;
        }
        if (type == Type.FLOAT) {
            return -32;
        }
        if (type == Type.DOUBLE) {
            return -64;
        }
        throw new AssertionError();
    }

    public static long skipHDUs(ArrayDataInput stream, int nskip) throws IOException {
        try {
            long advance = 0L;
            while (nskip-- > 0) {
                Header hdr = new Header();
                int headsize = FitsConstants.readHeader(hdr, stream);
                advance += (long)headsize;
                long datasize = FitsConstants.getDataSize(hdr);
                IOUtils.skipBytes((DataInput)stream, (long)datasize);
                advance += datasize;
            }
            return advance;
        }
        catch (TruncatedFileException e) {
            throw (IOException)new IOException("FITS file too short: " + e.getMessage()).initCause(e);
        }
    }

    public static boolean isMagic(byte[] buffer) {
        return buffer.length >= 9 && (char)buffer[0] == 'S' && (char)buffer[1] == 'I' && (char)buffer[2] == 'M' && (char)buffer[3] == 'P' && (char)buffer[4] == 'L' && (char)buffer[5] == 'E' && (char)buffer[6] == ' ' && (char)buffer[7] == ' ' && (char)buffer[8] == '=';
    }

    public static ArrayDataInput getInputStreamStart(DataSource datsrc) throws IOException {
        if (datsrc instanceof FileDataSource && datsrc.getCompression() == Compression.NONE) {
            File file = ((FileDataSource)datsrc).getFile();
            return new BufferedFile(file.getPath(), "r");
        }
        logger.config("Buffering stream " + datsrc.getName());
        return new BufferedDataInputStream(datsrc.getInputStream());
    }

    public static int readHeader(Header hdr, ArrayDataInput strm) throws TruncatedFileException, IOException {
        String cbuf;
        Cursor iter = hdr.iterator();
        byte[] buffer = new byte[80];
        boolean firstCard = true;
        int count = 0;
        do {
            String key;
            int need;
            try {
                int len;
                for (need = 80; need > 0; need -= len) {
                    len = strm.read(buffer, 80 - need, need);
                    if (len > 0) continue;
                    throw new TruncatedFileException();
                }
                ++count;
            }
            catch (EOFException e) {
                if (firstCard && need == 80) {
                    throw e;
                }
                throw new TruncatedFileException(e.getMessage());
            }
            cbuf = new String(buffer);
            HeaderCard fcard = new HeaderCard(cbuf);
            if (firstCard) {
                key = fcard.getKey();
                if (key == null || !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new IOException("Not FITS format");
                }
                firstCard = false;
            }
            key = fcard.getKey();
            if (fcard == null) continue;
            if (fcard.isKeyValuePair()) {
                iter.add(fcard.getKey(), fcard);
                continue;
            }
            iter.add(fcard);
        } while (!cbuf.substring(0, 8).equals("END     "));
        int pad = FitsUtil.padding(count * 80);
        try {
            IOUtils.skipBytes((DataInput)strm, (long)pad);
        }
        catch (EOFException e) {
            throw new TruncatedFileException(e.getMessage());
        }
        return pad + count * 80;
    }

    public static void writeHeader(final DataOutput strm, Header hdr) throws IOException {
        BufferedDataOutputStream ostrm = new BufferedDataOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                strm.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                strm.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                strm.write(b, off, len);
            }
        });
        try {
            hdr.write(ostrm);
            ostrm.flush();
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public static void writeEmptyPrimary(DataOutput strm) throws IOException {
        try {
            Header dummy = new Header();
            dummy.addValue("SIMPLE", true, "Standard FITS format");
            dummy.addValue("BITPIX", 8L, "Character data");
            dummy.addValue("NAXIS", 0L, "No image, just extensions");
            dummy.addValue("EXTEND", true, "There are standard extensions");
            dummy.insertComment("Dummy header; see following table extension");
            dummy.insertCommentStyle("END", "");
            FitsConstants.writeHeader(strm, dummy);
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public static long getDataSize(Header hdr) {
        long nel = FitsConstants.getRawSize(hdr);
        if (nel % 2880L == 0L) {
            return nel;
        }
        return (nel / 2880L + 1L) * 2880L;
    }

    public static void addTrimmedValue(Header hdr, String key, String value, String comment) throws HeaderCardException {
        if (value != null && value.length() > 68) {
            value = value.substring(0, 65) + "...";
            logger.warning("Truncated long FITS header card " + key + " = " + value);
        }
        hdr.addValue(key, value, comment);
    }

    public static void checkColumnCount(WideFits wide, int ncol) throws IOException {
        if (wide == null) {
            if (ncol > 999) {
                String msg = new StringBuffer().append("Too many columns ").append(ncol).append(" > ").append(999).append(" (FITS standard hard limit)").toString();
                throw new IOException(msg);
            }
        } else {
            int nmax = wide.getExtColumnMax();
            if (ncol > nmax) {
                String msg = new StringBuffer().append("Too many column ").append(ncol).append(" > ").append(nmax).append(" (limit of extended column convention").toString();
                throw new IOException(msg);
            }
        }
    }

    private static long getRawSize(Header hdr) {
        int i;
        int naxis = hdr.getIntValue("NAXIS", 0);
        if (naxis <= 0) {
            return 0L;
        }
        int bitpix = hdr.getIntValue("BITPIX");
        boolean isRandomGroups = hdr.getIntValue("NAXIS1") == 0 && hdr.getBooleanValue("SIMPLE") && hdr.getBooleanValue("GROUPS");
        long nel = 1L;
        int n = i = isRandomGroups ? 2 : 1;
        while (i <= naxis) {
            nel *= hdr.getLongValue("NAXIS" + i);
            ++i;
        }
        long pcount = 0L;
        long gcount = 1L;
        if (hdr.containsKey("XTENSION") || isRandomGroups) {
            pcount = hdr.getLongValue("PCOUNT", 0L);
            gcount = hdr.getLongValue("GCOUNT", 1L);
        }
        return (nel + pcount) * gcount * (long)Math.abs(bitpix) / 8L;
    }
}

