/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayFuncs;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.ValueInfo;

public class FitsStarTable
extends RandomStarTable {
    private final TableHDU thdu;
    private final int nrow;
    private final int ncol;
    private final ColumnInfo[] colinfos;
    private final double[] scales;
    private final double[] zeros;
    private final boolean[] isScaled;
    private final long[] blanks;
    private final boolean[] hasBlank;
    private static final ValueInfo tnullInfo = new DefaultValueInfo("Blank", Long.class, "Bad value indicator (TNULLn card)");
    private static final ValueInfo tscalInfo = new DefaultValueInfo("Scale", Double.class, "Multiplier for values (TSCALn card)");
    private static final ValueInfo tzeroInfo = new DefaultValueInfo("Zero", Double.class, "Offset for values (TZEROn card)");
    private static final ValueInfo tdispInfo = new DefaultValueInfo("Format", String.class, "Display format in FORTRAN notation (TDISPn card)");
    private static final ValueInfo tbcolInfo = new DefaultValueInfo("Start column", Integer.class, "Start column for data (TBCOLn card)");
    private static final ValueInfo tformInfo = new DefaultValueInfo("Format code", String.class, "Data type code (TFORMn card)");
    private static final List auxDataInfos = Arrays.asList(tnullInfo, tscalInfo, tzeroInfo, tdispInfo, tbcolInfo, tformInfo);

    public FitsStarTable(TableHDU thdu) throws IOException {
        this.thdu = thdu;
        this.nrow = thdu.getNRows();
        this.ncol = thdu.getNCols();
        this.colinfos = new ColumnInfo[this.ncol];
        this.scales = new double[this.ncol];
        Arrays.fill(this.scales, 1.0);
        this.zeros = new double[this.ncol];
        this.isScaled = new boolean[this.ncol];
        this.blanks = new long[this.ncol];
        this.hasBlank = new boolean[this.ncol];
        Header cards = thdu.getHeader();
        for (int icol = 0; icol < this.ncol; ++icol) {
            String tform;
            String tbcol;
            String tutype;
            String tucd;
            String tcomm;
            String[] sdims;
            String blankKey;
            String tdisp;
            int jcol = icol + 1;
            ColumnInfo cinfo = new ColumnInfo(thdu.getColumnName(icol));
            List auxdata = cinfo.getAuxData();
            this.colinfos[icol] = cinfo;
            String tunit = cards.getStringValue("TUNIT" + jcol);
            if (tunit != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = cards.getStringValue("TDISP" + jcol)) != null) {
                auxdata.add(new DescribedValue(tdispInfo, tdisp));
            }
            if (cards.containsKey(blankKey = "TNULL" + jcol)) {
                long nullval;
                this.blanks[icol] = nullval = cards.getLongValue(blankKey);
                this.hasBlank[icol] = true;
                auxdata.add(new DescribedValue(tnullInfo, new Long(nullval)));
            } else {
                cinfo.setNullable(false);
            }
            String tdim = cards.getStringValue("TDIM" + jcol);
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    int[] dims = new int[sdims.length];
                    for (int i = 0; i < sdims.length; ++i) {
                        dims[i] = Integer.parseInt(sdims[i]);
                    }
                    cinfo.setShape(dims);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String tscal = cards.getStringValue("TSCAL" + jcol);
            String tzero = cards.getStringValue("TZERO" + jcol);
            if (tscal != null) {
                double scalval;
                this.scales[icol] = scalval = Double.parseDouble(tscal);
                auxdata.add(new DescribedValue(tscalInfo, new Double(scalval)));
            }
            if (tzero != null) {
                double zeroval;
                this.zeros[icol] = zeroval = Double.parseDouble(tzero);
                auxdata.add(new DescribedValue(tzeroInfo, new Double(zeroval)));
            }
            if (this.scales[icol] != 1.0 || this.zeros[icol] != 0.0) {
                this.isScaled[icol] = true;
            }
            if ((tcomm = cards.getStringValue("TCOMM" + jcol)) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = cards.getStringValue("TUCD" + jcol)) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = cards.getStringValue("TUTYP" + jcol)) != null) {
                cinfo.setUtype(tutype);
            }
            if ((tbcol = cards.getStringValue("TBCOL" + jcol)) != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(tbcolInfo, new Integer(bcolval)));
            }
            if ((tform = cards.getStringValue("TFORM" + jcol)) != null) {
                auxdata.add(new DescribedValue(tformInfo, tform));
            }
            if (this.nrow > 0) {
                Object test = null;
                try {
                    for (int irow = 0; test == null && irow < this.nrow; ++irow) {
                        test = thdu.getElement(irow, icol);
                    }
                }
                catch (FitsException e) {
                    throw (IOException)new IOException("Error reading test cell").initCause(e);
                }
                Class cls = this.packagedType(test, icol);
                cinfo.setContentClass(cls);
                continue;
            }
            if (!this.isScaled[icol]) continue;
            cinfo.setContentClass(Double.class);
        }
    }

    @Override
    public long getRowCount() {
        return this.nrow;
    }

    @Override
    public int getColumnCount() {
        return this.ncol;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colinfos[icol];
    }

    @Override
    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCell(long lrow, int icol) throws IOException {
        int irow = FitsStarTable.checkedLongToInt(lrow);
        try {
            Object val;
            FitsStarTable fitsStarTable = this;
            synchronized (fitsStarTable) {
                val = this.thdu.getElement(irow, icol);
            }
            return this.packageValue(val, icol);
        }
        catch (FitsException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getRow(long lrow) throws IOException {
        Object[] row;
        int irow = FitsStarTable.checkedLongToInt(lrow);
        try {
            FitsStarTable fitsStarTable = this;
            synchronized (fitsStarTable) {
                row = this.thdu.getRow(irow);
            }
        }
        catch (FitsException e) {
            throw (IOException)new IOException().initCause(e);
        }
        for (int icol = 0; icol < this.ncol; ++icol) {
            row[icol] = this.packageValue(row[icol], icol);
        }
        return row;
    }

    private Object packageValue(Object base, int icol) {
        Class<?> cls;
        if (base == null) {
            return null;
        }
        Class<?> bcls = base.getClass();
        Class<?> clazz = cls = bcls.isArray() ? bcls.getComponentType() : null;
        if (cls != null && Array.getLength(base) == 1) {
            boolean hasblank = this.hasBlank[icol];
            long blank = this.blanks[icol];
            boolean scaled = this.isScaled[icol];
            double scale = this.scales[icol];
            double zero = this.zeros[icol];
            if (cls == Byte.TYPE) {
                byte val = ((byte[])base)[0];
                return hasblank && val == (byte)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Byte(val));
            }
            if (cls == Short.TYPE) {
                short val = ((short[])base)[0];
                return hasblank && val == (short)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Short(val));
            }
            if (cls == Integer.TYPE) {
                int val = ((int[])base)[0];
                return hasblank && val == (int)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Integer(val));
            }
            if (cls == Long.TYPE) {
                long val = ((long[])base)[0];
                return hasblank && val == blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Long(val));
            }
            if (cls == Float.TYPE) {
                float val = ((float[])base)[0];
                return scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Float(val);
            }
            if (cls == Double.TYPE) {
                double val = ((double[])base)[0];
                return scaled ? new Double(val * scale + zero) : new Double(val);
            }
            if (cls == Boolean.TYPE) {
                return new Boolean(((boolean[])base)[0]);
            }
            if (cls == String.class) {
                String val = ((String[])base)[0];
                return FitsStarTable.isEmpty(val) ? null : val;
            }
        }
        if (cls != null && cls.isArray()) {
            return ArrayFuncs.flatten(base);
        }
        if (base instanceof String && FitsStarTable.isEmpty((String)base)) {
            return null;
        }
        return base;
    }

    private Class packagedType(Object base, int icol) {
        if (base == null) {
            return Object.class;
        }
        Class<?> cls = base.getClass().getComponentType();
        if (cls != null && Array.getLength(base) == 1) {
            boolean scaled = this.isScaled[icol];
            if (scaled) {
                return Double.class;
            }
            if (cls == Byte.TYPE) {
                return Byte.class;
            }
            if (cls == Short.TYPE) {
                return Short.class;
            }
            if (cls == Integer.TYPE) {
                return Integer.class;
            }
            if (cls == Long.TYPE) {
                return Long.class;
            }
            if (cls == Float.TYPE) {
                return Float.class;
            }
            if (cls == Double.TYPE) {
                return Double.class;
            }
            if (cls == Boolean.TYPE) {
                return Boolean.class;
            }
            if (cls == String.class) {
                return String.class;
            }
        } else if (cls != null && cls.isArray()) {
            return ArrayFuncs.flatten(base).getClass();
        }
        return base.getClass();
    }

    private static boolean isEmpty(String str) {
        int leng = str.length();
        for (int i = 0; i < leng; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }
}

