/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsStarTable;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.QueueTableSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;

public class FitsTableBuilder
implements TableBuilder,
MultiTableBuilder {
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.fits");
    private final WideFits wide_;

    public FitsTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public FitsTableBuilder(WideFits wide) {
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "FITS";
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        if (!FitsConstants.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        ArrayDataInput strm = null;
        StarTable table = null;
        try {
            strm = FitsConstants.getInputStreamStart(datsrc);
            long[] pos = new long[]{0L};
            String spos = datsrc.getPosition();
            if (spos != null && spos.trim().length() > 0) {
                int ihdu;
                try {
                    ihdu = Integer.parseInt(spos.trim());
                }
                catch (NumberFormatException e) {
                    ihdu = -1;
                }
                if (ihdu >= 0) {
                    try {
                        pos[0] = pos[0] + FitsConstants.skipHDUs(strm, ihdu);
                        table = FitsTableBuilder.attemptReadTable(strm, wantRandom, datsrc, this.wide_, pos);
                    }
                    catch (EOFException e) {
                        throw new IOException("Fell off end of file looking for HDU #" + ihdu);
                    }
                }
                try {
                    table = FitsTableBuilder.findNamedTable(strm, datsrc, spos, this.wide_, pos);
                }
                catch (EOFException e) {
                    throw new IOException("No extension found with EXTNAME or EXTNAME-EXTVER \"" + spos + "\"");
                }
                if (table != null) {
                    if (table.getName() == null) {
                        table.setName(datsrc.getName());
                    }
                    table.setURL(datsrc.getURL());
                    StarTable starTable = table;
                    return starTable;
                }
                throw new IOException(datsrc + " not a Table HDU");
            }
            try {
                while ((table = FitsTableBuilder.attemptReadTable(strm, wantRandom, datsrc, this.wide_, pos)) == null) {
                }
                if (table.getName() == null) {
                    table.setName(datsrc.getName());
                }
                table.setURL(datsrc.getURL());
                StarTable ihdu = table;
                return ihdu;
            }
            catch (EOFException e) {
                try {
                    throw new IOException("No table HDUs in " + datsrc);
                }
                catch (FitsException e2) {
                    throw (TableFormatException)new TableFormatException(e2.getMessage()).initCause(e2);
                }
            }
        }
        finally {
            if (strm != null) {
                strm.close();
            }
        }
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy policy) throws IOException {
        String frag = datsrc.getPosition();
        if (frag != null && frag.trim().length() > 0) {
            return Tables.singleTableSequence(this.makeStarTable(datsrc, false, policy));
        }
        if (!FitsConstants.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        MultiLoadWorker loadWorker = new MultiLoadWorker(datsrc, this.wide_);
        loadWorker.start();
        return loadWorker.getTableSequence();
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    @Override
    public void streamStarTable(InputStream istrm, TableSink sink, String extnum) throws IOException {
        BufferedDataInputStream in = new BufferedDataInputStream(istrm);
        try {
            if (extnum != null && extnum.matches("[1-9][0-9]*")) {
                int ihdu = Integer.parseInt(extnum);
                FitsConstants.skipHDUs(in, ihdu);
                if (!this.attemptStreamStarTable(in, sink, false)) {
                    throw new IOException("No table HDU at extension " + ihdu);
                }
            } else {
                boolean done = false;
                while (!done) {
                    done = this.attemptStreamStarTable(in, sink, true);
                }
                if (!done) {
                    throw new IOException("No table extensions found");
                }
            }
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private boolean attemptStreamStarTable(ArrayDataInput in, TableSink sink, boolean readAnyway) throws IOException, FitsException {
        Header hdr = new Header();
        try {
            FitsConstants.readHeader(hdr, in);
        }
        catch (IOException e) {
            throw new TableFormatException("Can't read FITS header", e);
        }
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            BasicInput input = InputFactory.createSequentialInput(in);
            BintableStarTable.streamStarTable(hdr, input, this.wide_, sink);
            return true;
        }
        if ("TABLE".equals(xtension)) {
            AsciiTable tdata = new AsciiTable(hdr);
            tdata.read(in);
            tdata.getData();
            AsciiTableHDU thdu = new AsciiTableHDU(hdr, tdata);
            Tables.streamStarTable(new FitsStarTable(thdu), sink);
            return true;
        }
        if (readAnyway) {
            long datasize = FitsConstants.getDataSize(hdr);
            IOUtils.skipBytes((DataInput)in, (long)datasize);
        }
        return false;
    }

    public static StarTable findNamedTable(ArrayDataInput strm, DataSource datsrc, String name, WideFits wide, long[] pos) throws FitsException, IOException {
        while (true) {
            Header hdr = new Header();
            int headsize = FitsConstants.readHeader(hdr, strm);
            long datasize = FitsConstants.getDataSize(hdr);
            long datpos = pos[0] + (long)headsize;
            pos[0] = pos[0] + ((long)headsize + datasize);
            if (FitsTableBuilder.headerName(hdr, name)) {
                TableResult tres = FitsTableBuilder.attemptReadTableData(strm, datsrc, datpos, hdr, wide);
                assert (pos[0] == tres.afterPos_);
                return tres.table_;
            }
            IOUtils.skipBytes((DataInput)strm, (long)datasize);
        }
    }

    public static StarTable attemptReadTable(ArrayDataInput strm, boolean wantRandom, DataSource datsrc, WideFits wide, long[] pos) throws FitsException, IOException {
        TableResult tres = FitsTableBuilder.attemptReadTable(strm, datsrc, wide, pos[0]);
        pos[0] = tres.afterPos_;
        return tres.table_;
    }

    private static TableResult attemptReadTable(ArrayDataInput strm, DataSource datsrc, WideFits wide, long pos) throws FitsException, IOException {
        Header hdr = new Header();
        int headsize = FitsConstants.readHeader(hdr, strm);
        long datpos = pos + (long)headsize;
        return FitsTableBuilder.attemptReadTableData(strm, datsrc, datpos, hdr, wide);
    }

    private static TableResult attemptReadTableData(ArrayDataInput strm, DataSource datsrc, long datpos, Header hdr, WideFits wide) throws FitsException, IOException {
        long datasize = FitsConstants.getDataSize(hdr);
        long afterpos = datpos + datasize;
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            InputFactory inFact = InputFactory.createFactory(datsrc, datpos, datasize);
            BintableStarTable table = BintableStarTable.createTable(hdr, inFact, wide);
            IOUtils.skipBytes((DataInput)strm, (long)datasize);
            return new TableResult(table, afterpos);
        }
        if ("TABLE".equals(xtension)) {
            AsciiTable tdata = new AsciiTable(hdr);
            tdata.read(strm);
            tdata.getData();
            AsciiTableHDU thdu = new AsciiTableHDU(hdr, tdata);
            return new TableResult(new FitsStarTable(thdu), afterpos);
        }
        IOUtils.skipBytes((DataInput)strm, (long)datasize);
        return new TableResult(null, afterpos);
    }

    private static boolean headerName(Header hdr, String name) {
        String extname = hdr.getStringValue("EXTNAME");
        if (extname == null || extname.trim().length() == 0) {
            return false;
        }
        if (extname.trim().equalsIgnoreCase(name)) {
            return true;
        }
        int extver = hdr.getIntValue("EXTVER", Integer.MIN_VALUE);
        if (extver != Integer.MIN_VALUE) {
            return (extname + "-" + extver).equalsIgnoreCase(name);
        }
        return false;
    }

    private static boolean isEof(ArrayDataInput in) throws IOException {
        if (in instanceof RandomAccess) {
            boolean eof;
            RandomAccess rin = (RandomAccess)in;
            long pos = rin.getFilePointer();
            try {
                rin.readByte();
                eof = false;
            }
            catch (EOFException e) {
                eof = true;
            }
            catch (IOException e) {
                eof = true;
            }
            if (!eof) {
                rin.seek(pos);
            }
            return eof;
        }
        if (in instanceof InputStream && ((InputStream)((Object)in)).markSupported()) {
            boolean eof;
            block8: {
                InputStream is = (InputStream)((Object)in);
                is.mark(1);
                eof = is.read() < 0;
                try {
                    is.reset();
                }
                catch (IOException e) {
                    if (eof) break block8;
                    throw e;
                }
            }
            return eof;
        }
        return false;
    }

    private static class TableResult {
        final StarTable table_;
        final long afterPos_;

        TableResult(StarTable table, long afterPos) {
            this.table_ = table;
            this.afterPos_ = afterPos;
        }
    }

    private static class MultiLoadWorker
    extends Thread {
        private final DataSource datsrc_;
        private final WideFits wide_;
        private final QueueTableSequence tqueue_;

        MultiLoadWorker(DataSource datsrc, WideFits wide) {
            super("FITS multi table loader");
            this.setDaemon(true);
            this.datsrc_ = datsrc;
            this.wide_ = wide;
            this.tqueue_ = new QueueTableSequence();
        }

        TableSequence getTableSequence() {
            return this.tqueue_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.multiLoad();
            }
            catch (Throwable e) {
                this.tqueue_.addError(e);
            }
            finally {
                this.tqueue_.endSequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void multiLoad() throws IOException, FitsException {
            ArrayDataInput in = FitsConstants.getInputStreamStart(this.datsrc_);
            try {
                long pos = 0L;
                boolean done = false;
                int ihdu = 0;
                while (!done) {
                    TableResult tres = FitsTableBuilder.attemptReadTable(in, this.datsrc_, this.wide_, pos);
                    StarTable table = tres.table_;
                    pos = tres.afterPos_;
                    if (table != null) {
                        URL baseUrl;
                        if (table.getName() == null) {
                            table.setName(this.datsrc_.getName() + "#" + ihdu);
                        }
                        if ((baseUrl = this.datsrc_.getURL()) != null && baseUrl.toString().indexOf(35) < 0) {
                            String hduUrl = baseUrl + "#" + ihdu;
                            try {
                                table.setURL(new URL(hduUrl));
                            }
                            catch (MalformedURLException e) {
                                logger.info("Bad URL " + hduUrl + "?");
                            }
                        }
                        this.tqueue_.addTable(table);
                    }
                    done = FitsTableBuilder.isEof(in);
                    ++ihdu;
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }
}

