/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;

public class FitsTableWriter
extends AbstractFitsTableWriter {
    private final boolean allowSignedByte_;
    private final WideFits wide_;

    public FitsTableWriter() {
        this("fits-basic", true, WideFits.DEFAULT);
    }

    public FitsTableWriter(String name, boolean allowSignedByte, WideFits wide) {
        super(name);
        this.allowSignedByte_ = allowSignedByte;
        this.wide_ = wide;
    }

    @Override
    public boolean looksLikeFile(String location) {
        String exten;
        int dotPos = location.lastIndexOf(46);
        return dotPos > 0 && ((exten = location.substring(dotPos + 1).toLowerCase()).equals("fit") || exten.equals("fits") || exten.equals("fts"));
    }

    @Override
    protected FitsTableSerializer createSerializer(StarTable table) throws IOException {
        return new StandardFitsTableSerializer(table, this.allowSignedByte_, this.wide_);
    }
}

