/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;

public class HeaderCards {
    private final Header hdr_;
    private final Collection usedSet_;
    public final String[] BORING_KEYS = new String[]{"XTENSION", "PCOUNT", "GCOUNT", "BITPIX", "NAXIS", "END"};

    public HeaderCards(Header hdr) {
        this.hdr_ = hdr;
        this.usedSet_ = new HashSet();
    }

    public Integer getIntValue(String key) {
        return this.containsKey(key) ? new Integer(this.hdr_.getIntValue(key)) : null;
    }

    public Long getLongValue(String key) {
        return this.containsKey(key) ? new Long(this.hdr_.getLongValue(key)) : null;
    }

    public Double getDoubleValue(String key) {
        return this.containsKey(key) ? new Double(this.hdr_.getDoubleValue(key)) : null;
    }

    public String getStringValue(String key) {
        return this.containsKey(key) ? this.hdr_.findCard(key).getValue() : null;
    }

    public void useKey(String key) {
        if (this.hdr_.containsKey(key)) {
            this.usedSet_.add(key);
        }
    }

    public boolean containsKey(String key) {
        if (this.hdr_.containsKey(key)) {
            this.usedSet_.add(key);
            return true;
        }
        return false;
    }

    public DescribedValue[] getUnusedParams() {
        HashSet<String> excludes = new HashSet<String>(this.usedSet_);
        excludes.addAll(Arrays.asList(this.BORING_KEYS));
        ArrayList<DescribedValue> paramList = new ArrayList<DescribedValue>();
        HashMap<String, DescribedValue> paramMap = new HashMap<String, DescribedValue>();
        Cursor it = this.hdr_.iterator();
        while (it.hasNext()) {
            HeaderCard card = (HeaderCard)it.next();
            String name = card.getKey();
            if ("HISTORY".equals(name) || "COMMENT".equals(name)) {
                String value;
                String sval = card.toString().trim();
                String string = value = sval.length() >= 8 ? sval.substring(8) : "";
                if (!paramMap.containsKey(name)) {
                    DefaultValueInfo info = new DefaultValueInfo(name, StringBuffer.class, "FITS " + name + " card values");
                    DescribedValue dval = new DescribedValue(info, new StringBuffer(value));
                    paramMap.put(name, dval);
                    paramList.add(dval);
                    continue;
                }
                DescribedValue dval = (DescribedValue)paramMap.get(name);
                ((StringBuffer)dval.getValue()).append('\n').append(value);
                continue;
            }
            if (name == null || name.trim().length() <= 0 || excludes.contains(name) || paramMap.containsKey(name)) continue;
            DescribedValue dval = HeaderCards.toDescribedValue(card);
            paramMap.put(name, dval);
            paramList.add(dval);
        }
        DescribedValue[] params = paramList.toArray(new DescribedValue[0]);
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getInfo().getContentClass() == StringBuffer.class) {
                ValueInfo info0 = params[i].getInfo();
                Object value0 = params[i].getValue();
                DefaultValueInfo info1 = new DefaultValueInfo(info0.getName(), String.class, info0.getDescription());
                String value1 = ((StringBuffer)value0).toString();
                params[i] = new DescribedValue(info1, value1);
            }
            DescribedValue dval = params[i];
            Object val = params[i].getValue();
            assert (val == null || params[i].getInfo().getContentClass().isAssignableFrom(val.getClass()));
        }
        return params;
    }

    private static DescribedValue toDescribedValue(HeaderCard card) {
        String key = card.getKey();
        String comment = card.getComment();
        Object value = HeaderCards.toObject(card.getValue());
        Class clazz = value == null ? String.class : value.getClass();
        DefaultValueInfo info = new DefaultValueInfo(key, clazz);
        if (comment != null && comment.trim().length() > 0) {
            info.setDescription(comment.trim());
        }
        return new DescribedValue(info, value);
    }

    private static Object toObject(String sval) {
        if (sval == null) {
            return null;
        }
        if ((sval = sval.trim()).length() == 0) {
            return null;
        }
        int sleng = sval.length();
        if (sval.charAt(0) == '\'' && sval.charAt(sleng - 1) == '\'') {
            return sval.substring(1, sleng - 1);
        }
        if ("T".equals(sval)) {
            return Boolean.TRUE;
        }
        if ("F".equals(sval)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(sval);
        }
        catch (NumberFormatException e) {
            try {
                return Long.valueOf(sval);
            }
            catch (NumberFormatException e2) {
                try {
                    return Double.valueOf(sval.replaceFirst("[dD]", "e"));
                }
                catch (NumberFormatException numberFormatException) {
                    return sval;
                }
            }
        }
    }
}

