/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import nom.tam.util.BufferedFile;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BlockMappedInput;
import uk.ac.starlink.fits.SimpleMappedInput;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.Loader;

public abstract class InputFactory
implements Closeable {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public abstract boolean isRandom();

    public abstract BasicInput createInput(boolean var1) throws IOException;

    public static InputFactory createFactory(DataSource datsrc, long offset, long leng) throws IOException {
        boolean isFile = datsrc instanceof FileDataSource;
        if (isFile && datsrc.getCompression() == Compression.NONE) {
            File uncompressedFile = ((FileDataSource)datsrc).getFile();
            return InputFactory.createFileFactory(uncompressedFile, offset, leng);
        }
        if (isFile) {
            logger_.warning("Can't map compressed file " + datsrc.getName() + " - uncompressing may improve performance");
        } else {
            logger_.info("Will read stream (not random-access): " + datsrc);
        }
        return InputFactory.createSequentialFactory(datsrc, offset, leng);
    }

    public static InputFactory createSequentialFactory(final DataSource datsrc, final long offset, long leng) {
        return new AbstractInputFactory(false){

            @Override
            public BasicInput createInput(boolean isSeq) throws IOException {
                InputStream baseIn = datsrc.getInputStream();
                IOUtils.skip((InputStream)baseIn, (long)offset);
                DataInputStream dataIn = new DataInputStream(new BufferedInputStream(baseIn));
                return 1.createSequentialInput(dataIn);
            }

            @Override
            public void close() {
                datsrc.close();
            }
        };
    }

    public static InputFactory createFileFactory(File uncompressedFile, final long offset, final long leng) throws IOException {
        final File file = uncompressedFile;
        final String logName = file.getName();
        if (leng <= 0x20000000L) {
            logger_.info("Will map as single block: " + logName);
            final int ileng = (int)leng;
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            final FileChannel chan = raf.getChannel();
            return new AbstractInputFactory(true){

                @Override
                public BasicInput createInput(boolean isSeq) throws IOException {
                    return new SimpleMappedInput(chan, offset, ileng, logName);
                }

                @Override
                public void close() throws IOException {
                    chan.close();
                }
            };
        }
        if (Loader.is64Bit()) {
            logger_.info("Will map as multiple blocks: " + file);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            final FileChannel chan = raf.getChannel();
            return new AbstractInputFactory(true){

                @Override
                public BasicInput createInput(boolean isSeq) throws IOException {
                    return BlockMappedInput.createInput(chan, offset, leng, logName, !isSeq);
                }

                @Override
                public void close() throws IOException {
                    chan.close();
                }
            };
        }
        logger_.info("Will read as BufferedFile: " + file + " (avoid too much mapping on 32-bit OS");
        return new AbstractInputFactory(true){

            @Override
            public BasicInput createInput(boolean isSeq) throws IOException {
                BufferedFile bf = new BufferedFile(file.getPath(), "r");
                return new RandomAccessInput(bf, offset);
            }

            @Override
            public void close() {
            }
        };
    }

    public static BasicInput createSequentialInput(final DataInput in) {
        return new BasicInput(){

            @Override
            public byte readByte() throws IOException {
                return in.readByte();
            }

            @Override
            public short readShort() throws IOException {
                return in.readShort();
            }

            @Override
            public int readInt() throws IOException {
                return in.readInt();
            }

            @Override
            public long readLong() throws IOException {
                return in.readLong();
            }

            @Override
            public float readFloat() throws IOException {
                return in.readFloat();
            }

            @Override
            public double readDouble() throws IOException {
                return in.readDouble();
            }

            @Override
            public void skip(long nbyte) throws IOException {
                IOUtils.skipBytes((DataInput)in, (long)nbyte);
            }

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public void seek(long offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getOffset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    private static class RandomAccessInput
    implements BasicInput {
        private final RandomAccess stream_;
        private final long offset_;

        public RandomAccessInput(RandomAccess stream, long offset) throws IOException {
            this.stream_ = stream;
            this.offset_ = offset;
            this.stream_.seek(offset);
        }

        @Override
        public byte readByte() throws IOException {
            return this.stream_.readByte();
        }

        @Override
        public short readShort() throws IOException {
            return this.stream_.readShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.stream_.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.stream_.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.stream_.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.stream_.readDouble();
        }

        @Override
        public void skip(long nbytes) throws IOException {
            this.seek(this.getOffset() + nbytes);
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void seek(long offset) throws IOException {
            this.stream_.seek(this.offset_ + offset);
        }

        @Override
        public long getOffset() {
            return this.stream_.getFilePointer() - this.offset_;
        }

        @Override
        public void close() throws IOException {
            this.stream_.close();
        }
    }

    private static abstract class AbstractInputFactory
    extends InputFactory {
        private final boolean isRandom_;

        AbstractInputFactory(boolean isRandom) {
            this.isRandom_ = isRandom;
        }

        @Override
        public boolean isRandom() {
            return this.isRandom_;
        }
    }
}

