/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import uk.ac.starlink.util.ValueWatcher;

abstract class IntegerStorage {
    private final char formatChar_;
    private final int typeBytes_;
    private final ValueWatcher badWatcher_;

    protected IntegerStorage(char formatChar, int typeBytes, long loBad, long hiBad) {
        this.formatChar_ = formatChar;
        this.typeBytes_ = typeBytes;
        this.badWatcher_ = new ValueWatcher(loBad, hiBad);
    }

    public char getFormatChar() {
        return this.formatChar_;
    }

    public int getTypeBytes() {
        return this.typeBytes_;
    }

    public final void writeValue(long value, DataOutput out) throws IOException {
        this.badWatcher_.useValue(value);
        this.doWriteValue(value, out);
    }

    protected abstract void doWriteValue(long var1, DataOutput var3) throws IOException;

    public byte[] getBadBytes() {
        Long badObj = this.badWatcher_.getUnused();
        if (badObj == null) {
            return null;
        }
        byte[] badbuf = new byte[this.typeBytes_];
        long bad = badObj;
        for (int i = this.typeBytes_ - 1; i >= 0; --i) {
            badbuf[i] = (byte)(0xFFL & bad);
            bad >>= 8;
        }
        return badbuf;
    }

    public Number getBadNumber() {
        Long badLong = this.badWatcher_.getUnused();
        return badLong == null ? (Number)null : (Number)this.convertLong(badLong);
    }

    protected abstract Number convertLong(long var1);

    public static IntegerStorage createByteStorage() {
        return new IntegerStorage('B', 1, -128L, 127L){

            @Override
            protected void doWriteValue(long value, DataOutput out) throws IOException {
                out.writeByte((byte)value);
            }

            @Override
            protected Number convertLong(long val) {
                return new Byte((byte)val);
            }
        };
    }

    public static IntegerStorage createShortStorage() {
        return new IntegerStorage('I', 2, -32768L, 32767L){

            @Override
            protected void doWriteValue(long value, DataOutput out) throws IOException {
                out.writeShort((short)value);
            }

            @Override
            protected Number convertLong(long val) {
                return new Short((short)val);
            }
        };
    }

    public static IntegerStorage createIntStorage() {
        return new IntegerStorage('J', 4, Integer.MIN_VALUE, -2147481600L){

            @Override
            protected void doWriteValue(long value, DataOutput out) throws IOException {
                out.writeInt((int)value);
            }

            @Override
            protected Number convertLong(long val) {
                return new Integer((int)val);
            }
        };
    }

    public static IntegerStorage createLongStorage() {
        return new IntegerStorage('K', 8, Long.MIN_VALUE, -9223372036854773760L){

            @Override
            protected void doWriteValue(long value, DataOutput out) throws IOException {
                out.writeLong(value);
            }

            @Override
            protected Number convertLong(long val) {
                return new Long(val);
            }
        };
    }
}

