/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.AbstractArrayDataIO;
import uk.ac.starlink.util.Loader;

public class MappedFile
extends AbstractArrayDataIO
implements RandomAccess {
    private final ByteBuffer niobuf_;
    private int size_;

    public MappedFile(ByteBuffer buf) {
        this.niobuf_ = buf;
    }

    public MappedFile(String filename) throws IOException {
        this(filename, "r");
    }

    public MappedFile(String filename, String mode) throws IOException {
        this(MappedFile.getExistingFileBuffer(filename, mode));
    }

    public MappedFile(String filename, String mode, long start, int size) throws IOException {
        this(MappedFile.getNioBuffer(filename, mode, start, size));
    }

    @Override
    public void seek(long offsetFromStart) throws IOException {
        if (offsetFromStart > (long)this.niobuf_.capacity()) {
            throw new IOException("Attempt to seek beyond end of file");
        }
        this.niobuf_.position((int)offsetFromStart);
    }

    @Override
    public long skip(long offset) {
        return this.skipBytes((int)Math.min(offset, Integer.MAX_VALUE));
    }

    @Override
    public long getFilePointer() {
        return this.niobuf_.position();
    }

    @Override
    public int skipBytes(int toSkip) {
        int nskip = Math.max(toSkip, 0);
        nskip = Math.min(toSkip, this.niobuf_.remaining());
        this.niobuf_.position(this.niobuf_.position() + nskip);
        return nskip;
    }

    @Override
    protected byte get() throws IOException {
        try {
            return this.niobuf_.get();
        }
        catch (BufferUnderflowException e) {
            throw (IOException)new EOFException().initCause(e);
        }
    }

    @Override
    protected void get(byte[] buf, int offset, int length) throws IOException {
        try {
            this.niobuf_.get(buf, offset, length);
        }
        catch (BufferUnderflowException e) {
            throw (IOException)new EOFException().initCause(e);
        }
    }

    @Override
    protected void put(byte b) throws IOException {
        try {
            this.niobuf_.put(b);
        }
        catch (BufferOverflowException e) {
            throw (IOException)new EOFException().initCause(e);
        }
    }

    @Override
    protected void put(byte[] buf, int offset, int length) throws IOException {
        try {
            this.niobuf_.put(buf, offset, length);
        }
        catch (BufferOverflowException e) {
            throw (IOException)new EOFException().initCause(e);
        }
    }

    @Override
    public long length() {
        return this.niobuf_.capacity();
    }

    @Override
    protected long remaining() {
        return this.niobuf_.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        if (this.niobuf_ instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.niobuf_).force();
        }
    }

    private static MappedByteBuffer getNioBuffer(String filename, String mode, long start, int size) throws IOException {
        MappedByteBuffer buf;
        FileChannel.MapMode mapmode;
        RandomAccessFile raf = new RandomAccessFile(filename, mode);
        FileChannel channel = raf.getChannel();
        if (mode.equals("r")) {
            mapmode = FileChannel.MapMode.READ_ONLY;
        } else if (mode.equals("rw")) {
            mapmode = FileChannel.MapMode.READ_WRITE;
        } else {
            throw new IllegalArgumentException("Invalid mode string \"" + mode + "\" - must be \"r\" or \"rw\"");
        }
        try {
            buf = channel.map(mapmode, start, size);
        }
        catch (IOException e) {
            if (e.getCause() instanceof OutOfMemoryError) {
                String msg = "Out of memory when mapping file " + filename;
                if (!Loader.is64Bit()) {
                    msg = msg + " (64-bit OS might help?)";
                }
                throw new FileTooLongException(msg, e);
            }
            throw e;
        }
        finally {
            channel.close();
        }
        return buf;
    }

    private static MappedByteBuffer getExistingFileBuffer(String filename, String mode) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException("No such file " + filename);
        }
        long size = file.length();
        if (size > Integer.MAX_VALUE) {
            throw new FileTooLongException(filename + " too long to map: " + size + " > " + Integer.MAX_VALUE + " - use buffered reads instead");
        }
        return MappedFile.getNioBuffer(filename, mode, 0L, (int)size);
    }

    public static class FileTooLongException
    extends IOException {
        FileTooLongException(String msg) {
            super(msg);
        }

        FileTooLongException(String msg, Throwable e) {
            super(msg);
            this.initCause(e);
        }
    }
}

