/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.Unmapper;

public class SimpleMappedInput
implements BasicInput {
    private MappedByteBuffer niobuf_;
    private final String logName_;
    private final Unmapper unmapper_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public SimpleMappedInput(FileChannel chan, long pos, int size, String logName) throws IOException {
        this.niobuf_ = chan.map(FileChannel.MapMode.READ_ONLY, pos, size);
        logger_.info("Mapping as single file: " + logName);
        this.logName_ = logName;
        this.unmapper_ = Unmapper.getInstance();
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public void seek(long pos) throws EOFException {
        int ipos = (int)pos;
        if ((long)ipos == pos) {
            try {
                this.niobuf_.position(ipos);
            }
            catch (IllegalArgumentException e) {
                if (ipos > this.niobuf_.limit()) {
                    throw (EOFException)new EOFException().initCause(e);
                }
                throw e;
            }
        } else {
            throw new EOFException("Out of bounds: " + pos);
        }
    }

    @Override
    public long getOffset() {
        return this.niobuf_.position();
    }

    @Override
    public void skip(long nbyte) throws IOException {
        this.seek(this.getOffset() + nbyte);
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.niobuf_.get();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public short readShort() throws EOFException {
        try {
            return this.niobuf_.getShort();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int readInt() throws EOFException {
        try {
            return this.niobuf_.getInt();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public long readLong() throws EOFException {
        try {
            return this.niobuf_.getLong();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public float readFloat() throws EOFException {
        try {
            return this.niobuf_.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public double readDouble() throws EOFException {
        try {
            return this.niobuf_.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public void close() {
        MappedByteBuffer niobuf = this.niobuf_;
        this.niobuf_ = null;
        if (niobuf != null) {
            boolean success = this.unmapper_.unmap(niobuf);
            logger_.config("Attempt to unmap " + this.logName_ + ": " + (success ? "succeed" : "fail"));
        }
    }
}

