/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.Loader;

public abstract class Unmapper {
    private static Unmapper instance_;
    private static final Logger logger_;
    public static final String UNMAP_PROPERTY = "startable.unmap";

    public abstract boolean unmap(MappedByteBuffer var1);

    public static synchronized Unmapper getInstance() {
        if (instance_ == null) {
            instance_ = Unmapper.createInstance();
        }
        return instance_;
    }

    private static Unmapper createInstance() {
        String pref;
        try {
            pref = System.getProperty(UNMAP_PROPERTY);
        }
        catch (SecurityException e) {
            pref = null;
        }
        if ("sun".equalsIgnoreCase(pref)) {
            logger_.info("Using Sun buffer unmapper by explicit request");
            try {
                SunUnmapper unmapper = new SunUnmapper();
                logger_.log(Level.CONFIG, "Explicit buffer unmapping should work");
                return unmapper;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "Can't use Sun unmapper, fall back to no-op", e);
                return new NopUnmapper();
            }
        }
        if ("none".equalsIgnoreCase(pref)) {
            logger_.info("Using no-op buffer unmapper by explicit request");
            logger_.config("No explicit unmapping");
            return new NopUnmapper();
        }
        if (pref == null) {
            try {
                SunUnmapper unmapper = new SunUnmapper();
                logger_.log(Level.CONFIG, "Explicit buffer unmapping should work");
                return unmapper;
            }
            catch (Exception e) {
                logger_.log(Level.CONFIG, "No explicit unmapping: " + e, e);
                return new NopUnmapper();
            }
        }
        Unmapper unmapper = (Unmapper)Loader.getClassInstance((String)pref, Unmapper.class);
        if (unmapper != null) {
            logger_.info("Using custom buffer unmapper " + pref + " by explicit request");
            return unmapper;
        }
        logger_.log(Level.WARNING, "Can't use unknown unmapper " + pref + ", fall back to no-op");
        return new NopUnmapper();
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.fits");
    }

    private static class NopUnmapper
    extends Unmapper {
        private NopUnmapper() {
        }

        @Override
        public boolean unmap(MappedByteBuffer buf) {
            return false;
        }
    }

    private static class SunUnmapper
    extends Unmapper {
        private final Class directBufferClazz_ = Class.forName("sun.nio.ch.DirectBuffer");
        private final Class cleanerClazz_ = Class.forName("sun.misc.Cleaner");
        private final Method cleanerMethod_ = this.directBufferClazz_.getMethod("cleaner", new Class[0]);
        private final Method cleanMethod_ = this.cleanerClazz_.getMethod("clean", new Class[0]);

        SunUnmapper() throws Exception {
        }

        @Override
        public boolean unmap(MappedByteBuffer buf) {
            if (this.directBufferClazz_.isAssignableFrom(buf.getClass())) {
                try {
                    this.cleanMethod_.invoke(this.cleanerMethod_.invoke((Object)buf, new Object[0]), new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

