/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.Cursor;
import uk.ac.starlink.fits.ArrayWriter;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;

public class VariableFitsTableSerializer
extends StandardFitsTableSerializer {
    private final StoragePolicy storagePolicy_;
    private final boolean allowSignedByte_;

    public VariableFitsTableSerializer(StarTable table, StoragePolicy storagePolicy, boolean allowSignedByte, WideFits wide) throws IOException {
        super(allowSignedByte, wide);
        this.storagePolicy_ = storagePolicy;
        this.allowSignedByte_ = allowSignedByte;
        this.init(table);
        this.set64BitMode(this.getHeapSize() > Integer.MAX_VALUE);
    }

    public void set64BitMode(boolean useQ) {
        PQMode pqMode = useQ ? PQMode.Q : PQMode.P;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setPQMode(pqMode);
        }
    }

    @Override
    public Header getHeader() throws HeaderCardException {
        Header hdr = super.getHeader();
        long heapSize = this.getHeapSize();
        long datEnd = hdr.getIntValue("NAXIS1") * hdr.getIntValue("NAXIS2");
        long theap = (datEnd + 2880L - 1L) / 2880L * 2880L;
        long gap = theap - datEnd;
        long pcount = gap + heapSize;
        final ArrayList<HeaderCard> cardList = new ArrayList<HeaderCard>();
        assert (hdr.containsKey("PCOUNT"));
        assert (hdr.containsKey("GCOUNT"));
        hdr.removeCard("THEAP");
        assert (hdr.containsKey("NAXIS2"));
        Cursor it = hdr.iterator();
        while (it.hasNext()) {
            HeaderCard card = (HeaderCard)it.next();
            String key = card.getKey();
            if ("PCOUNT".equals(key)) {
                cardList.add(new HeaderCard("PCOUNT", pcount, "heap size + gap"));
                continue;
            }
            if ("TFIELDS".equals(key)) {
                cardList.add(card);
                cardList.add(new HeaderCard("THEAP", theap, "heap start (block aligned)"));
                continue;
            }
            cardList.add(card);
        }
        return new Header(){
            {
                Iterator it = cardList.iterator();
                while (it.hasNext()) {
                    this.addLine((HeaderCard)it.next());
                }
            }
        };
    }

    private VariableArrayColumnWriter[] getVariableArrayColumnWriters() {
        ColumnWriter[] colWriters = this.getColumnWriters();
        ArrayList<ColumnWriter> vcwList = new ArrayList<ColumnWriter>();
        for (int icol = 0; icol < colWriters.length; ++icol) {
            if (!(colWriters[icol] instanceof VariableArrayColumnWriter)) continue;
            vcwList.add(colWriters[icol]);
        }
        return vcwList.toArray(new VariableArrayColumnWriter[0]);
    }

    private final long getHeapSize() {
        long count = 0L;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            VariableArrayColumnWriter vcw = vcws[iv];
            count += vcw.totalElements_ * (long)vcw.arrayWriter_.getByteCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(DataOutput out) throws IOException {
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        ByteStore byteStore = this.storagePolicy_.makeByteStore();
        int bufsiz = 65536;
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(byteStore.getOutputStream(), bufsiz));
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput(dataOut);
        }
        try {
            super.writeData(out);
            dataOut.flush();
            byteStore.copy(VariableFitsTableSerializer.toStream(out));
        }
        finally {
            byteStore.close();
        }
        assert (byteStore.getLength() == this.getHeapSize());
        int over = (int)(this.getHeapSize() % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput(null);
        }
    }

    @Override
    ColumnWriter createColumnWriter(ColumnInfo cinfo, int[] shape, boolean varShape, int eSize, int maxEls, long totalEls, boolean nullableInt) {
        Class clazz = cinfo.getContentClass();
        if (!varShape || clazz == String.class || clazz == String[].class) {
            return super.createColumnWriter(cinfo, shape, varShape, eSize, maxEls, totalEls, nullableInt);
        }
        assert (clazz.isArray());
        ArrayWriter aw = ArrayWriter.createArrayWriter(cinfo, this.allowSignedByte_);
        return new VariableArrayColumnWriter(aw, maxEls, totalEls);
    }

    private static OutputStream toStream(final DataOutput dataOut) {
        if (dataOut instanceof OutputStream) {
            return (OutputStream)((Object)dataOut);
        }
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                dataOut.write(b);
            }

            @Override
            public void write(byte[] buf) throws IOException {
                dataOut.write(buf);
            }

            @Override
            public void write(byte[] buf, int off, int leng) throws IOException {
                dataOut.write(buf, off, leng);
            }
        };
    }

    private static abstract class PQMode {
        private final char formatChar_;
        private final int intLength_;
        public static final PQMode P = new PQMode('P', 4){

            @Override
            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeInt(Tables.checkedLongToInt(value));
            }
        };
        public static final PQMode Q = new PQMode('Q', 8){

            @Override
            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeLong(value);
            }
        };

        private PQMode(char formatChar, int intLength) {
            this.formatChar_ = formatChar;
            this.intLength_ = intLength;
        }

        public abstract void writeInteger(DataOutput var1, long var2) throws IOException;

        public char getFormatChar() {
            return this.formatChar_;
        }

        public int getIntegerLength() {
            return this.intLength_;
        }
    }

    private static class VariableArrayColumnWriter
    implements ColumnWriter {
        private final ArrayWriter arrayWriter_;
        private final int maxElements_;
        private final long totalElements_;
        private PQMode pqMode_;
        private DataOutputStream dataOut_;

        VariableArrayColumnWriter(ArrayWriter arrayWriter, int maxElements, long totalElements) {
            this.arrayWriter_ = arrayWriter;
            this.maxElements_ = maxElements;
            this.totalElements_ = totalElements;
        }

        public void setPQMode(PQMode pqMode) {
            this.pqMode_ = pqMode;
        }

        public void setDataOutput(DataOutputStream dataOut) {
            this.dataOut_ = dataOut;
        }

        @Override
        public void writeValue(DataOutput out, Object value) throws IOException {
            int leng = value == null ? 0 : Array.getLength(value);
            this.pqMode_.writeInteger(out, leng);
            this.pqMode_.writeInteger(out, leng == 0 ? 0L : (long)this.dataOut_.size());
            for (int i = 0; i < leng; ++i) {
                this.arrayWriter_.writeElement(this.dataOut_, value, i);
            }
        }

        @Override
        public char getFormatChar() {
            return this.arrayWriter_.getFormatChar();
        }

        @Override
        public String getFormat() {
            return new StringBuffer().append(this.pqMode_.getFormatChar()).append(this.arrayWriter_.getFormatChar()).append('(').append(this.maxElements_).append(')').toString();
        }

        @Override
        public int getLength() {
            return 2 * this.pqMode_.getIntegerLength();
        }

        @Override
        public int[] getDims() {
            return new int[]{-1};
        }

        @Override
        public double getZero() {
            return this.arrayWriter_.getZero();
        }

        @Override
        public double getScale() {
            return 1.0;
        }

        @Override
        public Number getBadNumber() {
            return null;
        }
    }
}

