/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.VariableFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public class VariableFitsTableWriter
extends AbstractFitsTableWriter {
    private final Boolean longIndexing_;
    private final boolean allowSignedByte_;
    private final WideFits wide_;
    private StoragePolicy storagePolicy_;

    public VariableFitsTableWriter() {
        this(null, true, WideFits.DEFAULT);
    }

    public VariableFitsTableWriter(Boolean longIndexing, boolean allowSignedByte, WideFits wide) {
        super("fits-var");
        this.longIndexing_ = longIndexing;
        this.allowSignedByte_ = allowSignedByte;
        this.wide_ = wide;
        this.storagePolicy_ = StoragePolicy.getDefaultPolicy();
    }

    public void setStoragePolicy(StoragePolicy storagePolicy) {
        this.storagePolicy_ = storagePolicy;
    }

    @Override
    public boolean looksLikeFile(String location) {
        return false;
    }

    @Override
    protected FitsTableSerializer createSerializer(StarTable table) throws IOException {
        VariableFitsTableSerializer fitser = new VariableFitsTableSerializer(table, this.storagePolicy_, this.allowSignedByte_, this.wide_);
        if (this.longIndexing_ != null) {
            fitser.set64BitMode(this.longIndexing_);
        }
        return fitser;
    }
}

