/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.jdbc.SqlSyntax;

public class AdqlSyntax
extends SqlSyntax {
    public static final String[] ADQL_RESERVED = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CEILING", "COS", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "SIN", "SQRT", "TAN", "TOP", "TRUNCATE", "AREA", "BOX", "CENTROID", "CIRCLE", "CONTAINS", "COORD1", "COORD2", "COORDSYS", "DISTANCE", "INTERSECTS", "POINT", "POLYGON", "REGION"};
    private static final Pattern REGULAR_IDENTIFIER_REGEX = SQL92_IDENTIFIER_REGEX;
    private static final Pattern DELIMITED_IDENTIFIER_REGEX = Pattern.compile("\"(?:[^\"]|\"\")+\"");
    private static final Pattern CST_REGEX = AdqlSyntax.createCatalogSchemaTablePattern();
    private static final AdqlSyntax instance_ = new AdqlSyntax();

    private AdqlSyntax() {
        super(AdqlSyntax.getAllReservedWords(), REGULAR_IDENTIFIER_REGEX, '\"');
    }

    public boolean isAdqlDelimitedIdentifier(String token) {
        return DELIMITED_IDENTIFIER_REGEX.matcher(token).matches();
    }

    public boolean isAdqlColumnName(String token) {
        return this.isIdentifier(token) || this.isAdqlDelimitedIdentifier(token);
    }

    public boolean isAdqlTableName(String token) {
        return this.getCatalogSchemaTable(token) != null;
    }

    public String[] getCatalogSchemaTable(String tableName) {
        Matcher matcher;
        if (tableName != null && (matcher = CST_REGEX.matcher(tableName)).matches()) {
            return new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        }
        return null;
    }

    public String unquote(String identifier) {
        if (identifier == null) {
            return null;
        }
        int leng = identifier.length();
        if (leng > 0 && identifier.charAt(0) == '\"' && identifier.charAt(leng - 1) == '\"') {
            return identifier.substring(1, leng - 1).replaceAll("\"\"", "\"");
        }
        return identifier;
    }

    public String characterLiteral(String txt) {
        return "'" + txt.replaceAll("'", "''") + "'";
    }

    public static AdqlSyntax getInstance() {
        return instance_;
    }

    private static String[] getAllReservedWords() {
        ArrayList<String> reserved = new ArrayList<String>();
        reserved.addAll(Arrays.asList(SQL92_RESERVED));
        reserved.addAll(Arrays.asList(ADQL_RESERVED));
        return reserved.toArray(new String[0]);
    }

    private static Pattern createCatalogSchemaTablePattern() {
        String regularIdentifier = REGULAR_IDENTIFIER_REGEX.pattern();
        String delimitedIdentifier = DELIMITED_IDENTIFIER_REGEX.pattern();
        String identifierCapture = "(" + regularIdentifier + "|" + delimitedIdentifier + ")";
        String dot = "[.]";
        String catSchTab = "(?:" + identifierCapture + dot + ")??" + "(?:" + identifierCapture + dot + ")??" + identifierCapture;
        return Pattern.compile(catSchTab);
    }
}

