/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import adql.db.DBChecker;
import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DefaultDBColumn;
import adql.db.DefaultDBTable;
import adql.db.FunctionDef;
import adql.parser.ADQLParser;
import adql.parser.ParseException;
import adql.parser.QueryChecker;
import adql.parser.TokenMgrError;
import adql.query.ADQLQuery;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;

public class AdqlValidator {
    private final ADQLParser parser_ = new ADQLParser();
    private final QueryChecker checker_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public AdqlValidator(ValidatorTable[] vtables, FunctionDef[] udfs, String[] geoFuncs) {
        List<String> geoList;
        Collection<DBTable> tableList = vtables == null ? null : AdqlValidator.toDBTables(vtables);
        List<FunctionDef> udfList = udfs == null ? null : Arrays.asList(udfs);
        List<String> list = geoList = geoFuncs == null ? null : Arrays.asList(geoFuncs);
        if (tableList == null) {
            this.checker_ = null;
        } else {
            Collection<String> csysList = null;
            try {
                this.checker_ = new DBChecker(tableList, udfList, geoList, csysList);
            }
            catch (ParseException e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
    }

    public void validate(String query) throws Throwable {
        ADQLQuery pq = this.parser_.parseQuery(query);
        if (this.checker_ != null) {
            try {
                this.checker_.check(pq);
            }
            catch (ParseException e) {
                throw e;
            }
            catch (TokenMgrError e) {
                throw e;
            }
        }
    }

    public static AdqlValidator createValidator(ValidatorTable[] vtables, TapLanguage lang) {
        Map<String, TapLanguageFeature[]> featMap;
        Map<String, TapLanguageFeature[]> map = featMap = lang == null ? null : lang.getFeaturesMap();
        if (featMap == null) {
            featMap = new HashMap<String, TapLanguageFeature[]>();
        }
        TapLanguageFeature[] geoFeats = featMap.get("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
        ArrayList<String> geoList = new ArrayList<String>();
        if (geoFeats != null) {
            for (TapLanguageFeature geoFeat : geoFeats) {
                String fname = geoFeat.getForm();
                if (fname == null || fname.trim().length() <= 0) continue;
                geoList.add(fname.trim());
            }
        }
        String[] geoFuncs = geoList.size() > 0 ? geoList.toArray(new String[0]) : null;
        TapLanguageFeature[] udfFeats = featMap.get("ivo://ivoa.net/std/TAPRegExt#features-udf");
        ArrayList<FunctionDef> udfList = new ArrayList<FunctionDef>();
        if (udfFeats != null) {
            for (TapLanguageFeature udfFeat : udfFeats) {
                FunctionDef udf;
                String form = udfFeat.getForm();
                try {
                    udf = FunctionDef.parse(form);
                }
                catch (ParseException e) {
                    udf = null;
                    logger_.log(Level.WARNING, "Failed to parse UDF def \"" + form + "\"" + ": " + e, e);
                }
                if (udf == null) continue;
                udfList.add(udf);
            }
        }
        FunctionDef[] udfs = udfList.size() > 0 ? udfList.toArray(new FunctionDef[0]) : null;
        return new AdqlValidator(vtables, udfs, geoFuncs);
    }

    private static Collection<DBTable> toDBTables(ValidatorTable[] vtables) {
        ArrayList<DBTable> tList = new ArrayList<DBTable>();
        for (int i = 0; i < vtables.length; ++i) {
            tList.add(new ValidatorDBTable(vtables[i]));
        }
        return tList;
    }

    public static void main(String[] args) throws Throwable, IOException, SAXException {
        ValidatorTable[] vtables;
        String usage = "\n   Usage: " + AdqlValidator.class.getName() + " [-meta <tmeta-url>]" + " <query>" + "\n";
        SchemaMeta[] schMetas = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator<String> it = argList.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return;
            }
            if (!arg.equals("-meta") || !it.hasNext()) continue;
            it.remove();
            String loc = it.next();
            it.remove();
            schMetas = TableSetSaxHandler.readTableSet(new URL(loc), ContentCoding.GZIP);
        }
        if (argList.size() != 1) {
            System.err.println(usage);
            System.exit(1);
            return;
        }
        String query = argList.remove(0);
        if (schMetas != null) {
            ArrayList<1> vtList = new ArrayList<1>();
            for (void var10_10 : schMetas) {
                final String sname = var10_10.getName();
                for (TableMeta tmeta : var10_10.getTables()) {
                    ArrayList<String> colNames;
                    final String tname = tmeta.getName();
                    ColumnMeta[] cmetas = tmeta.getColumns();
                    if (cmetas == null) {
                        colNames = null;
                    } else {
                        colNames = new ArrayList<String>();
                        for (ColumnMeta cmeta : cmetas) {
                            colNames.add(cmeta.getName());
                        }
                    }
                    vtList.add(new ValidatorTable(){

                        @Override
                        public String getSchemaName() {
                            return sname;
                        }

                        @Override
                        public String getTableName() {
                            return tname;
                        }

                        @Override
                        public Collection<String> getColumnNames() {
                            return colNames;
                        }
                    });
                }
            }
            vtables = vtList.toArray(new ValidatorTable[0]);
        } else {
            vtables = null;
        }
        FunctionDef[] udfs = null;
        String[] geoFuncs = null;
        new AdqlValidator(vtables, udfs, geoFuncs).validate(query);
    }

    private static class ValidatorDBTable
    implements DBTable {
        private final ValidatorTable vtable_;
        private String name_;
        private String schemaName_;
        private String catalogName_;
        private AdqlSyntax syntax_;

        ValidatorDBTable(ValidatorTable vtable) {
            this.vtable_ = vtable;
            this.syntax_ = AdqlSyntax.getInstance();
            String[] names = this.syntax_.getCatalogSchemaTable(vtable.getTableName());
            if (names != null) {
                this.name_ = names[2];
                this.schemaName_ = vtable.getSchemaName();
                this.catalogName_ = names[0];
            } else {
                this.name_ = vtable.getTableName();
                this.schemaName_ = vtable.getSchemaName();
                this.catalogName_ = null;
            }
        }

        @Override
        public String getADQLName() {
            return this.syntax_.unquote(this.name_);
        }

        @Override
        public String getDBName() {
            return this.name_;
        }

        @Override
        public String getADQLSchemaName() {
            return this.syntax_.unquote(this.schemaName_);
        }

        @Override
        public String getDBSchemaName() {
            return this.schemaName_;
        }

        @Override
        public String getADQLCatalogName() {
            return this.syntax_.unquote(this.catalogName_);
        }

        @Override
        public String getDBCatalogName() {
            return this.catalogName_;
        }

        @Override
        public DBColumn getColumn(String colName, boolean isAdqlName) {
            Collection<String> cnames = this.vtable_.getColumnNames();
            if (cnames == null) {
                return this.createDBColumn(colName);
            }
            for (String cn : cnames) {
                if (!colName.equals(isAdqlName ? this.syntax_.unquote(cn) : cn)) continue;
                return this.createDBColumn(cn);
            }
            return null;
        }

        @Override
        public Iterator<DBColumn> iterator() {
            Collection<String> cnames = this.vtable_.getColumnNames();
            if (cnames == null) {
                return new ArrayList().iterator();
            }
            final Iterator<String> it = cnames.iterator();
            return new Iterator<DBColumn>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public DBColumn next() {
                    return ValidatorDBTable.this.createDBColumn((String)it.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public DBTable copy(String dbName, String adqlName) {
            String dfltName = DefaultDBTable.joinTableName(new String[]{this.catalogName_, this.schemaName_, this.name_});
            DefaultDBTable copy = new DefaultDBTable(dbName == null ? dfltName : dbName, adqlName == null ? dfltName : adqlName);
            for (DBColumn col : this) {
                copy.addColumn(col.copy(col.getDBName(), col.getADQLName(), copy));
            }
            return copy;
        }

        private DBColumn createDBColumn(String colName) {
            String rawColName = this.syntax_.unquote(colName);
            return new DefaultDBColumn(colName, rawColName, (DBTable)this);
        }
    }

    public static interface ValidatorTable {
        public String getTableName();

        public String getSchemaName();

        public Collection<String> getColumnNames();
    }
}

