/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.GlotsServiceFinder;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapServiceFinder;

public class AuxServiceFinder
implements TapServiceFinder {
    private final EndpointSet regtapEndpointSet_;
    private final ContentCoding coding_;
    private final AdqlSyntax syntax_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public AuxServiceFinder() {
        this(Endpoints.getRegTapEndpointSet(), ContentCoding.GZIP);
    }

    public AuxServiceFinder(EndpointSet regtapEndpointSet, ContentCoding coding) {
        this.regtapEndpointSet_ = regtapEndpointSet;
        this.coding_ = coding;
        this.syntax_ = AdqlSyntax.getInstance();
    }

    @Override
    public TapServiceFinder.Service[] readAllServices() throws IOException {
        String[] stringArray = new String[6];
        final String IVOID = "ivoid";
        stringArray[0] = "ivoid";
        final String NAME = "short_name";
        stringArray[1] = "short_name";
        final String TITLE = "res_title";
        stringArray[2] = "res_title";
        final String DESCRIP = "res_description";
        stringArray[3] = "res_description";
        final String URL2 = "access_url";
        stringArray[4] = "access_url";
        final String NTABLE = "ntable";
        stringArray[5] = "ntable";
        final String[] colNames = stringArray;
        String adql = new StringBuffer().append("SELECT").append("\n  ").append(GlotsServiceFinder.commaJoin(colNames)).append("\nFROM (").append("\n   SELECT DISTINCT").append("\n     ").append(GlotsServiceFinder.commaJoin(new String[]{IVOID, NAME, TITLE, DESCRIP, URL2})).append("\n   FROM rr.resource").append("\n   NATURAL JOIN rr.capability").append("\n   NATURAL JOIN rr.interface").append("\n   WHERE").append("\n      standard_id = 'ivo://ivoa.net/std/tap'").append("\n) AS serv").append("\nLEFT OUTER JOIN (").append("\n   SELECT").append("\n      access_url, COUNT(*) AS ntable").append("\n   FROM (").append("\n      SELECT DISTINCT").append("\n         table_name, access_url").append("\n      FROM rr.res_table").append("\n      NATURAL JOIN rr.capability").append("\n      NATURAL JOIN rr.interface").append("\n      WHERE").append("\n        standard_id LIKE 'ivo://ivoa.net/std/tap%'").append("\n   ) AS caps").append("\n   GROUP BY access_url").append("\n) AS tcount").append("\nUSING (access_url)").append("\nORDER BY ntable DESC").toString();
        this.logAdql(adql);
        TapQuery tq = new TapQuery(this.regtapEndpointSet_, adql, null);
        final ArrayList serviceList = new ArrayList();
        try {
            final int[] nrow = new int[1];
            boolean isTrunc = tq.executeSync(new TableSink(){

                @Override
                public void acceptRow(Object[] row) {
                    nrow[0] = nrow[0] + 1;
                    Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
                    final String id = valueMap.get(IVOID);
                    final String name = valueMap.get(NAME);
                    final String title = valueMap.get(TITLE);
                    final String descrip = valueMap.get(DESCRIP);
                    final String url = valueMap.get(URL2);
                    String ntableStr = valueMap.get(NTABLE);
                    int nt = -1;
                    if (ntableStr != null && ntableStr.matches("[0-9]+")) {
                        try {
                            nt = Integer.parseInt(ntableStr);
                        }
                        catch (RuntimeException e) {
                            // empty catch block
                        }
                    }
                    final int ntable = nt;
                    serviceList.add(new TapServiceFinder.Service(){

                        @Override
                        public String getId() {
                            return id;
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getTitle() {
                            return title;
                        }

                        @Override
                        public String getDescription() {
                            return descrip;
                        }

                        @Override
                        public String getServiceUrl() {
                            return url;
                        }

                        @Override
                        public int getTableCount() {
                            return ntable;
                        }
                    });
                }

                @Override
                public void acceptMetadata(StarTable meta) {
                }

                @Override
                public void endRows() {
                }
            }, this.coding_);
            this.logRows(isTrunc, nrow[0]);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error parsing VOTable result: " + e).initCause(e);
        }
        return serviceList.toArray(new TapServiceFinder.Service[0]);
    }

    @Override
    public TapServiceFinder.Table[] readSelectedTables(TapServiceFinder.Constraint constraint) throws IOException {
        String[] words = constraint.getKeywords();
        boolean isAnd = constraint.isAndKeywords();
        ArrayList<TapServiceFinder.Target> tTargets = new ArrayList<TapServiceFinder.Target>();
        for (TapServiceFinder.Target targ : constraint.getTargets()) {
            if (targ.isServiceMeta()) continue;
            assert (targ.getRrTablesCol() != null);
            tTargets.add(targ);
        }
        if (tTargets.size() == 0) {
            return new TapServiceFinder.Table[0];
        }
        String[] stringArray = new String[3];
        final String SERVICE_ID = "ivoid";
        stringArray[0] = "ivoid";
        final String NAME = "table_name";
        stringArray[1] = "table_name";
        final String DESCRIP = "table_description";
        stringArray[2] = "table_description";
        final String[] colNames = stringArray;
        StringBuffer sbuf = new StringBuffer().append("SELECT").append("\n  ").append(GlotsServiceFinder.commaJoin(colNames)).append("\nFROM (").append("\n   SELECT DISTINCT").append("\n      table_name, table_description, access_url").append("\n   FROM rr.res_table").append("\n   NATURAL JOIN rr.capability").append("\n   NATURAL JOIN rr.interface").append("\n   WHERE standard_id LIKE 'ivo://ivoa.net/std/tap%'").append("\n     AND (");
        for (int iw = 0; iw < words.length; ++iw) {
            sbuf.append("\n      ").append(iw == 0 ? "    " : (isAnd ? "AND " : " OR ")).append("(");
            String word = words[iw];
            for (int it = 0; it < tTargets.size(); ++it) {
                if (it > 0) {
                    sbuf.append(" OR\n           ");
                }
                sbuf.append(this.getAdqlTest(word, (TapServiceFinder.Target)((Object)tTargets.get(it))));
            }
            sbuf.append(")");
        }
        sbuf.append("\n     )").append("\n) AS tbl").append("\nJOIN (").append("\n   SELECT DISTINCT").append("\n      ivoid, access_url").append("\n   FROM rr.resource").append("\n   NATURAL JOIN rr.capability").append("\n   NATURAL JOIN rr.interface").append("\n   WHERE standard_id = 'ivo://ivoa.net/std/tap'").append("\n) AS serv").append("\nUSING (access_url)");
        String adql = sbuf.toString();
        this.logAdql(adql);
        TapQuery tq = new TapQuery(this.regtapEndpointSet_, adql, null);
        final ArrayList tableList = new ArrayList();
        try {
            final int[] nrow = new int[1];
            boolean isTrunc = tq.executeSync(new TableSink(){

                @Override
                public void acceptRow(Object[] row) {
                    nrow[0] = nrow[0] + 1;
                    Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
                    final String serviceId = valueMap.get(SERVICE_ID);
                    final String name = valueMap.get(NAME);
                    final String descrip = valueMap.get(DESCRIP);
                    tableList.add(new TapServiceFinder.Table(){

                        @Override
                        public String getServiceId() {
                            return serviceId;
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getDescription() {
                            return descrip;
                        }
                    });
                }

                @Override
                public void acceptMetadata(StarTable meta) {
                }

                @Override
                public void endRows() {
                }
            }, this.coding_);
            this.logRows(isTrunc, nrow[0]);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error parsing VOTable result: " + e).initCause(e);
        }
        return tableList.toArray(new TapServiceFinder.Table[0]);
    }

    private String getAdqlTest(String keyword, TapServiceFinder.Target target) {
        String auxName = target.getRrTablesCol();
        if (target.isWords()) {
            return new StringBuffer().append("1=ivo_hasWord(").append(auxName).append(", ").append(this.syntax_.characterLiteral(keyword)).append(")").toString();
        }
        return new StringBuffer().append("1=ivo_nocasematch(").append(auxName).append(", ").append(this.syntax_.characterLiteral("%" + keyword + "%")).append(")").toString();
    }

    private void logAdql(String adql) {
        logger_.info("Aux RegTAP query: " + adql.replaceAll("\\s+", " "));
        logger_.config("Aux RegTAP query:\n" + adql);
    }

    private void logRows(boolean isTrunc, int nrow) {
        if (isTrunc) {
            logger_.warning("Result truncated at " + nrow + " rows");
        } else {
            logger_.info("Received " + nrow + " rows");
        }
    }
}

