/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;

public class CadcTapMetaReader
implements TapMetaReader {
    private final URL url_;
    private final Config config_;
    private final ContentCoding coding_;
    private final Map<String, String> schemaMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public CadcTapMetaReader(URL tablesetUrl) {
        this(tablesetUrl, Config.POPULATE_SCHEMAS, ContentCoding.GZIP);
    }

    public CadcTapMetaReader(URL tablesetUrl, Config config, ContentCoding coding) {
        this.url_ = tablesetUrl;
        this.config_ = config;
        this.coding_ = coding;
        this.schemaMap_ = new HashMap<String, String>();
    }

    @Override
    public SchemaMeta[] readSchemas() throws IOException {
        SchemaMeta[] schemas = this.populateHandler("", this.config_.schemaDetail_).getSchemas(false);
        TapMetaPolicy.sortSchemas(schemas);
        int nTable = 0;
        int nHasCols = 0;
        int nHasFkeys = 0;
        boolean popTables = this.config_.populateTables_;
        for (SchemaMeta schema : schemas) {
            String sname = schema.getName();
            TableMeta[] tables = schema.getTables();
            if (tables == null) continue;
            TapMetaPolicy.sortTables(tables);
            for (TableMeta table : tables) {
                ForeignMeta[] fkeys;
                ++nTable;
                this.schemaMap_.put(table.getName(), sname);
                if (popTables) continue;
                ColumnMeta[] cols = table.getColumns();
                if (cols != null) {
                    if (cols.length == 0) {
                        table.setColumns(null);
                    } else {
                        ++nHasCols;
                    }
                }
                if ((fkeys = table.getForeignKeys()) == null) continue;
                if (fkeys.length == 0) {
                    table.setForeignKeys(null);
                    continue;
                }
                ++nHasFkeys;
            }
        }
        if (!(popTables || nHasCols <= 0 && nHasFkeys <= 0)) {
            logger_.warning("Got unexpected table content metadata (" + nTable + " tables: " + nHasCols + " with cols, " + nHasFkeys + " with fkeys) " + "- might as well keep it");
        }
        return schemas;
    }

    @Override
    public TableMeta[] readTables(SchemaMeta schema) throws IOException {
        String sname = schema.getName();
        SchemaMeta[] schemas = this.populateHandler("/" + sname, this.config_.tableDetail_).getSchemas(false);
        int ns = schemas.length;
        if (ns == 1) {
            TableMeta[] tables = schemas[0].getTables();
            TapMetaPolicy.sortTables(tables);
            for (TableMeta table : tables) {
                this.schemaMap_.put(table.getName(), sname);
            }
            return tables;
        }
        if (ns == 0) {
            throw new IOException("No schemas");
        }
        throw new IOException("Non-unique schema");
    }

    @Override
    public ColumnMeta[] readColumns(TableMeta table) throws IOException {
        return this.readSingleTable(table).getColumns();
    }

    @Override
    public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
        return this.readSingleTable(table).getForeignKeys();
    }

    @Override
    public String getSource() {
        return this.url_.toString();
    }

    @Override
    public String getMeans() {
        return "CADC-variant VOSI TableSet, " + (Object)((Object)this.config_);
    }

    private TableSetSaxHandler populateHandler(String subPath, String detail) throws IOException {
        String surl = this.url_.toString();
        if (subPath != null && subPath.length() > 0) {
            surl = surl + "/" + subPath;
        }
        if (detail != null && detail.length() > 0) {
            surl = surl + "?detail=" + detail;
        }
        URL url = new URL(surl);
        logger_.info("Reading table metadata from " + url);
        try {
            return TableSetSaxHandler.populateHandler(url, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Invalid TableSet XML document").initCause(e);
        }
    }

    private TableMeta readSingleTable(TableMeta table) throws IOException {
        String tname = table.getName();
        String sname = this.schemaMap_.get(tname);
        if (sname != null) {
            String subPath = sname + "/" + tname;
            TableSetSaxHandler tsHandler = this.populateHandler(subPath, "");
            ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
            tlist.addAll(Arrays.asList(tsHandler.getNakedTables()));
            for (SchemaMeta schema : tsHandler.getSchemas(false)) {
                TableMeta[] tables = schema.getTables();
                if (tables == null) continue;
                tlist.addAll(Arrays.asList(tables));
            }
            TableMeta[] tables = tlist.toArray(new TableMeta[0]);
            int nt = tables.length;
            if (nt == 1) {
                return tables[0];
            }
            throw new IOException((nt == 0 ? "No table element" : "Multiple table elements") + " at " + this.url_ + subPath);
        }
        throw new IOException("Table " + tname + " in unknown schema");
    }

    public static enum Config {
        POPULATE_NONE(false, "schema", "table"),
        POPULATE_SCHEMAS(false, "table", "table"),
        POPULATE_SCHEMAS_AND_TABLES(true, "", "");

        private boolean populateTables_;
        private final String schemaDetail_;
        private final String tableDetail_;

        private Config(boolean populateTables, String schemaDetail, String tableDetail) {
            this.populateTables_ = populateTables;
            this.schemaDetail_ = schemaDetail;
            this.tableDetail_ = tableDetail;
        }
    }
}

