/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.DalResultXMLFilter;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.votable.VOElementFactory;

public class DalQuery {
    private final CgiQuery cgi_;
    private final String serviceType_;
    private final ContentCoding coding_;
    private String name_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public DalQuery(RegResource resource, RegCapabilityInterface capability, String serviceType, double raPos, double decPos, double size) {
        this(capability.getAccessUrl(), serviceType, raPos, decPos, size, ContentCoding.GZIP);
        String id = null;
        if (id == null) {
            id = resource.getShortName();
        }
        if (id == null) {
            id = resource.getTitle();
        }
        if (id != null) {
            this.name_ = id;
        }
    }

    public DalQuery(String baseURL, String serviceType, double raPos, double decPos, double size, ContentCoding coding) {
        this.cgi_ = new CgiQuery(baseURL);
        this.name_ = baseURL;
        this.serviceType_ = serviceType;
        this.coding_ = coding;
        this.addArgument("POS", this.doubleToString(raPos) + "," + this.doubleToString(decPos));
        if (!Double.isNaN(size)) {
            this.addArgument("SIZE", this.doubleToString(size));
        }
    }

    public void addArgument(String name, String value) {
        this.cgi_.addArgument(name, value);
    }

    public StarTable execute(StarTableFactory tfact) throws IOException {
        URL qurl = this.cgi_.toURL();
        logger_.info("Submitting query: " + qurl);
        VOElementFactory vofact = new VOElementFactory(tfact.getStoragePolicy());
        InputSource inSrc = new InputSource(this.coding_.openStream(qurl));
        inSrc.setSystemId(qurl.toString());
        return DalResultXMLFilter.getDalResultTable(vofact, inSrc);
    }

    public String toString() {
        return this.name_;
    }

    public String doubleToString(double value) {
        return CgiQuery.formatDouble(value);
    }
}

