/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.TableContentHandler;
import uk.ac.starlink.votable.TableHandler;

public class DalResultStreamer
extends TableContentHandler
implements TableHandler {
    private final TableSink sink_;
    private final Namespacing namespacing_;
    private boolean resultsStarted_;
    private boolean gotTable_;
    private boolean isVotable_;
    private boolean isResults_;
    private boolean isStatus_;
    private String statusValue_;
    private StringBuffer statusContent_;
    private boolean overflow_;
    private static final boolean STRICT = false;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public DalResultStreamer(TableSink sink) {
        super(false);
        this.setTableHandler(null);
        this.setReadHrefTables(false);
        this.sink_ = sink;
        this.namespacing_ = Namespacing.getInstance();
    }

    public boolean getOverflow() {
        return this.overflow_;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        String tagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        if ("VOTABLE".equals(tagName)) {
            this.isVotable_ = true;
        }
        if ("RESOURCE".equals(tagName) && "results".equals(atts.getValue("type"))) {
            if (this.isResults_ || this.resultsStarted_) {
                String msg = "Multiple RESOURCE/@type='results' elements";
                throw new SAXParseException(msg, this.getLocator());
            }
            this.resultsStarted_ = true;
            this.isResults_ = true;
            this.setReadHrefTables(true);
            this.setTableHandler(this);
        } else if ("INFO".equals(tagName) && this.isResults_ && "QUERY_STATUS".equals(atts.getValue("name"))) {
            if (this.isStatus_) {
                String msg = "Nested INFO/@name='QUERY_STATUS' elements";
                throw new SAXParseException(msg, this.getLocator());
            }
            this.isStatus_ = true;
            this.statusValue_ = atts.getValue("value");
            this.statusContent_ = new StringBuffer();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        String tagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        if ("RESOURCE".equals(tagName) && this.isResults_) {
            this.isResults_ = false;
            this.setReadHrefTables(false);
            this.setTableHandler(null);
        } else if ("INFO".equals(tagName) && this.isStatus_) {
            this.isStatus_ = false;
            if ("ERROR".equals(this.statusValue_)) {
                String msg = "Service Error: \"" + this.statusContent_.toString().trim() + "\"";
                throw new SAXParseException(msg, this.getLocator());
            }
            if (!"OK".equals(this.statusValue_) && "OVERFLOW".equals(this.statusValue_)) {
                this.overflow_ = true;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.isStatus_) {
            this.statusContent_.append(ch, start, length);
        }
    }

    public void startTable(StarTable meta) throws SAXException {
        try {
            this.sink_.acceptMetadata(meta);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    public void rowData(Object[] row) throws SAXException {
        try {
            this.sink_.acceptRow(row);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    public void endTable() throws SAXException {
        try {
            this.sink_.endRows();
            this.gotTable_ = true;
        }
        catch (IOException e) {
            throw new SAXParseException(e.getMessage(), this.getLocator(), e);
        }
    }

    public static boolean streamResultTable(InputSource saxsrc, TableSink sink) throws IOException, SAXException {
        XMLReader parser;
        DalResultStreamer streamer = new DalResultStreamer(sink);
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            streamer.namespacing_.configureSAXParserFactory(spfact);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage(), e).initCause(e);
        }
        parser.setContentHandler((ContentHandler)((Object)streamer));
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        try {
            parser.parse(saxsrc);
        }
        catch (CharConversionException e) {
            if (streamer.isVotable_) {
                throw e;
            }
            throw new TableFormatException("Bad XML characters", e);
        }
        catch (SAXException e) {
            if (streamer.isVotable_) {
                throw e;
            }
            throw new TableFormatException(e);
        }
        if (!streamer.isVotable_) {
            throw new IOException("No VOTABLE element found");
        }
        if (!streamer.gotTable_) {
            throw new IOException("No TABLE element found");
        }
        return streamer.overflow_;
    }
}

