/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.KeywordServiceQueryFactory;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.RegistryProtocol;
import uk.ac.starlink.vo.RegistryQueryFactory;
import uk.ac.starlink.vo.RegistryServiceTableLoadDialog;

public abstract class DalTableLoadDialog
extends RegistryServiceTableLoadDialog {
    private final String protoName_;
    private final Capability capability_;
    private final boolean autoQuery_;
    private final RegistryQueryFactory queryFactory_;
    private JTextField urlField_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    protected DalTableLoadDialog(String name, String protoName, String description, Capability capability, boolean showCapabilities, boolean autoQuery) {
        super(name, protoName, description, new KeywordServiceQueryFactory(capability), showCapabilities);
        this.protoName_ = protoName;
        this.capability_ = capability;
        this.autoQuery_ = autoQuery;
        this.queryFactory_ = (KeywordServiceQueryFactory)this.getQueryFactory();
    }

    @Override
    protected Component createQueryComponent() {
        JPanel queryPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                DalTableLoadDialog.this.urlField_.setEnabled(enabled);
            }
        };
        queryPanel.add(super.createQueryComponent(), "Center");
        this.urlField_ = new JTextField();
        Box urlBox = Box.createHorizontalBox();
        urlBox.add(new JLabel(this.protoName_ + " URL: "));
        urlBox.add(this.urlField_);
        this.getControlBox().add(urlBox);
        this.getControlBox().add(Box.createVerticalStrut(5));
        final RegistryPanel regPanel = this.getRegistryPanel();
        ListSelectionListener selListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegCapabilityInterface[] caps = regPanel.getSelectedCapabilities();
                DalTableLoadDialog.this.urlField_.setText(caps.length == 1 ? caps[0].getAccessUrl() : null);
                DalTableLoadDialog.this.urlField_.setCaretPosition(0);
            }
        };
        regPanel.getResourceSelectionModel().addListSelectionListener(selListener);
        regPanel.getCapabilitySelectionModel().addListSelectionListener(selListener);
        this.urlField_.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                DalTableLoadDialog.this.updateReady();
            }
        });
        this.updateReady();
        regPanel.addActionListener(this.getSubmitAction());
        ArrayList<JMenu> menuList = new ArrayList<JMenu>(Arrays.asList(this.getMenus()));
        JMenu regMenu = new JMenu("Registry");
        regMenu.setMnemonic(82);
        for (JMenuItem item : Arrays.asList(this.getRegistryMenuItems())) {
            regMenu.add(item);
        }
        menuList.add(regMenu);
        this.setMenus(menuList.toArray(new JMenu[0]));
        if (this.autoQuery_) {
            regPanel.performAutoQuery("Searching registry for all known " + this.protoName_ + " services");
        } else {
            regPanel.displayAdviceMessage(new String[]{"Query registry for " + this.protoName_ + " services:", "enter keywords like \"2mass qso\" and click " + this.getRegistryPanel().getSubmitQueryAction().getValue("Name") + ".", " ", "Alternatively, enter " + this.protoName_ + " URL in field below."});
        }
        return queryPanel;
    }

    @Override
    public boolean isReady() {
        String txt = this.urlField_.getText();
        if (txt == null || txt.trim().length() == 0) {
            return false;
        }
        try {
            new URL(txt);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public String getServiceUrl() {
        return this.urlField_.getText();
    }

    public void setServiceUrl(String url) {
        this.urlField_.setText(url);
    }

    public JTextField getServiceUrlField() {
        return this.urlField_;
    }

    public URL checkUrl(String url) {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("No " + this.protoName_ + " service selected");
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Bad " + this.protoName_ + " service URL");
        }
    }

    public DescribedValue[] getResourceMetadata(String serviceUrl) {
        RegistryPanel regPanel = this.getRegistryPanel();
        RegResource[] resources = regPanel.getSelectedResources();
        RegCapabilityInterface[] caps = regPanel.getSelectedCapabilities();
        return resources.length == 1 && caps.length == 1 && serviceUrl.equals(caps[0].getAccessUrl()) ? this.getMetadata(resources[0], caps[0]) : new DescribedValue[]{};
    }

    public DescribedValue[] getMetadata(RegResource resource, RegCapabilityInterface cap) {
        ArrayList metadata = new ArrayList();
        DalTableLoadDialog.addMetadatum(metadata, resource.getShortName(), "Service short name", "Short name for " + this.protoName_ + " service");
        DalTableLoadDialog.addMetadatum(metadata, resource.getTitle(), "Service title", this.protoName_ + " service title");
        DalTableLoadDialog.addMetadatum(metadata, resource.getIdentifier(), "Identifier", "Unique resource registry identifier");
        DalTableLoadDialog.addMetadatum(metadata, resource.getPublisher(), "Service publisher", "Publisher for " + this.protoName_ + " service");
        DalTableLoadDialog.addMetadatum(metadata, resource.getReferenceUrl(), "Service reference URL", "Descriptive URL for search resource");
        DalTableLoadDialog.addMetadatum(metadata, resource.getContact(), "Contact person", "Individual to contact about this service");
        return metadata.toArray(new DescribedValue[0]);
    }

    @Override
    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        RegistryProtocol regProto = this.getQueryFactory().getRegistrySelector().getModel().getProtocol();
        RegCapabilityInterface[] caps = super.getCapabilities(resource);
        ArrayList<RegCapabilityInterface> capList = new ArrayList<RegCapabilityInterface>();
        for (int i = 0; i < caps.length; ++i) {
            if (!regProto.hasCapability(this.capability_, caps[i])) continue;
            capList.add(caps[i]);
        }
        return capList.toArray(new RegCapabilityInterface[0]);
    }

    private static void addMetadatum(List metadata, String value, String name, String description) {
        if (value != null && value.trim().length() > 0) {
            DefaultValueInfo info = new DefaultValueInfo(name, String.class, description);
            metadata.add(new DescribedValue(info, value));
        }
    }
}

