/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.ValueConverter;

public class DoubleValueField {
    private final DefaultValueInfo info_;
    private final JLabel label_;
    private final JTextField entryField_;
    private final JComboBox convSelector_;

    public DoubleValueField(String name, ValueConverter[] convs) {
        this(new DefaultValueInfo(name, Double.class, ""), convs);
    }

    public DoubleValueField(ValueInfo info, ValueConverter[] convs) {
        this.info_ = new DefaultValueInfo(info);
        this.label_ = new JLabel(this.info_.getName() + ": ");
        this.entryField_ = new JTextField(12){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(32, super.getPreferredSize().height);
            }
        };
        this.convSelector_ = new JComboBox<ValueConverter>(convs);
        this.convSelector_.setSelectedIndex(0);
        String description = info.getDescription();
        if (description != null) {
            this.setDescription(description);
        }
    }

    public DefaultValueInfo getValueInfo() {
        return this.info_;
    }

    public void setDescription(String description) {
        this.info_.setDescription(description);
        this.label_.setToolTipText(description);
        this.entryField_.setToolTipText(description);
    }

    public DescribedValue getDescribedValue() {
        Double val;
        try {
            val = new Double(this.getValue());
        }
        catch (Exception e) {
            val = null;
        }
        return new DescribedValue(this.info_, val);
    }

    public JLabel getLabel() {
        return this.label_;
    }

    public JTextField getEntryField() {
        return this.entryField_;
    }

    public JComboBox getConverterSelector() {
        return this.convSelector_;
    }

    public double getValue() {
        ValueConverter vc = (ValueConverter)this.convSelector_.getSelectedItem();
        try {
            return vc.convertValue(this.getEntryField().getText());
        }
        catch (RuntimeException e) {
            String msg = "Invalid value for " + this.info_.getName() + " field";
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
    }

    public void setValue(double value) {
        ValueConverter vc = (ValueConverter)this.convSelector_.getSelectedItem();
        try {
            this.getEntryField().setText(vc.unconvertValue(new Double(value)));
        }
        catch (RuntimeException e) {
            String msg = "Invalid value for " + this.info_.getName() + " field";
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.entryField_.setEnabled(enabled);
        this.convSelector_.setEnabled(enabled);
        this.label_.setEnabled(enabled);
    }

    public static DoubleValueField makeRADegreesField() {
        DefaultValueInfo info = new DefaultValueInfo("RA", Double.class, "Right Ascension");
        info.setUnitString("Degrees");
        return new DoubleValueField(info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.HMSDegreesValueConverter(), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }

    public static DoubleValueField makeDecDegreesField() {
        DefaultValueInfo info = new DefaultValueInfo("Dec", Double.class, "Declination");
        info.setUnitString("Degrees");
        return new DoubleValueField(info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.DMSDegreesValueConverter(), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }

    public static DoubleValueField makeSizeDegreesField(ValueInfo info) {
        if (info instanceof DefaultValueInfo) {
            ((DefaultValueInfo)info).setUnitString("Degrees");
        }
        return new DoubleValueField(info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.UnitValueConverter("arcmin", 0.016666666666666666), new ValueConverter.UnitValueConverter("arcsec", 2.777777777777778E-4), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }
}

